/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import org.eclipse.jetty.ee10.servlet.AsyncContextState;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.thread.Scheduler;

public class AsyncContextEvent
extends AsyncEvent
implements Runnable {
    private final ServletContext _servletContext;
    private final ServletContextHandler.ServletScopedContext _context;
    private final AsyncContextState _asyncContext;
    private final HttpURI _baseURI;
    private final ServletChannelState _state;
    private ServletContext _dispatchContext;
    private String _dispatchPath;
    private volatile Scheduler.Task _timeoutTask;
    private Throwable _throwable;

    public AsyncContextEvent(ServletContextHandler.ServletScopedContext context, AsyncContextState asyncContext, ServletChannelState state, ServletRequest request, ServletResponse response) {
        super(null, request, response, null);
        HttpURI.Immutable immutable;
        this._context = context;
        this._asyncContext = asyncContext;
        this._servletContext = ServletContextHandler.getServletContext(context);
        this._state = state;
        if (request == null) {
            immutable = null;
        } else if (request instanceof HttpServletRequest) {
            HttpServletRequest hr = (HttpServletRequest)request;
            immutable = HttpURI.from(hr.getRequestURI());
        } else {
            immutable = null;
        }
        this._baseURI = immutable;
    }

    public HttpURI getBaseURI() {
        return this._baseURI;
    }

    public ServletChannelState getServletRequestState() {
        return this._state;
    }

    public ServletContext getSuspendedContext() {
        return this._servletContext;
    }

    public ServletContext getDispatchContext() {
        return this._dispatchContext;
    }

    public ServletContext getServletContext() {
        return this._dispatchContext == null ? this._servletContext : this._dispatchContext;
    }

    public ServletContextHandler.ServletScopedContext getContext() {
        return this._context;
    }

    public void setTimeoutTask(Scheduler.Task task) {
        this._timeoutTask = task;
    }

    public boolean hasTimeoutTask() {
        return this._timeoutTask != null;
    }

    public void cancelTimeoutTask() {
        Scheduler.Task task = this._timeoutTask;
        this._timeoutTask = null;
        if (task != null) {
            task.cancel();
        }
    }

    public AsyncContext getAsyncContext() {
        return this._asyncContext;
    }

    public Throwable getThrowable() {
        return this._throwable;
    }

    public void setDispatchContext(ServletContext context) {
        this._dispatchContext = context;
    }

    public String getDispatchPath() {
        return this._dispatchPath;
    }

    public void setDispatchPath(String path) {
        this._dispatchPath = path;
    }

    public void completed() {
        this._timeoutTask = null;
        this._asyncContext.reset();
    }

    @Override
    public void run() {
        Scheduler.Task task = this._timeoutTask;
        this._timeoutTask = null;
        if (task != null) {
            this._state.timeout();
        }
    }

    public void addThrowable(Throwable e) {
        if (this._throwable == null) {
            this._throwable = e;
        } else if (e != this._throwable) {
            this._throwable.addSuppressed(e);
        }
    }
}

