/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenHashMap<K, V>
extends AbstractMap<K, V>
implements Cloneable {
    static final int[] primeCapacities = new int[]{3, 5, 7, 11, 17, 23, 31, 37, 43, 47, 67, 79, 89, 97, 137, 163, 179, 197, 277, 311, 331, 359, 379, 397, 433, 557, 599, 631, 673, 719, 761, 797, 877, 953, 1039, 1117, 1201, 1277, 1361, 1439, 1523, 1597, 1759, 1907, 2081, 2237, 2411, 2557, 2729, 2879, 3049, 3203, 3527, 3821, 4177, 4481, 4831, 5119, 5471, 5779, 6101, 6421, 7057, 7643, 8363, 8963, 9677, 10243, 10949, 11579, 12203, 12853, 14143, 15287, 16729, 17929, 19373, 20507, 21911, 23159, 24407, 25717, 28289, 30577, 33461, 35863, 38747, 41017, 43853, 46327, 48817, 51437, 56591, 61169, 66923, 71741, 77509, 82037, 87719, 92657, 97649, 102877, 113189, 122347, 133853, 143483, 155027, 164089, 175447, 185323, 195311, 205759, 226379, 244703, 267713, 286973, 310081, 328213, 350899, 370661, 390647, 411527, 452759, 489407, 535481, 573953, 620171, 656429, 701819, 741337, 781301, 823117, 905551, 978821, 1070981, 0x118411, 1240361, 1312867, 1403641, 1482707, 1562611, 1646237, 1811107, 1957651, 2141977, 2295859, 2480729, 2625761, 2807303, 2965421, 3125257, 3292489, 3622219, 3915341, 4283963, 4591721, 0x4BB4B3, 5251529, 5614657, 5930887, 6250537, 6584983, 7244441, 7830701, 8567929, 9183457, 9922933, 10503061, 11229331, 11861791, 12501169, 13169977, 14488931, 15661423, 17135863, 18366923, 19845871, 21006137, 22458671, 23723597, 25002389, 26339969, 28977863, 31322867, 34271747, 36733847, 39691759, 42012281, 44917381, 47447201, 50004791, 52679969, 57955739, 62645741, 68543509, 73467739, 79383533, 84024581, 89834777, 94894427, 100009607, 105359939, 115911563, 125291483, 137087021, 146935499, 158767069, 168049163, 179669557, 189788857, 200019221, 210719881, 231823147, 250582987, 274174111, 293871013, 317534141, 336098327, 359339171, 379577741, 400038451, 421439783, 463646329, 501165979, 548348231, 587742049, 635068283, 672196673, 718678369, 759155483, 800076929, 842879579, 927292699, 1002331963, 1096696463, 1175484103, 1270136683, 1344393353, 1437356741, 1518310967, 1600153859, 1685759167, 1854585413, 2004663929, Integer.MAX_VALUE};
    static final int largestPrime = primeCapacities[primeCapacities.length - 1];
    protected static final int defaultCapacity = 277;
    protected static final double defaultMinLoadFactor = 0.2;
    protected static final double defaultMaxLoadFactor = 0.5;
    protected static final Object FREE = null;
    protected static final Object REMOVED = new Object();
    protected int distinct;
    protected int lowWaterMark;
    protected int highWaterMark;
    protected double minLoadFactor;
    protected double maxLoadFactor;
    protected Object[] table;
    protected Object[] values;
    protected int freeEntries;

    public OpenHashMap() {
        this(277);
    }

    public OpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, FREE);
        Arrays.fill(this.values, null);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public OpenHashMap<K, V> clone() {
        try {
            OpenHashMap copy = (OpenHashMap)super.clone();
            copy.table = (Object[])copy.table.clone();
            copy.values = (Object[])copy.values.clone();
            return copy;
        }
        catch (CloneNotSupportedException exc) {
            InternalError e = new InternalError();
            e.initCause(exc);
            throw e;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    @Override
    public V get(Object key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return null;
        }
        return (V)this.values[i];
    }

    protected int indexOfInsertion(K key) {
        Object[] tab = this.table;
        int length = tab.length;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.table[i] != FREE && this.table[i] != REMOVED && !OpenHashMap.equalsMindTheNull(key, tab[i])) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.table[i] == REMOVED) {
            int j = i;
            while (this.table[i] != FREE && (this.table[i] == REMOVED || tab[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (this.table[i] == FREE) {
                i = j;
            }
        }
        if (this.table[i] != FREE && this.table[i] != REMOVED) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(K key) {
        Object[] tab = this.table;
        int length = tab.length;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (!(tab[i] == FREE || tab[i] != REMOVED && OpenHashMap.equalsMindTheNull(key, tab[i]))) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (tab[i] == FREE) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(V value) {
        Object[] val = this.values;
        int i = this.values.length;
        while (--i >= 0) {
            if (this.table[i] == FREE || this.table[i] == REMOVED || !OpenHashMap.equalsMindTheNull(val[i], value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public V put(K key, V value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            Object previous = this.values[i];
            this.values[i] = value;
            return (V)previous;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        if (this.table[i] == FREE) {
            --this.freeEntries;
        }
        this.table[i] = key;
        this.values[i] = value;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return null;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        Object[] oldTable = this.table;
        Object[] oldValues = this.values;
        Object[] newTable = new Object[newCapacity];
        Object[] newValues = new Object[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.values = newValues;
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldTable[i] == FREE || oldTable[i] == REMOVED) continue;
            Object element = oldTable[i];
            int index = this.indexOfInsertion(element);
            newTable[index] = element;
            newValues[index] = oldValues[i];
        }
    }

    @Override
    public V remove(Object key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return null;
        }
        Object removed = this.values[i];
        this.table[i] = REMOVED;
        this.values[i] = null;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return (V)removed;
    }

    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial Capacity must not be less than zero: " + initialCapacity);
        }
        if (minLoadFactor < 0.0 || minLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + minLoadFactor);
        }
        if (maxLoadFactor <= 0.0 || maxLoadFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal maxLoadFactor: " + maxLoadFactor);
        }
        if (minLoadFactor >= maxLoadFactor) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + minLoadFactor + " and maxLoadFactor: " + maxLoadFactor);
        }
        int capacity = initialCapacity;
        if ((capacity = this.nextPrime(capacity)) == 0) {
            capacity = 1;
        }
        this.table = new Object[capacity];
        this.values = new Object[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == largestPrime ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    public void concat() {
        int newCap = this.nextPrime(this.size() + 1);
        if (newCap != this.table.length) {
            this.rehash(newCap);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    protected int chooseGrowCapacity(int size, double minLoad, double maxLoad) {
        return this.nextPrime(Math.max(size + 1, (int)((double)(4 * size) / (3.0 * minLoad + maxLoad))));
    }

    protected int chooseHighWaterMark(int capacity, double maxLoad) {
        return Math.min(capacity - 2, (int)((double)capacity * maxLoad));
    }

    protected int chooseLowWaterMark(int capacity, double minLoad) {
        return (int)((double)capacity * minLoad);
    }

    protected int chooseShrinkCapacity(int size, double minLoad, double maxLoad) {
        return this.nextPrime(Math.max(size + 1, (int)((double)(4 * size) / (minLoad + 3.0 * maxLoad))));
    }

    protected int nextPrime(int desiredCapacity) {
        int i = Arrays.binarySearch(primeCapacities, desiredCapacity);
        if (i < 0) {
            i = -i - 1;
        }
        return primeCapacities[i];
    }

    @Override
    public int size() {
        return this.distinct;
    }

    protected static boolean equalsMindTheNull(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        int idx = -1;
        Map.Entry<K, V> next;

        EntrySetIterator() {
            this.forward();
        }

        private void forward() {
            this.next = null;
            while (this.next == null && ++this.idx < OpenHashMap.this.table.length) {
                if (OpenHashMap.this.table[this.idx] == FREE || OpenHashMap.this.table[this.idx] == REMOVED) continue;
                this.next = new AbstractMap.SimpleImmutableEntry<Object, Object>(OpenHashMap.this.table[this.idx], OpenHashMap.this.values[this.idx]);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Map.Entry n = this.next;
            this.forward();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return OpenHashMap.this.size();
        }
    }
}

