/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.capabilityset.Attribute;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.resolver.Content;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.CapabilityImpl;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtensionManager
extends URLStreamHandler
implements Content {
    static final ExtensionManager m_extensionManager;
    private final Logger m_logger;
    private final Map m_headerMap = new StringMap(false);
    private final Module m_systemBundleModule;
    private List<Capability> m_capabilities = null;
    private Set m_exportNames = null;
    private Object m_securityContext = null;
    private final List m_extensions;
    private volatile Bundle[] m_extensionsCache;
    private final Set m_names;
    private final Map m_sourceToExtensions;
    static /* synthetic */ Class class$org$apache$felix$framework$Felix;

    private ExtensionManager() {
        this.m_logger = null;
        this.m_systemBundleModule = null;
        this.m_extensions = new ArrayList();
        this.m_extensionsCache = new Bundle[0];
        this.m_names = new HashSet();
        this.m_sourceToExtensions = new HashMap();
    }

    ExtensionManager(Logger logger, Felix felix) {
        this.m_systemBundleModule = new ExtensionManagerModule(felix);
        this.m_extensions = null;
        this.m_extensionsCache = null;
        this.m_names = null;
        this.m_sourceToExtensions = null;
        this.m_logger = logger;
        this.m_headerMap.put("Bundle-Version", felix.getConfig().get("felix.version"));
        this.m_headerMap.put("Bundle-SymbolicName", "org.apache.felix.framework");
        this.m_headerMap.put("Bundle-Name", "System Bundle");
        this.m_headerMap.put("Bundle-Description", "This bundle is system specific; it implements various system services.");
        this.m_headerMap.put("Export-Service", "org.osgi.service.packageadmin.PackageAdmin,org.osgi.service.startlevel.StartLevel,org.osgi.service.url.URLHandlers");
        String syspkgs = (String)felix.getConfig().get("org.osgi.framework.system.packages");
        syspkgs = syspkgs == null ? Util.getDefaultProperty(logger, "org.osgi.framework.system.packages") : syspkgs;
        syspkgs = syspkgs == null ? "" : syspkgs;
        String extra = (String)felix.getConfig().get("org.osgi.framework.system.packages.extra");
        syspkgs = extra == null ? syspkgs : new StringBuffer().append(syspkgs).append(",").append(extra).toString();
        this.m_headerMap.put("Bundle-ManifestVersion", "2");
        this.m_headerMap.put("Export-Package", syspkgs);
        try {
            ManifestParser mp = new ManifestParser(this.m_logger, felix.getConfig(), this.m_systemBundleModule, this.m_headerMap);
            List<Capability> caps = ExtensionManager.aliasSymbolicName(mp.getCapabilities());
            this.setCapabilities(caps);
        }
        catch (Exception ex) {
            this.m_capabilities = new ArrayList<Capability>(0);
            this.m_logger.log(felix, 1, new StringBuffer().append("Error parsing system bundle export statement: ").append(syspkgs).toString(), (Throwable)ex);
        }
    }

    private static List<Capability> aliasSymbolicName(List<Capability> caps) {
        if (caps == null) {
            return new ArrayList<Capability>(0);
        }
        ArrayList<Capability> aliasCaps = new ArrayList<Capability>(caps);
        block0: for (int capIdx = 0; capIdx < aliasCaps.size(); ++capIdx) {
            List<Attribute> attrs = ((Capability)aliasCaps.get(capIdx)).getAttributes();
            for (int i = 0; i < attrs.size(); ++i) {
                if (!attrs.get(i).getName().equalsIgnoreCase("bundle-symbolic-name")) continue;
                ArrayList<Attribute> aliasAttrs = new ArrayList<Attribute>(attrs);
                aliasAttrs.set(i, new Attribute("bundle-symbolic-name", new String[]{(String)attrs.get(i).getValue(), "system.bundle"}, false));
                aliasCaps.set(capIdx, new CapabilityImpl(caps.get(capIdx).getModule(), caps.get(capIdx).getNamespace(), caps.get(capIdx).getDirectives(), aliasAttrs));
                continue block0;
            }
        }
        return aliasCaps;
    }

    public Module getModule() {
        return this.m_systemBundleModule;
    }

    public synchronized Object getSecurityContext() {
        return this.m_securityContext;
    }

    public synchronized void setSecurityContext(Object securityContext) {
        this.m_securityContext = securityContext;
    }

    synchronized void addExtensionBundle(Felix felix, BundleImpl bundle) throws SecurityException, BundleException, Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(bundle, "extensionLifecycle"));
            }
            catch (SecurityException ex) {
                throw new AccessControlException(ex.getMessage());
            }
        }
        if (!((BundleProtectionDomain)bundle.getProtectionDomain()).impliesDirect(new AllPermission())) {
            throw new SecurityException("Extension Bundles must have AllPermission");
        }
        Directive dir = ManifestParser.parseExtensionBundleHeader((String)bundle.getCurrentModule().getHeaders().get("Fragment-Host"));
        if (!"framework".equals(dir.getValue())) {
            throw new BundleException(new StringBuffer().append("Unsupported Extension Bundle type: ").append(dir.getValue()).toString(), new UnsupportedOperationException("Unsupported Extension Bundle type!"));
        }
        List<Capability> exports = null;
        try {
            exports = ManifestParser.parseExportHeader(this.m_logger, this.m_systemBundleModule, (String)bundle.getCurrentModule().getHeaders().get("Export-Package"), this.m_systemBundleModule.getSymbolicName(), this.m_systemBundleModule.getVersion());
            exports = ExtensionManager.aliasSymbolicName(exports);
        }
        catch (Exception ex) {
            this.m_logger.log(bundle, 1, new StringBuffer().append("Error parsing extension bundle export statement: ").append(bundle.getCurrentModule().getHeaders().get("Export-Package")).toString(), (Throwable)ex);
            return;
        }
        if (m_extensionManager == null) {
            this.m_logger.log(bundle, 2, "Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
            throw new UnsupportedOperationException("Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
        }
        m_extensionManager.addExtension(felix, bundle);
        ArrayList<Capability> temp = new ArrayList<Capability>(this.m_capabilities.size() + exports.size());
        temp.addAll(this.m_capabilities);
        temp.addAll(exports);
        this.setCapabilities(temp);
        felix.setBundleStateAndNotify(bundle, 4);
    }

    void startExtensionBundle(Felix felix, BundleImpl bundle) {
        String activatorClass = (String)bundle.getCurrentModule().getHeaders().get("Felix-Activator");
        if (activatorClass != null) {
            try {
                BundleActivator activator = (BundleActivator)felix.getClass().getClassLoader().loadClass(activatorClass.trim()).newInstance();
                felix.m_activatorList.add(activator);
                BundleContext context = felix._getBundleContext();
                bundle.setBundleContext(context);
                if (felix.getState() == 32 || felix.getState() == 8) {
                    Felix.m_secureAction.startActivator(activator, context);
                }
            }
            catch (Throwable ex) {
                this.m_logger.log(bundle, 2, "Unable to start Felix Extension Activator", ex);
            }
        }
    }

    void removeExtensions(Felix felix) {
        if (m_extensionManager != null) {
            m_extensionManager._removeExtensions(felix);
        }
    }

    private void setCapabilities(List<Capability> capabilities) {
        this.m_capabilities = capabilities;
        this.m_headerMap.put("Export-Package", this.convertCapabilitiesToHeaders(this.m_headerMap));
    }

    private String convertCapabilitiesToHeaders(Map headers) {
        StringBuffer exportSB = new StringBuffer("");
        HashSet<Object> exportNames = new HashSet<Object>();
        for (int i = 0; this.m_capabilities != null && i < this.m_capabilities.size(); ++i) {
            if (!this.m_capabilities.get(i).getNamespace().equals("package")) continue;
            if (exportSB.length() > 0) {
                exportSB.append(", ");
            }
            exportSB.append(this.m_capabilities.get(i).getAttribute("package").getValue());
            for (Directive dir : this.m_capabilities.get(i).getDirectives()) {
                exportSB.append("; ");
                exportSB.append(dir.getName());
                exportSB.append(":=\"");
                exportSB.append(dir.getValue());
                exportSB.append("\"");
            }
            for (Attribute attr : this.m_capabilities.get(i).getAttributes()) {
                if (attr.getName().equals("package") || attr.getName().equals("bundle-symbolic-name") || attr.getName().equals("bundle-version")) continue;
                exportSB.append("; ");
                exportSB.append(attr.getName());
                exportSB.append("=\"");
                exportSB.append(attr.getValue());
                exportSB.append("\"");
            }
            exportNames.add(this.m_capabilities.get(i).getAttribute("package").getValue());
        }
        this.m_exportNames = exportNames;
        return exportSB.toString();
    }

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        String path = url.getPath();
        if (path.trim().equals("/")) {
            return new URLHandlersBundleURLConnection(url);
        }
        Bundle[] extensions = this.m_extensionsCache;
        URL result = null;
        for (Bundle extBundle : extensions) {
            try {
                result = ((ModuleImpl)((BundleImpl)extBundle).getCurrentModule()).getResourceLocal(path);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (result == null) continue;
            return result.openConnection();
        }
        throw new IOException("Resource not provided by any extension!");
    }

    @Override
    protected InetAddress getHostAddress(URL u) {
        return null;
    }

    private synchronized void addExtension(Object source, Bundle extension) {
        ArrayList<Bundle> sourceExtensions = (ArrayList<Bundle>)this.m_sourceToExtensions.get(source);
        if (sourceExtensions == null) {
            sourceExtensions = new ArrayList<Bundle>();
            this.m_sourceToExtensions.put(source, sourceExtensions);
        }
        sourceExtensions.add(extension);
        this._add(extension.getSymbolicName(), extension);
        this.m_extensionsCache = this.m_extensions.toArray(new Bundle[this.m_extensions.size()]);
    }

    private synchronized void _removeExtensions(Object source) {
        if (this.m_sourceToExtensions.remove(source) == null) {
            return;
        }
        this.m_extensions.clear();
        this.m_names.clear();
        for (List extensions : this.m_sourceToExtensions.values()) {
            for (Bundle bundle : extensions) {
                this._add(bundle.getSymbolicName(), bundle);
            }
            this.m_extensionsCache = this.m_extensions.toArray(new Bundle[this.m_extensions.size()]);
        }
    }

    private void _add(String name, Bundle extension) {
        if (!this.m_names.contains(name)) {
            this.m_names.add(name);
            this.m_extensions.add(extension);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Enumeration getEntries() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean hasEntry(String name) {
        return false;
    }

    @Override
    public byte[] getEntryAsBytes(String name) {
        return null;
    }

    @Override
    public InputStream getEntryAsStream(String name) throws IOException {
        return null;
    }

    @Override
    public Content getEntryAsContent(String name) {
        return null;
    }

    @Override
    public String getEntryAsNativeLibrary(String name) {
        return null;
    }

    @Override
    public URL getEntryAsURL(String name) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        ExtensionManager extensionManager = new ExtensionManager();
        try {
            new URL("http://felix.extensions:9/").openConnection();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Felix.m_secureAction.addURLToURLClassLoader(Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "http:", extensionManager), "http://felix.extensions:9/", extensionManager), (class$org$apache$felix$framework$Felix == null ? (class$org$apache$felix$framework$Felix = ExtensionManager.class$("org.apache.felix.framework.Felix")) : class$org$apache$felix$framework$Felix).getClassLoader());
        }
        catch (Throwable ex) {
            extensionManager = null;
        }
        m_extensionManager = extensionManager;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExtensionManagerModule
    extends ModuleImpl {
        private final Version m_version;

        ExtensionManagerModule(Felix felix) {
            super(ExtensionManager.this.m_logger, felix.getConfig(), felix, "0", felix.getBootPackages(), felix.getBootPackageWildcards());
            this.m_version = new Version((String)felix.getConfig().get("felix.version"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getHeaders() {
            ExtensionManager extensionManager = ExtensionManager.this;
            synchronized (extensionManager) {
                return ExtensionManager.this.m_headerMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Capability> getCapabilities() {
            ExtensionManager extensionManager = ExtensionManager.this;
            synchronized (extensionManager) {
                return ExtensionManager.this.m_capabilities;
            }
        }

        @Override
        public String getSymbolicName() {
            return "org.apache.felix.framework";
        }

        @Override
        public Version getVersion() {
            return this.m_version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class getClassByDelegation(String name) throws ClassNotFoundException {
            Class<?> clazz;
            block9: {
                clazz = null;
                String pkgName = Util.getClassPackage(name);
                if (this.shouldBootDelegate(pkgName)) {
                    try {
                        ClassLoader bdcl = this.getBootDelegationClassLoader();
                        clazz = bdcl.loadClass(name);
                        if (pkgName.startsWith("java.") || clazz != null) {
                            return clazz;
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        if (!pkgName.startsWith("java.")) break block9;
                        throw ex;
                    }
                }
            }
            if (clazz == null) {
                ExtensionManager extensionManager = ExtensionManager.this;
                synchronized (extensionManager) {
                    if (!ExtensionManager.this.m_exportNames.contains(Util.getClassPackage(name))) {
                        throw new ClassNotFoundException(name);
                    }
                }
                clazz = this.getClass().getClassLoader().loadClass(name);
            }
            return clazz;
        }

        @Override
        public URL getResourceByDelegation(String name) {
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        public Enumeration getResourcesByDelegation(String name) {
            try {
                return this.getClass().getClassLoader().getResources(name);
            }
            catch (IOException ex) {
                return null;
            }
        }

        public Logger getLogger() {
            return ExtensionManager.this.m_logger;
        }

        public Map getConfig() {
            return null;
        }

        public Felix.FelixResolver getResolver() {
            return null;
        }

        public void attachFragmentContents(Content[] fragmentContents) throws Exception {
            throw new UnsupportedOperationException("Should not be used!");
        }

        @Override
        public void close() {
        }

        @Override
        public Content getContent() {
            return ExtensionManager.this;
        }

        @Override
        public URL getEntry(String name) {
            return null;
        }

        @Override
        public boolean hasInputStream(int index, String urlPath) {
            return this.getClass().getClassLoader().getResource(urlPath) != null;
        }

        @Override
        public InputStream getInputStream(int index, String urlPath) {
            return this.getClass().getClassLoader().getResourceAsStream(urlPath);
        }

        @Override
        public URL getLocalURL(int index, String urlPath) {
            return this.getClass().getClassLoader().getResource(urlPath);
        }
    }
}

