/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.Directive;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.CandidateComparator;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Resolver;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixResolverState
implements Resolver.ResolverState {
    private final Logger m_logger;
    private final List<Module> m_modules;
    private final Map<String, CapabilitySet> m_capSets;
    private final Map<String, List<Module>> m_fragmentMap = new HashMap<String, List<Module>>();
    private final Map<String, List<Module>> m_singletons = new HashMap<String, List<Module>>();
    private final String m_fwkExecEnvStr;
    private final Set<String> m_fwkExecEnvSet;

    public FelixResolverState(Logger logger, String fwkExecEnvStr) {
        this.m_logger = logger;
        this.m_modules = new ArrayList<Module>();
        this.m_capSets = new HashMap<String, CapabilitySet>();
        this.m_fwkExecEnvStr = fwkExecEnvStr != null ? fwkExecEnvStr.trim() : null;
        this.m_fwkExecEnvSet = FelixResolverState.parseExecutionEnvironments(fwkExecEnvStr);
        ArrayList<String> indices = new ArrayList<String>();
        indices.add("bundle-symbolic-name");
        this.m_capSets.put("module", new CapabilitySet(indices));
        indices = new ArrayList();
        indices.add("package");
        this.m_capSets.put("package", new CapabilitySet(indices));
        indices = new ArrayList();
        indices.add("bundle-symbolic-name");
        this.m_capSets.put("host", new CapabilitySet(indices));
    }

    public synchronized void addModule(Module module) {
        if (FelixResolverState.isSingleton(module)) {
            List<Module> modules = this.m_singletons.get(module.getSymbolicName());
            Module current = modules != null && !modules.isEmpty() ? modules.get(0) : null;
            for (int i = 0; modules != null && i < modules.size(); ++i) {
                if (!modules.get(i).isResolved()) continue;
                current = modules.get(i);
            }
            Module highest = FelixResolverState.indexModule(this.m_singletons, module);
            if (current != null && !current.isResolved() && current != highest) {
                if (Util.isFragment(current)) {
                    this.removeFragment(current);
                } else {
                    this.removeHost(current);
                }
            } else if (current != null) {
                module = null;
            }
        }
        if (module != null && Util.isFragment(module)) {
            this.addFragment(module);
        } else if (module != null) {
            this.addHost(module);
        }
    }

    public synchronized void removeModule(Module module) {
        List<Module> modules = this.m_singletons.get(module.getSymbolicName());
        if (modules != null) {
            modules.remove(module);
            if (modules.size() == 0) {
                this.m_singletons.remove(module.getSymbolicName());
            }
        }
        if (Util.isFragment(module)) {
            this.removeFragment(module);
        } else {
            this.removeHost(module);
        }
    }

    public void detachFragment(Module host, Module fragment) {
        List<Module> fragments = ((ModuleImpl)host).getFragments();
        fragments.remove(fragment);
        try {
            ((ModuleImpl)host).attachFragments(fragments);
        }
        catch (Exception ex) {
            try {
                ((ModuleImpl)host).attachFragments(null);
            }
            catch (Exception ex2) {
                // empty catch block
            }
            this.m_logger.log(1, "Serious error attaching fragments.", ex);
        }
    }

    public void checkSingleton(Module module) {
        List<Module> modules = this.m_singletons.get(module.getSymbolicName());
        if (modules != null && modules.contains(module)) {
            Module current;
            for (Module mod : modules) {
                if (!mod.isResolved()) continue;
                throw new ResolveException("Only one singleton can be resolved at a time.", null, null);
            }
            Module module2 = current = modules.size() > 0 ? modules.get(0) : null;
            if (current != null && current != module) {
                if (Util.isFragment(current)) {
                    this.removeFragment(current);
                } else {
                    this.removeHost(current);
                }
                if (Util.isFragment(module)) {
                    this.addFragment(module);
                } else {
                    this.addHost(module);
                }
            }
        }
    }

    private void addFragment(Module fragment) {
        FelixResolverState.indexModule(this.m_fragmentMap, fragment);
        Set<Capability> hostCaps = this.getMatchingHostCapabilities(fragment);
        for (Capability cap : hostCaps) {
            ArrayList<Module> newFragments;
            Module host = cap.getModule();
            List<Module> fragments = ((ModuleImpl)host).getFragments();
            Module attachedFragment = null;
            for (int fragIdx = 0; fragments != null && attachedFragment == null && fragIdx < fragments.size(); ++fragIdx) {
                if (!fragments.get(fragIdx).getSymbolicName().equals(fragment.getSymbolicName())) continue;
                attachedFragment = fragments.get(fragIdx);
            }
            if (attachedFragment != null && attachedFragment.getVersion().compareTo(fragment.getVersion()) > 0) continue;
            ArrayList<Module> arrayList = newFragments = fragments == null ? new ArrayList<Module>() : new ArrayList<Module>(fragments);
            if (attachedFragment != null) {
                newFragments.remove(attachedFragment);
            }
            int index = -1;
            for (int listIdx = 0; index < 0 && listIdx < newFragments.size(); ++listIdx) {
                Module f = (Module)newFragments.get(listIdx);
                if (fragment.getBundle().getBundleId() >= f.getBundle().getBundleId()) continue;
                index = listIdx;
            }
            newFragments.add(index < 0 ? newFragments.size() : index, fragment);
            List<Capability> caps = host.getCapabilities();
            this.removeCapabilities(caps);
            fragments = newFragments.isEmpty() ? null : newFragments;
            try {
                ((ModuleImpl)host).attachFragments(fragments);
            }
            catch (Exception ex) {
                try {
                    ((ModuleImpl)host).attachFragments(null);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                this.m_logger.log(1, "Serious error attaching fragments.", ex);
            }
            caps = host.getCapabilities();
            this.addCapabilities(caps);
        }
    }

    private void removeFragment(Module fragment) {
        List<Module> fragList = this.m_fragmentMap.get(fragment.getSymbolicName());
        if (fragList != null) {
            fragList.remove(fragment);
            if (fragList.isEmpty()) {
                this.m_fragmentMap.remove(fragment.getSymbolicName());
            }
            Set<Capability> hostCaps = this.getMatchingHostCapabilities(fragment);
            for (Capability hostCap : hostCaps) {
                Module host = hostCap.getModule();
                List<Module> fragments = ((ModuleImpl)host).getFragments();
                if (fragments == null || !fragments.contains(fragment)) continue;
                List<Module> fragmentList = this.getMatchingFragments(host);
                List<Capability> caps = host.getCapabilities();
                this.removeCapabilities(caps);
                try {
                    ((ModuleImpl)host).attachFragments(fragmentList);
                }
                catch (Exception ex) {
                    try {
                        ((ModuleImpl)host).attachFragments(null);
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                    this.m_logger.log(1, "Serious error attaching fragments.", ex);
                }
                caps = host.getCapabilities();
                this.addCapabilities(caps);
            }
        }
    }

    private void addCapabilities(List<Capability> caps) {
        if (caps != null) {
            for (Capability cap : caps) {
                CapabilitySet capSet = this.m_capSets.get(cap.getNamespace());
                if (capSet == null) {
                    capSet = new CapabilitySet(null);
                    this.m_capSets.put(cap.getNamespace(), capSet);
                }
                capSet.addCapability(cap);
            }
        }
    }

    private void removeCapabilities(List<Capability> caps) {
        if (caps != null) {
            for (Capability cap : caps) {
                CapabilitySet capSet = this.m_capSets.get(cap.getNamespace());
                if (capSet == null) continue;
                capSet.removeCapability(cap);
            }
        }
    }

    public void unmergeFragment(Module fragment) {
        if (!Util.isFragment(fragment)) {
            return;
        }
        this.removeFragment(fragment);
    }

    private Set<Capability> getMatchingHostCapabilities(Module fragment) {
        Requirement hostReq = FelixResolverState.getFragmentHostRequirement(fragment);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && fragment.getSymbolicName() != null && !((BundleProtectionDomain)fragment.getSecurityContext()).impliesDirect(new BundlePermission(fragment.getSymbolicName(), "fragment"))) {
            return new HashSet<Capability>();
        }
        Set<Capability> hostCaps = this.m_capSets.get("host").match(hostReq.getFilter(), true);
        Iterator<Capability> it = hostCaps.iterator();
        while (it.hasNext()) {
            Capability hostCap = it.next();
            if (hostCap.getModule().isResolved() || ((BundleImpl)hostCap.getModule().getBundle()).isStale() || ((BundleImpl)hostCap.getModule().getBundle()).isRemovalPending()) {
                it.remove();
                continue;
            }
            if (sm == null || hostCap.getModule().getSymbolicName() == null || ((BundleProtectionDomain)hostCap.getModule().getSecurityContext()).impliesDirect(new BundlePermission(hostCap.getModule().getSymbolicName(), "host"))) continue;
            it.remove();
        }
        return hostCaps;
    }

    private void addHost(Module host) {
        List<Module> fragments;
        this.m_modules.add(host);
        List<Capability> caps = Util.getCapabilityByNamespace(host, "host");
        if (caps.size() > 0) {
            this.m_capSets.get("host").addCapability(caps.get(0));
        }
        if ((fragments = this.getMatchingFragments(host)).size() > 0) {
            try {
                ((ModuleImpl)host).attachFragments(fragments);
            }
            catch (Exception ex) {
                try {
                    ((ModuleImpl)host).attachFragments(null);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                this.m_logger.log(1, "Serious error attaching fragments.", ex);
            }
        }
        caps = host.getCapabilities();
        this.addCapabilities(caps);
    }

    private void removeHost(Module host) {
        this.m_modules.remove(host);
        List<Capability> caps = Util.getCapabilityByNamespace(host, "host");
        if (caps.size() > 0) {
            this.m_capSets.get("host").removeCapability(caps.get(0));
        }
        caps = host.getCapabilities();
        this.removeCapabilities(caps);
        try {
            ((ModuleImpl)host).attachFragments(null);
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error detaching fragments.", ex);
        }
        ((ModuleImpl)host).setWires(null);
    }

    private List<Module> getMatchingFragments(Module host) {
        List<Capability> caps = Util.getCapabilityByNamespace(host, "host");
        Capability hostCap = caps.isEmpty() ? null : caps.get(0);
        ArrayList<Module> fragmentList = new ArrayList<Module>();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && host.getSymbolicName() != null && !((BundleProtectionDomain)host.getSecurityContext()).impliesDirect(new BundlePermission(host.getSymbolicName(), "host"))) {
            return fragmentList;
        }
        Iterator<Map.Entry<String, List<Module>>> it = this.m_fragmentMap.entrySet().iterator();
        while (hostCap != null && it.hasNext()) {
            Requirement hostReq;
            Map.Entry<String, List<Module>> entry = it.next();
            List<Module> fragments = entry.getValue();
            Module fragment = null;
            for (int i = 0; fragment == null && i < fragments.size(); ++i) {
                Module f = fragments.get(i);
                if (((BundleImpl)f.getBundle()).isStale() || ((BundleImpl)f.getBundle()).isRemovalPending()) continue;
                fragment = f;
            }
            if (fragment == null || sm != null && fragment.getSymbolicName() != null && !((BundleProtectionDomain)fragment.getSecurityContext()).impliesDirect(new BundlePermission(fragment.getSymbolicName(), "fragment")) || (hostReq = FelixResolverState.getFragmentHostRequirement(fragment)) == null || !CapabilitySet.matches(hostCap, hostReq.getFilter())) continue;
            int index = -1;
            for (int listIdx = 0; index < 0 && listIdx < fragmentList.size(); ++listIdx) {
                Module existing = (Module)fragmentList.get(listIdx);
                if (fragment.getBundle().getBundleId() >= existing.getBundle().getBundleId()) continue;
                index = listIdx;
            }
            fragmentList.add(index < 0 ? fragmentList.size() : index, fragment);
        }
        return fragmentList;
    }

    public synchronized Module findHost(Module rootModule) throws ResolveException {
        Module newRootModule = rootModule;
        if (Util.isFragment(rootModule)) {
            Set<Capability> hostCaps = this.getMatchingHostCapabilities(rootModule);
            Module currentBestHost = null;
            for (Capability hostCap : hostCaps) {
                Module host = hostCap.getModule();
                if (currentBestHost == null) {
                    currentBestHost = host;
                    continue;
                }
                if (currentBestHost.getVersion().compareTo(host.getVersion()) >= 0) continue;
                currentBestHost = host;
            }
            newRootModule = currentBestHost;
            if (newRootModule == null) {
                throw new ResolveException("Unable to find host.", rootModule, FelixResolverState.getFragmentHostRequirement(rootModule));
            }
        }
        return newRootModule;
    }

    private static Requirement getFragmentHostRequirement(Module fragment) {
        List<Requirement> reqs = fragment.getRequirements();
        Requirement hostReq = null;
        for (int reqIdx = 0; hostReq == null && reqIdx < reqs.size(); ++reqIdx) {
            if (!reqs.get(reqIdx).getNamespace().equals("host")) continue;
            hostReq = reqs.get(reqIdx);
        }
        return hostReq;
    }

    synchronized void refreshSystemBundleModule(Module module) {
        List<Capability> caps = module.getCapabilities();
        this.addCapabilities(caps);
    }

    public synchronized void moduleResolved(Module module) {
        if (module.isResolved()) {
            List<Wire> wires = module.getWires();
            List<Capability> caps = module.getCapabilities();
            block0: for (int wireIdx = 0; wires != null && wireIdx < wires.size(); ++wireIdx) {
                Wire wire = wires.get(wireIdx);
                if (!wire.getCapability().getNamespace().equals("package")) continue;
                for (int capIdx = 0; caps != null && capIdx < caps.size(); ++capIdx) {
                    if (!caps.get(capIdx).getNamespace().equals("package") || !wire.getCapability().getAttribute("package").getValue().equals(caps.get(capIdx).getAttribute("package").getValue())) continue;
                    this.m_capSets.get("package").removeCapability(caps.get(capIdx));
                    continue block0;
                }
            }
        }
    }

    @Override
    public Set<Capability> getCandidates(Module module, Requirement req, boolean obeyMandatory) {
        TreeSet<Capability> result = new TreeSet<Capability>(new CandidateComparator());
        CapabilitySet capSet = this.m_capSets.get(req.getNamespace());
        if (capSet != null) {
            Set<Capability> matches = capSet.match(req.getFilter(), obeyMandatory);
            if (System.getSecurityManager() != null) {
                for (Capability cap : matches) {
                    if (req.getNamespace().equals("package") && (!((BundleProtectionDomain)cap.getModule().getSecurityContext()).impliesDirect(new PackagePermission((String)cap.getAttribute("package").getValue(), "exportonly")) || module != null && !((BundleProtectionDomain)module.getSecurityContext()).impliesDirect(new PackagePermission((String)cap.getAttribute("package").getValue(), cap.getModule().getBundle(), "import"))) && module != cap.getModule() || req.getNamespace().equals("module") && (!((BundleProtectionDomain)cap.getModule().getSecurityContext()).impliesDirect(new BundlePermission(cap.getModule().getSymbolicName(), "provide")) || module != null && !((BundleProtectionDomain)module.getSecurityContext()).impliesDirect(new BundlePermission(module.getSymbolicName(), "require")))) continue;
                    result.add(cap);
                }
            } else {
                result.addAll(matches);
            }
        }
        return result;
    }

    @Override
    public void checkExecutionEnvironment(Module module) throws ResolveException {
        String bundleExecEnvStr = (String)module.getHeaders().get("Bundle-RequiredExecutionEnvironment");
        if (bundleExecEnvStr != null && !(bundleExecEnvStr = bundleExecEnvStr.trim()).equals("") && this.m_fwkExecEnvStr != null && this.m_fwkExecEnvStr.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(bundleExecEnvStr, ",");
            boolean found = false;
            while (tokens.hasMoreTokens() && !found) {
                if (!this.m_fwkExecEnvSet.contains(tokens.nextToken().trim())) continue;
                found = true;
            }
            if (!found) {
                throw new ResolveException(new StringBuffer().append("Execution environment not supported: ").append(bundleExecEnvStr).toString(), module, null);
            }
        }
    }

    @Override
    public void checkNativeLibraries(Module module) throws ResolveException {
        List<R4Library> libs = module.getNativeLibraries();
        if (libs != null) {
            String msg = null;
            for (int libIdx = 0; msg == null && libIdx < libs.size(); ++libIdx) {
                String entryName = libs.get(libIdx).getEntryName();
                if (entryName == null || module.getContent().hasEntry(entryName)) continue;
                msg = new StringBuffer().append("Native library does not exist: ").append(entryName).toString();
            }
            if (libs.isEmpty()) {
                msg = "No matching native libraries found.";
            }
            if (msg != null) {
                throw new ResolveException(msg, module, null);
            }
        }
    }

    private static Set<String> parseExecutionEnvironments(String fwkExecEnvStr) {
        HashSet<String> newSet = new HashSet<String>();
        if (fwkExecEnvStr != null) {
            StringTokenizer tokens = new StringTokenizer(fwkExecEnvStr, ",");
            while (tokens.hasMoreTokens()) {
                newSet.add(tokens.nextToken().trim());
            }
        }
        return newSet;
    }

    private static boolean isSingleton(Module module) {
        List<Capability> modCaps = Util.getCapabilityByNamespace(module, "module");
        if (modCaps == null || modCaps.isEmpty()) {
            return false;
        }
        List<Directive> dirs = modCaps.get(0).getDirectives();
        for (int dirIdx = 0; dirs != null && dirIdx < dirs.size(); ++dirIdx) {
            if (!dirs.get(dirIdx).getName().equalsIgnoreCase("singleton") || !Boolean.valueOf((String)dirs.get(dirIdx).getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static Module indexModule(Map<String, List<Module>> map, Module module) {
        List<Module> modules = map.get(module.getSymbolicName());
        if (modules == null) {
            modules = new ArrayList<Module>();
            modules.add(module);
        } else {
            Version version = module.getVersion();
            int top = 0;
            int bottom = modules.size() - 1;
            while (top <= bottom) {
                int middle = (bottom - top) / 2 + top;
                Version middleVersion = modules.get(middle).getVersion();
                int cmp = middleVersion.compareTo(version);
                if (cmp < 0) {
                    bottom = middle - 1;
                    continue;
                }
                if (cmp == 0) {
                    long exportId;
                    long middleId = modules.get(middle).getBundle().getBundleId();
                    if (middleId < (exportId = module.getBundle().getBundleId())) {
                        top = middle + 1;
                        continue;
                    }
                    bottom = middle - 1;
                    continue;
                }
                top = middle + 1;
            }
            if (top >= modules.size() || modules.get(top) != module) {
                modules.add(top, module);
            }
        }
        map.put(module.getSymbolicName(), modules);
        return modules.get(0);
    }
}

