/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.ModuleImpl;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.ext.SecurityProvider;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

class BundleImpl
implements Bundle {
    private final Felix __m_felix;
    private final BundleArchive m_archive;
    private IModule[] m_modules = new IModule[0];
    private volatile int m_state;
    private boolean m_useDeclaredActivationPolicy;
    private BundleActivator m_activator = null;
    private volatile BundleContext m_context = null;
    private final Map m_cachedHeaders = new HashMap();
    private long m_cachedHeadersTimestamp;
    private boolean m_stale = false;
    private int m_lockCount = 0;
    private Thread m_lockThread = null;

    BundleImpl() {
        this.__m_felix = null;
        this.m_archive = null;
        this.m_state = 2;
        this.m_useDeclaredActivationPolicy = false;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
    }

    BundleImpl(Felix felix, BundleArchive archive) throws Exception {
        this.__m_felix = felix;
        this.m_archive = archive;
        this.m_state = 2;
        this.m_useDeclaredActivationPolicy = false;
        this.m_stale = false;
        this.m_activator = null;
        this.m_context = null;
        IModule module = this.createModule();
        this.addModule(module);
    }

    Felix getFramework() {
        return this.__m_felix;
    }

    BundleArchive getArchive() {
        return this.m_archive;
    }

    synchronized void close() {
        this.closeModules();
        if (this.m_archive != null) {
            try {
                this.m_archive.close();
            }
            catch (Exception ex) {
                this.getFramework().getLogger().log(1, "Unable to close archive revisions.", ex);
            }
        }
    }

    synchronized void closeAndDelete() throws Exception {
        this.m_stale = true;
        this.closeModules();
        this.m_archive.closeAndDelete();
    }

    private void closeModules() {
        for (int i = 0; i < this.m_modules.length; ++i) {
            this.getFramework().getResolverState().removeModule(this.m_modules[i]);
            ((ModuleImpl)this.m_modules[i]).close();
        }
    }

    synchronized void cleanAfterUninstall() {
        for (int i = 0; i < this.m_modules.length; ++i) {
            this.getFramework().getResolverState().unmergeFragment(this.m_modules[i]);
        }
    }

    synchronized void refresh() throws Exception {
        if (this.isExtension() && this.getFramework().getState() != 16) {
            this.getFramework().getLogger().log(2, "Framework restart on extension bundle refresh not implemented.");
        } else {
            this.closeModules();
            this.m_archive.purge();
            this.m_modules = new IModule[0];
            IModule module = this.createModule();
            this.addModule(module);
            this.m_state = 2;
            this.m_stale = false;
            this.m_cachedHeaders.clear();
            this.m_cachedHeadersTimestamp = 0L;
        }
    }

    synchronized boolean isDeclaredActivationPolicyUsed() {
        return this.m_useDeclaredActivationPolicy;
    }

    synchronized void setDeclaredActivationPolicyUsed(boolean b) {
        this.m_useDeclaredActivationPolicy = b;
    }

    synchronized BundleActivator getActivator() {
        return this.m_activator;
    }

    synchronized void setActivator(BundleActivator activator) {
        this.m_activator = activator;
    }

    public BundleContext getBundleContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "context"));
        }
        return this.m_context;
    }

    void setBundleContext(BundleContext context) {
        this.m_context = context;
    }

    public long getBundleId() {
        try {
            return this.m_archive.getId();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error getting the identifier from bundle archive.", ex);
            return -1L;
        }
    }

    public URL getEntry(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleEntry(this, name);
    }

    public Enumeration getEntryPaths(String path) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleEntryPaths(this, path);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().findBundleEntries(this, path, filePattern, recurse);
    }

    public Dictionary getHeaders() {
        return this.getHeaders(Locale.getDefault().toString());
    }

    public Dictionary getHeaders(String locale) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        return this.getFramework().getBundleHeaders(this, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getCurrentLocalizedHeader(String locale) {
        Map result = null;
        if (locale.length() == 0) {
            result = new StringMap(this.getCurrentModule().getHeaders(), false);
        }
        if (result == null) {
            Map map = this.m_cachedHeaders;
            synchronized (map) {
                if (this.getState() == 1) {
                    result = (Map)this.m_cachedHeaders.values().iterator().next();
                } else if (this.getLastModified() > this.m_cachedHeadersTimestamp) {
                    this.m_cachedHeaders.clear();
                } else if (this.m_cachedHeaders.containsKey(locale)) {
                    result = (Map)this.m_cachedHeaders.get(locale);
                }
            }
        }
        if (result == null) {
            StringMap headers;
            result = headers = new StringMap(this.getCurrentModule().getHeaders(), false);
            boolean localize = false;
            Iterator it = headers.values().iterator();
            while (!localize && it.hasNext()) {
                if (!((String)it.next()).startsWith("%")) continue;
                localize = true;
            }
            if (!localize) {
                this.updateHeaderCache(locale, headers);
            } else {
                String basename = (String)headers.get("Bundle-Localization");
                if (basename == null) {
                    basename = "OSGI-INF/l10n/bundle";
                }
                List moduleList = BundleImpl.createLocalizationModuleList((ModuleImpl)this.getCurrentModule());
                List resourceList = BundleImpl.createLocalizationResourceList(basename, locale);
                boolean found = false;
                Properties mergedProperties = new Properties();
                for (int modIdx = 0; modIdx < moduleList.size(); ++modIdx) {
                    Iterator it2 = resourceList.iterator();
                    while (it2.hasNext()) {
                        URL temp = ((IModule)moduleList.get(modIdx)).getEntry(it2.next() + ".properties");
                        if (temp == null) continue;
                        found = true;
                        try {
                            mergedProperties.load(temp.openConnection().getInputStream());
                        }
                        catch (IOException ex) {}
                    }
                }
                if (!found && !locale.equals(Locale.getDefault().toString())) {
                    result = this.getCurrentLocalizedHeader(Locale.getDefault().toString());
                } else {
                    Iterator it3 = headers.entrySet().iterator();
                    while (it3.hasNext()) {
                        Map.Entry entry = it3.next();
                        String value = (String)entry.getValue();
                        if (!value.startsWith("%")) continue;
                        String key = value.substring(value.indexOf("%") + 1);
                        String newvalue = mergedProperties.getProperty(key);
                        if (newvalue == null) {
                            newvalue = key;
                        }
                        entry.setValue(newvalue);
                    }
                    this.updateHeaderCache(locale, headers);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHeaderCache(String locale, Map localizedHeaders) {
        Map map = this.m_cachedHeaders;
        synchronized (map) {
            this.m_cachedHeaders.put(locale, localizedHeaders);
            this.m_cachedHeadersTimestamp = System.currentTimeMillis();
        }
    }

    private static List createLocalizationModuleList(ModuleImpl module) {
        IModule[] hosts = module.getDependentHosts();
        if (hosts != null && hosts.length > 0) {
            module = (ModuleImpl)hosts[0];
            for (int hostIdx = 1; hostIdx < hosts.length; ++hostIdx) {
                if (module.getVersion().compareTo(hosts[hostIdx].getVersion()) >= 0) continue;
                module = (ModuleImpl)hosts[hostIdx];
            }
        }
        ArrayList<IModule> result = new ArrayList<IModule>();
        result.add(module);
        IModule[] fragments = module.getFragments();
        for (int i = 0; fragments != null && i < fragments.length; ++i) {
            result.add(fragments[i]);
        }
        return result;
    }

    private static List createLocalizationResourceList(String basename, String locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        StringBuffer tempLocale = new StringBuffer(basename);
        result.add(tempLocale.toString());
        if (locale.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(locale, "_");
            while (tokens.hasMoreTokens()) {
                tempLocale.append("_").append(tokens.nextToken());
                result.add(tempLocale.toString());
            }
        }
        return result;
    }

    public long getLastModified() {
        try {
            return this.m_archive.getLastModified();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error reading last modification time from bundle archive.", ex);
            return 0L;
        }
    }

    void setLastModified(long l) {
        try {
            this.m_archive.setLastModified(l);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing last modification time to bundle archive.", ex);
        }
    }

    public String getLocation() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "metadata"));
        }
        return this._getLocation();
    }

    String _getLocation() {
        try {
            return this.m_archive.getLocation();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error getting location from bundle archive.", ex);
            return null;
        }
    }

    public URL getResource(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleResource(this, name);
    }

    public Enumeration getResources(String name) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "resource"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.getFramework().getBundleResources(this, name);
    }

    public ServiceReference[] getRegisteredServices() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.getFramework().getBundleRegisteredServices(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            for (int i = 0; i < refs.length; ++i) {
                try {
                    sm.checkPermission(new ServicePermission(refs[i], "get"));
                    result.add(refs[i]);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.getFramework().getBundleRegisteredServices(this);
    }

    public ServiceReference[] getServicesInUse() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ServiceReference[] refs = this.getFramework().getBundleServicesInUse(this);
            if (refs == null) {
                return refs;
            }
            ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
            for (int i = 0; i < refs.length; ++i) {
                try {
                    sm.checkPermission(new ServicePermission(refs[i], "get"));
                    result.add(refs[i]);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(new ServiceReference[result.size()]);
        }
        return this.getFramework().getBundleServicesInUse(this);
    }

    public int getState() {
        return this.m_state;
    }

    void __setState(int i) {
        this.m_state = i;
    }

    int getPersistentState() {
        try {
            return this.m_archive.getPersistentState();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error reading persistent state from bundle archive.", ex);
            return 2;
        }
    }

    void setPersistentStateInactive() {
        try {
            this.m_archive.setPersistentState(2);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    void setPersistentStateActive() {
        try {
            this.m_archive.setPersistentState(32);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    void setPersistentStateStarting() {
        try {
            this.m_archive.setPersistentState(8);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    void setPersistentStateUninstalled() {
        try {
            this.m_archive.setPersistentState(1);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    int getStartLevel(int defaultLevel) {
        try {
            return this.m_archive.getStartLevel();
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error reading start level from bundle archive.", ex);
            return defaultLevel;
        }
    }

    void setStartLevel(int i) {
        try {
            this.m_archive.setStartLevel(i);
        }
        catch (Exception ex) {
            this.getFramework().getLogger().log(1, "Error writing start level to bundle archive.", ex);
        }
    }

    synchronized boolean isStale() {
        return this.m_stale;
    }

    synchronized boolean isExtension() {
        for (int i = this.m_modules.length - 1; i > -1; --i) {
            if (!this.m_modules[i].isExtension()) continue;
            return true;
        }
        return false;
    }

    public String getSymbolicName() {
        return this.getCurrentModule().getSymbolicName();
    }

    public Version getVersion() {
        return this.getCurrentModule().getVersion();
    }

    public boolean hasPermission(Object obj) {
        return this.getFramework().bundleHasPermission(this, obj);
    }

    public Map getSignerCertificates(int signersType) {
        return (Map)this.getFramework().getSignerMatcher(this, signersType);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.isExtension()) {
            throw new ClassNotFoundException("Extension bundles cannot load classes.");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this, "class"));
            }
            catch (Exception ex) {
                throw new ClassNotFoundException("No permission.", ex);
            }
        }
        return this.getFramework().loadBundleClass(this, name);
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.getFramework().startBundle(this, options);
    }

    public void update() throws BundleException {
        this.update(null);
    }

    public void update(InputStream is) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        this.getFramework().updateBundle(this, is);
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "execute"));
        }
        this.getFramework().stopBundle(this, (options & 1) == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() throws BundleException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(this, "lifecycle"));
        }
        Map map = this.m_cachedHeaders;
        synchronized (map) {
            this.m_cachedHeaders.clear();
            Map map2 = this.getCurrentLocalizedHeader(Locale.getDefault().toString());
        }
        this.getFramework().uninstallBundle(this);
    }

    public String toString() {
        String sym = this.getCurrentModule().getSymbolicName();
        if (sym != null) {
            return sym + " [" + this.getBundleId() + "]";
        }
        return "[" + this.getBundleId() + "]";
    }

    synchronized boolean isRemovalPending() {
        return this.m_state == 1 || this.m_modules.length > 1 || this.m_stale;
    }

    synchronized IModule[] getModules() {
        return this.m_modules;
    }

    synchronized boolean hasModule(IModule module) {
        for (int i = 0; i < this.m_modules.length; ++i) {
            if (this.m_modules[i] != module) continue;
            return true;
        }
        return false;
    }

    synchronized IModule getCurrentModule() {
        return this.m_modules[this.m_modules.length - 1];
    }

    synchronized boolean isUsed() {
        boolean used = false;
        for (int i = 0; !used && i < this.m_modules.length; ++i) {
            IModule[] dependents = ((ModuleImpl)this.m_modules[i]).getDependents();
            for (int j = 0; dependents != null && j < dependents.length && !used; ++j) {
                if (dependents[j] == this.m_modules[i]) continue;
                used = true;
            }
        }
        return used;
    }

    synchronized void revise(String location, InputStream is) throws Exception {
        this.m_archive.revise(location, is);
        try {
            IModule module = this.createModule();
            this.addModule(module);
        }
        catch (Exception ex) {
            this.m_archive.rollbackRevise();
            throw ex;
        }
    }

    synchronized boolean rollbackRevise() throws Exception {
        return this.m_archive.rollbackRevise();
    }

    synchronized void addModule(IModule module) throws Exception {
        IModule[] backup = this.m_modules;
        IModule[] dest = new IModule[this.m_modules.length + 1];
        System.arraycopy(this.m_modules, 0, dest, 0, this.m_modules.length);
        dest[this.m_modules.length] = module;
        this.m_modules = dest;
        module.setSecurityContext(new BundleProtectionDomain(this.getFramework(), this));
        SecurityProvider sp = this.getFramework().getSecurityProvider();
        if (sp != null && System.getSecurityManager() != null) {
            try {
                sp.checkBundle(this);
            }
            catch (Exception ex) {
                this.m_modules = backup;
                throw ex;
            }
        }
        if (!this.isExtension()) {
            this.getFramework().getResolverState().addModule(module);
        }
    }

    private IModule createModule() throws Exception {
        Map headerMap = this.m_archive.getRevision(this.m_archive.getRevisionCount() - 1).getManifestHeader();
        int revision = this.m_archive.getRevisionCount() - 1;
        ModuleImpl module = new ModuleImpl(this.getFramework().getLogger(), this.getFramework().getConfig(), this.getFramework().getResolver(), this, Long.toString(this.getBundleId()) + "." + Integer.toString(revision), headerMap, this.m_archive.getRevision(revision).getContent(), this.getFramework().getBundleStreamHandler(), this.getFramework().getBootPackages(), this.getFramework().getBootPackageWildcards());
        if (module.getManifestVersion().equals("2")) {
            Version bundleVersion = module.getVersion();
            bundleVersion = bundleVersion == null ? Version.emptyVersion : bundleVersion;
            String symName = module.getSymbolicName();
            Bundle[] bundles = this.getFramework().getBundles();
            for (int i = 0; bundles != null && i < bundles.length; ++i) {
                long id = ((BundleImpl)bundles[i]).getBundleId();
                if (id == this.getBundleId()) continue;
                String sym = bundles[i].getSymbolicName();
                Version ver = ((ModuleImpl)((BundleImpl)bundles[i]).getCurrentModule()).getVersion();
                if (symName == null || sym == null || !symName.equals(sym) || !bundleVersion.equals(ver)) continue;
                throw new BundleException("Bundle symbolic name and version are not unique: " + sym + ':' + ver);
            }
        }
        return module;
    }

    synchronized ProtectionDomain getProtectionDomain() {
        ProtectionDomain pd = null;
        for (int i = this.m_modules.length - 1; i >= 0 && pd == null; --i) {
            pd = (ProtectionDomain)this.m_modules[i].getSecurityContext();
        }
        return pd;
    }

    synchronized boolean isLockable() {
        return this.m_lockCount == 0 || this.m_lockThread == Thread.currentThread();
    }

    synchronized Thread getLockingThread() {
        return this.m_lockThread;
    }

    synchronized void lock() {
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        ++this.m_lockCount;
        this.m_lockThread = Thread.currentThread();
    }

    synchronized void unlock() {
        if (this.m_lockCount == 0) {
            throw new IllegalStateException("Bundle is not locked.");
        }
        if (this.m_lockCount > 0 && this.m_lockThread != Thread.currentThread()) {
            throw new IllegalStateException("Bundle is locked by another thread.");
        }
        --this.m_lockCount;
        if (this.m_lockCount == 0) {
            this.m_lockThread = null;
        }
    }

    BundleContext _getBundleContext() {
        return this.m_context;
    }
}

