/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.felix.eventadmin.impl.tasks.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.tasks.SyncDeliverTasks;
import org.osgi.service.event.Event;

public class AsyncDeliverTasks {
    private final DefaultThreadPool m_pool;
    private final SyncDeliverTasks m_deliver_task;
    private final Map m_running_threads = new HashMap();

    public AsyncDeliverTasks(DefaultThreadPool pool, SyncDeliverTasks deliverTask) {
        this.m_pool = pool;
        this.m_deliver_task = deliverTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Collection tasks, Event event) {
        Thread currentThread = Thread.currentThread();
        TaskExecuter executer = null;
        Map map = this.m_running_threads;
        synchronized (map) {
            TaskExecuter runningExecutor = (TaskExecuter)this.m_running_threads.get(currentThread);
            if (runningExecutor != null) {
                runningExecutor.add(tasks, event);
            } else {
                executer = new TaskExecuter(tasks, event, currentThread);
                this.m_running_threads.put(currentThread, executer);
            }
        }
        if (executer != null) {
            this.m_pool.executeTask(executer);
        }
    }

    private final class TaskExecuter
    implements Runnable {
        private final List m_tasks = new LinkedList();
        private final Object m_key;

        public TaskExecuter(Collection tasks, Event event, Object key) {
            this.m_key = key;
            this.m_tasks.add(new Object[]{tasks, event});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean running;
            do {
                Object[] tasks = null;
                Object object = this.m_tasks;
                synchronized (object) {
                    tasks = (Object[])this.m_tasks.remove(0);
                }
                AsyncDeliverTasks.this.m_deliver_task.execute((Collection)tasks[0], (Event)tasks[1], true);
                object = AsyncDeliverTasks.this.m_running_threads;
                synchronized (object) {
                    boolean bl = running = this.m_tasks.size() > 0;
                    if (!running) {
                        AsyncDeliverTasks.this.m_running_threads.remove(this.m_key);
                    }
                }
            } while (running);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Collection tasks, Event event) {
            List list = this.m_tasks;
            synchronized (list) {
                this.m_tasks.add(new Object[]{tasks, event});
            }
        }
    }
}

