/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.lang.reflect.Array;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONMetaData
implements MetaData,
Cloneable {
    private HashMap<String, Object> m_metadata = new HashMap();

    public JSONMetaData(JSONObject jso) throws JSONException {
        Iterator it = jso.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = jso.get(key);
            if (value instanceof String) {
                this.m_metadata.put(key, value);
                continue;
            }
            if (value instanceof JSONArray) {
                this.m_metadata.put(key, this.decodeStringArray((JSONArray)value));
                continue;
            }
            if (!(value instanceof JSONObject)) continue;
            this.m_metadata.put(key, this.parseProperties((JSONObject)value));
        }
    }

    private Hashtable<String, Object> parseProperties(JSONObject properties) throws JSONException {
        Hashtable<String, Object> parsedProps = new Hashtable<String, Object>();
        Iterator it = properties.keys();
        while (it.hasNext()) {
            Class<?> typeClass;
            String key = (String)it.next();
            Object value = properties.get(key);
            if (value instanceof String) {
                parsedProps.put(key, value);
                continue;
            }
            if (value instanceof JSONArray) {
                parsedProps.put(key, this.decodeStringArray((JSONArray)value));
                continue;
            }
            if (!(value instanceof JSONObject)) continue;
            JSONObject json = (JSONObject)value;
            String type = json.getString("type");
            Object typeValue = json.get("value");
            if (type == null) {
                throw new JSONException("missing type attribute in json metadata for key " + key);
            }
            if (typeValue == null) {
                throw new JSONException("missing type value attribute in json metadata for key " + key);
            }
            try {
                typeClass = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                throw new JSONException("invalid type attribute (" + type + ") in json metadata for key " + key);
            }
            if (typeValue instanceof JSONArray) {
                parsedProps.put(key, this.toPrimitiveTypeArray(typeClass, (JSONArray)typeValue));
                continue;
            }
            parsedProps.put(key, this.toPrimitiveType(typeClass, typeValue.toString()));
        }
        return parsedProps;
    }

    private Object toPrimitiveType(Class<?> type, String value) throws JSONException {
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Long.class)) {
            return Long.parseLong(value);
        }
        if (type.equals(Double.class)) {
            return Double.valueOf(value);
        }
        if (type.equals(Float.class)) {
            return Float.valueOf(value);
        }
        if (type.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (type.equals(Byte.class)) {
            return Byte.valueOf(value);
        }
        if (type.equals(Character.class)) {
            return Character.valueOf((char)Integer.parseInt(value));
        }
        if (type.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (type.equals(Short.class)) {
            return Short.valueOf(value);
        }
        throw new JSONException("invalid type (" + type + ") attribute in json metadata");
    }

    private Object toPrimitiveTypeArray(Class<?> type, JSONArray array) throws JSONException {
        int len = array.length();
        Object result = Array.newInstance(type, len);
        if (type.equals(String.class)) {
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, array.getString(i));
            }
        } else if (type.equals(Long.class)) {
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, Long.valueOf(array.getString(i)));
            }
        } else if (type.equals(Double.class)) {
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, Double.valueOf(array.getString(i)));
            }
        } else if (type.equals(Float.class)) {
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, Float.valueOf(array.getString(i)));
            }
        } else if (type.equals(Integer.class)) {
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, Integer.valueOf(array.getString(i)));
            }
        } else if (type.equals(Byte.class)) {
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, Byte.valueOf(array.getString(i)));
            }
        } else if (type.equals(Character.class)) {
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, Character.valueOf((char)Integer.parseInt(array.getString(i))));
            }
        } else if (type.equals(Boolean.class)) {
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, Boolean.valueOf(array.getString(i)));
            }
        } else if (type.equals(Short.class)) {
            for (int i = 0; i < len; ++i) {
                Array.set(result, i, Short.valueOf(array.getString(i)));
            }
        } else {
            throw new JSONException("invalid type (" + type + ") attribute in json metadata");
        }
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JSONMetaData clone = (JSONMetaData)super.clone();
        clone.m_metadata = (HashMap)this.m_metadata.clone();
        return clone;
    }

    @Override
    public String getString(Params key) {
        Object value = this.m_metadata.get(key.toString());
        if (value == null) {
            throw new IllegalArgumentException("Parameter " + (Object)((Object)key) + " not found");
        }
        return value.toString();
    }

    @Override
    public String getString(Params key, String def) {
        try {
            return this.getString(key);
        }
        catch (IllegalArgumentException e) {
            return def;
        }
    }

    @Override
    public int getInt(Params key) {
        Object value = this.m_metadata.get(key.toString());
        if (value != null) {
            try {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("parameter " + (Object)((Object)key) + " is not an int value: " + value);
            }
        }
        throw new IllegalArgumentException("missing " + (Object)((Object)key) + " parameter from annotation");
    }

    @Override
    public int getInt(Params key, int def) {
        Object value = this.m_metadata.get(key.toString());
        if (value != null) {
            try {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("parameter " + (Object)((Object)key) + " is not an int value: " + value);
            }
        }
        return def;
    }

    @Override
    public long getLong(Params key) {
        Object value = this.m_metadata.get(key.toString());
        if (value != null) {
            try {
                if (value instanceof Long) {
                    return (Long)value;
                }
                return Long.parseLong(value.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("parameter " + (Object)((Object)key) + " is not a long value: " + value);
            }
        }
        throw new IllegalArgumentException("missing " + (Object)((Object)key) + " parameter from annotation");
    }

    @Override
    public long getLong(Params key, long def) {
        Object value = this.m_metadata.get(key.toString());
        if (value != null) {
            try {
                if (value instanceof Long) {
                    return (Long)value;
                }
                return Long.parseLong(value.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("parameter " + (Object)((Object)key) + " is not a long value: " + value);
            }
        }
        return def;
    }

    @Override
    public String[] getStrings(Params key) {
        Object array = this.m_metadata.get(key.toString());
        if (array == null) {
            throw new IllegalArgumentException("Parameter " + (Object)((Object)key) + " not found");
        }
        if (!(array instanceof String[])) {
            throw new IllegalArgumentException("Parameter " + (Object)((Object)key) + " is not a String[] (" + array.getClass() + ")");
        }
        return (String[])array;
    }

    @Override
    public String[] getStrings(Params key, String[] def) {
        try {
            return this.getStrings(key);
        }
        catch (IllegalArgumentException t) {
            return def;
        }
    }

    @Override
    public Dictionary<String, Object> getDictionary(Params key, Dictionary<String, Object> def) {
        Object dictionary = this.m_metadata.get(key.toString());
        if (dictionary == null) {
            return def;
        }
        if (!(dictionary instanceof Dictionary)) {
            throw new IllegalArgumentException("Parameter " + (Object)((Object)key) + " is not a Dictionary (" + dictionary.getClass() + ")");
        }
        return (Dictionary)dictionary;
    }

    public String toString() {
        return this.m_metadata.toString();
    }

    @Override
    public void setDictionary(Params key, Dictionary<String, Object> dictionary) {
        this.m_metadata.put(key.toString(), dictionary);
    }

    @Override
    public void setString(Params key, String value) {
        this.m_metadata.put(key.toString(), value);
    }

    @Override
    public void setStrings(Params key, String[] values) {
        this.m_metadata.put(key.toString(), values);
    }

    private String[] decodeStringArray(JSONArray array) throws JSONException {
        String[] arr = new String[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("JSON array is not an array of Strings: " + array);
            }
            arr[i] = value.toString();
        }
        return arr;
    }
}

