/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.util;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;

public class Utils {
    public static String getLocalIP() throws UnknownHostException {
        if (Utils.isWindowsOS()) {
            return InetAddress.getLocalHost().getHostAddress();
        }
        return Utils.getLinuxLocalIp();
    }

    public static boolean isWindowsOS() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    private static String getLinuxLocalIp() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                }
            }
        }
        catch (SocketException ex) {
            ip = "127.0.0.1";
            ex.printStackTrace();
        }
        return ip;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties readPropertiesFile(String fileName) {
        try (InputStream inputStream = Utils.class.getClassLoader().getResourceAsStream(fileName);){
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("File: %s is not exist", fileName));
        }
    }
}

