/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.tcp.demo.sub.eventmeshmessage;

import java.util.Optional;
import java.util.Properties;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPClientFactory;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.tcp.common.EventMeshTestUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSubscribe
implements ReceiveMsgHook<EventMeshMessage> {
    private static final Logger log = LoggerFactory.getLogger(AsyncSubscribe.class);
    public static AsyncSubscribe handler = new AsyncSubscribe();
    private static EventMeshTCPClient<EventMeshMessage> client;

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        int eventMeshTcpPort = Integer.parseInt(properties.getProperty("eventmesh.tcp.port"));
        UserAgent userAgent = EventMeshTestUtils.generateClient2();
        EventMeshTCPClientConfig eventMeshTcpClientConfig = EventMeshTCPClientConfig.builder().host(eventMeshIp).port(eventMeshTcpPort).userAgent(userAgent).build();
        try {
            client = EventMeshTCPClientFactory.createEventMeshTCPClient((EventMeshTCPClientConfig)eventMeshTcpClientConfig, EventMeshMessage.class);
            client.init();
            client.subscribe("TEST-TOPIC-TCP-ASYNC", SubscriptionMode.CLUSTERING, SubscriptionType.ASYNC);
            client.registerSubBusiHandler((ReceiveMsgHook)handler);
            client.listen();
        }
        catch (Exception e) {
            log.warn("AsyncSubscribe failed", (Throwable)e);
        }
    }

    public Optional<EventMeshMessage> handle(EventMeshMessage msg) {
        log.info("receive async msg: {}", (Object)msg);
        return Optional.empty();
    }
}

