/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.tcp.demo.sub.cloudevents;

import io.cloudevents.CloudEvent;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPClientFactory;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.tcp.common.EventMeshTestUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSubscribe
implements ReceiveMsgHook<CloudEvent> {
    private static final Logger log = LoggerFactory.getLogger(AsyncSubscribe.class);
    public static AsyncSubscribe handler = new AsyncSubscribe();
    private static EventMeshTCPClient<CloudEvent> client;

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        int eventMeshTcpPort = Integer.parseInt(properties.getProperty("eventmesh.tcp.port"));
        UserAgent userAgent = EventMeshTestUtils.generateClient2();
        EventMeshTCPClientConfig eventMeshTcpClientConfig = EventMeshTCPClientConfig.builder().host(eventMeshIp).port(eventMeshTcpPort).userAgent(userAgent).build();
        try {
            client = EventMeshTCPClientFactory.createEventMeshTCPClient((EventMeshTCPClientConfig)eventMeshTcpClientConfig, CloudEvent.class);
            client.init();
            client.subscribe("TEST-TOPIC-TCP-ASYNC", SubscriptionMode.CLUSTERING, SubscriptionType.ASYNC);
            client.registerSubBusiHandler((ReceiveMsgHook)handler);
            client.listen();
        }
        catch (Exception e) {
            log.warn("AsyncSubscribe failed", (Throwable)e);
        }
    }

    public Optional<CloudEvent> handle(CloudEvent msg) {
        String content = new String(msg.getData().toBytes(), StandardCharsets.UTF_8);
        log.info("receive async msg: {}|{}", (Object)msg, (Object)content);
        return Optional.empty();
    }
}

