/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.tcp.demo.pub.eventmeshmessage;

import java.util.Properties;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPClientFactory;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.tcp.common.EventMeshTestUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRequest {
    private static final Logger log = LoggerFactory.getLogger(SyncRequest.class);
    private static EventMeshTCPClient<EventMeshMessage> client;

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        int eventMeshTcpPort = Integer.parseInt(properties.getProperty("eventmesh.tcp.port"));
        UserAgent userAgent = EventMeshTestUtils.generateClient1();
        EventMeshTCPClientConfig eventMeshTcpClientConfig = EventMeshTCPClientConfig.builder().host(eventMeshIp).port(eventMeshTcpPort).userAgent(userAgent).build();
        try {
            client = EventMeshTCPClientFactory.createEventMeshTCPClient((EventMeshTCPClientConfig)eventMeshTcpClientConfig, EventMeshMessage.class);
            client.init();
            EventMeshMessage eventMeshMessage = EventMeshTestUtils.generateSyncRRMqMsg();
            log.info("begin send rr msg: {}", (Object)eventMeshMessage);
            Package response = client.rr((Object)eventMeshMessage, (long)EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
            log.info("receive rr reply: {}", (Object)response);
        }
        catch (Exception e) {
            log.warn("SyncRequest failed", (Throwable)e);
        }
    }
}

