/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.tcp.demo.pub.eventmeshmessage;

import java.util.Properties;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPClientFactory;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.tcp.common.EventMeshTestUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPublishBroadcast {
    public static Logger logger = LoggerFactory.getLogger(AsyncPublishBroadcast.class);

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        int eventMeshTcpPort = Integer.parseInt(properties.getProperty("eventmesh.tcp.port"));
        UserAgent userAgent = EventMeshTestUtils.generateClient1();
        EventMeshTCPClientConfig eventMeshTcpClientConfig = EventMeshTCPClientConfig.builder().host(eventMeshIp).port(eventMeshTcpPort).userAgent(userAgent).build();
        try (EventMeshTCPClient client = EventMeshTCPClientFactory.createEventMeshTCPClient((EventMeshTCPClientConfig)eventMeshTcpClientConfig, EventMeshMessage.class);){
            client.init();
            EventMeshMessage eventMeshMessage = EventMeshTestUtils.generateBroadcastMqMsg();
            logger.info("begin send broadcast msg: {}", (Object)eventMeshMessage);
            client.broadcast((Object)eventMeshMessage, (long)EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            logger.warn("AsyncPublishBroadcast failed", (Throwable)e);
        }
    }
}

