/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.tcp.demo.pub.cloudevents;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import org.apache.eventmesh.client.tcp.EventMeshTCPClient;
import org.apache.eventmesh.client.tcp.EventMeshTCPClientFactory;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.tcp.common.EventMeshTestUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPublish {
    public static Logger logger = LoggerFactory.getLogger(AsyncPublish.class);
    private static EventMeshTCPClient<CloudEvent> client;

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        int eventMeshTcpPort = Integer.parseInt(properties.getProperty("eventmesh.tcp.port"));
        try {
            UserAgent userAgent = EventMeshTestUtils.generateClient1();
            EventMeshTCPClientConfig eventMeshTcpClientConfig = EventMeshTCPClientConfig.builder().host(eventMeshIp).port(eventMeshTcpPort).userAgent(userAgent).build();
            client = EventMeshTCPClientFactory.createEventMeshTCPClient((EventMeshTCPClientConfig)eventMeshTcpClientConfig, CloudEvent.class);
            client.init();
            for (int i = 0; i < 2; ++i) {
                CloudEvent event = EventMeshTestUtils.generateCloudEventV1Async();
                logger.info("begin send async msg[{}]: {}", (Object)i, (Object)event);
                client.publish((Object)event, (long)EventMeshCommon.DEFAULT_TIME_OUT_MILLS);
                Thread.sleep(1000L);
            }
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            logger.warn("AsyncPublish failed", (Throwable)e);
        }
    }
}

