/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.tcp.common;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.EventMeshMessage;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.JsonUtils;

public class EventMeshTestUtils {
    private static final int seqLength = 10;

    public static UserAgent generateClient1() {
        UserAgent agent = UserAgent.builder().env("test").host("127.0.0.1").password(EventMeshTestUtils.generateRandomString(8)).username("PU4283").group("EventmeshTestGroup").path("/data/app/umg_proxy").port(8362).subsystem("5023").pid(32893).version("2.0.11").idc("FT").build();
        return MessageUtils.generatePubClient((UserAgent)agent);
    }

    public static UserAgent generateClient2() {
        UserAgent agent = UserAgent.builder().env("test").host("127.0.0.1").password(EventMeshTestUtils.generateRandomString(8)).username("PU4283").group("EventmeshTestGroup").path("/data/app/umg_proxy").port(9362).subsystem("5017").pid(42893).version("2.0.11").idc("FT").build();
        return MessageUtils.generateSubClient((UserAgent)agent);
    }

    public static Package syncRR() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.REQUEST_TO_SERVER, 0, null, EventMeshTestUtils.generateRandomString(10)));
        msg.setBody((Object)EventMeshTestUtils.generateSyncRRMqMsg());
        return msg;
    }

    public static Package asyncRR() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.REQUEST_TO_SERVER, 0, null, EventMeshTestUtils.generateRandomString(10)));
        msg.setBody((Object)EventMeshTestUtils.generateAsyncRRMqMsg());
        return msg;
    }

    public static Package asyncMessage() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.ASYNC_MESSAGE_TO_SERVER, 0, null, EventMeshTestUtils.generateRandomString(10)));
        msg.setBody((Object)EventMeshTestUtils.generateAsyncEventMqMsg());
        return msg;
    }

    public static Package broadcastMessage() {
        Package msg = new Package();
        msg.setHeader(new Header(Command.BROADCAST_MESSAGE_TO_SERVER, 0, null, EventMeshTestUtils.generateRandomString(10)));
        msg.setBody((Object)EventMeshTestUtils.generateBroadcastMqMsg());
        return msg;
    }

    public static Package rrResponse(EventMeshMessage request) {
        Package msg = new Package();
        msg.setHeader(new Header(Command.RESPONSE_TO_SERVER, 0, null, EventMeshTestUtils.generateRandomString(10)));
        msg.setBody((Object)request);
        return msg;
    }

    public static EventMeshMessage generateSyncRRMqMsg() {
        EventMeshMessage mqMsg = new EventMeshMessage();
        mqMsg.setTopic("TEST-TOPIC-TCP-SYNC");
        mqMsg.getProperties().put("msgtype", "persistent");
        mqMsg.getProperties().put("ttl", "300000");
        mqMsg.getProperties().put("keys", EventMeshTestUtils.generateRandomString(16));
        mqMsg.setBody("testSyncRR");
        return mqMsg;
    }

    private static EventMeshMessage generateAsyncRRMqMsg() {
        EventMeshMessage mqMsg = new EventMeshMessage();
        mqMsg.setTopic("TEST-TOPIC-TCP-SYNC");
        mqMsg.getProperties().put("replyto", "localhost@ProducerGroup-producerPool-9-access#V1_4_0#CI");
        mqMsg.getProperties().put("ttl", "300000");
        mqMsg.getProperties().put("propertymessagereplyto", "notnull");
        mqMsg.setBody("testAsyncRR");
        return mqMsg;
    }

    public static EventMeshMessage generateAsyncEventMqMsg() {
        EventMeshMessage mqMsg = new EventMeshMessage();
        mqMsg.setTopic("TEST-TOPIC-TCP-ASYNC");
        mqMsg.getProperties().put("replyto", "localhost@ProducerGroup-producerPool-9-access#V1_4_0#CI");
        mqMsg.getProperties().put("ttl", "30000");
        mqMsg.getProperties().put("propertymessagereplyto", "notnull");
        mqMsg.setBody("testAsyncMessage");
        return mqMsg;
    }

    public static EventMeshMessage generateBroadcastMqMsg() {
        EventMeshMessage mqMsg = new EventMeshMessage();
        mqMsg.setTopic("TEST-TOPIC-TCP-ASYNC");
        mqMsg.getProperties().put("replyto", "localhost@ProducerGroup-producerPool-9-access#V1_4_0#CI");
        mqMsg.getProperties().put("ttl", "30000");
        mqMsg.getProperties().put("propertymessagereplyto", "notnull");
        mqMsg.setBody("testAsyncMessage");
        return mqMsg;
    }

    private static String generateRandomString(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append((char)ThreadLocalRandom.current().nextInt(48, 57));
        }
        return builder.toString();
    }

    public static CloudEvent generateCloudEventV1Async() {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("content", "testAsyncMessage");
        CloudEvent event = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withSubject("TEST-TOPIC-TCP-ASYNC").withSource(URI.create("/")).withDataContentType("application/cloudevents+json").withType(EventMeshCommon.CLOUD_EVENTS_PROTOCOL_NAME).withData(JsonUtils.serialize(content).getBytes(StandardCharsets.UTF_8))).withExtension("ttl", "30000")).build();
        return event;
    }

    public static CloudEvent generateCloudEventV1SyncRR() {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("content", "testSyncRR");
        CloudEvent event = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withSubject("TEST-TOPIC-TCP-SYNC").withSource(URI.create("/")).withDataContentType("application/cloudevents+json").withType(EventMeshCommon.CLOUD_EVENTS_PROTOCOL_NAME).withData(JsonUtils.serialize(content).getBytes(StandardCharsets.UTF_8))).withExtension("ttl", "30000")).withExtension("msgtype", "persistent")).withExtension("keys", EventMeshTestUtils.generateRandomString(16))).build();
        return event;
    }
}

