/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.http.demo.sub.controller;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.provider.EventFormatProvider;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.http.demo.sub.service.SubService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sub"})
public class SubController {
    private static final Logger log = LoggerFactory.getLogger(SubController.class);
    @Autowired
    private SubService subService;

    @RequestMapping(value={"/test"}, method={RequestMethod.POST})
    public String subTest(HttpServletRequest request) {
        String content = request.getParameter("content");
        log.info("receive message: {}", (Object)content);
        Map contentMap = (Map)JsonUtils.deserialize((String)content, HashMap.class);
        if (StringUtils.equals((CharSequence)EventMeshCommon.CLOUD_EVENTS_PROTOCOL_NAME, (CharSequence)((CharSequence)contentMap.get("protocoltype")))) {
            CloudEvent event = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json").deserialize(content.getBytes(StandardCharsets.UTF_8));
            String data = new String(event.getData().toBytes(), StandardCharsets.UTF_8);
            log.info("receive data: {}", (Object)data);
        }
        this.subService.consumeMessage(content);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("retCode", 1);
        return JsonUtils.serialize(map);
    }
}

