/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.http.demo.pub.eventmeshmessage;

import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.producer.EventMeshHttpProducer;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRequestInstance {
    public static Logger logger = LoggerFactory.getLogger(SyncRequestInstance.class);

    public static void main(String[] args) throws Exception {
        EventMeshHttpProducer eventMeshHttpProducer = null;
        String eventMeshIPPort = "127.0.0.1:10105";
        String topic = "TEST-TOPIC-HTTP-SYNC";
        try {
            if (args.length > 0 && StringUtils.isNotBlank((CharSequence)args[0])) {
                eventMeshIPPort = args[0];
            }
            if (args.length > 1 && StringUtils.isNotBlank((CharSequence)args[1])) {
                topic = args[1];
            }
            if (StringUtils.isBlank((CharSequence)eventMeshIPPort)) {
                eventMeshIPPort = "127.0.0.1:10105";
            }
            EventMeshHttpClientConfig eventMeshClientConfig = EventMeshHttpClientConfig.builder().liteEventMeshAddr(eventMeshIPPort).producerGroup("EventMeshTest-producerGroup").env("env").idc("idc").ip(IPUtils.getLocalAddress()).sys("1234").pid(String.valueOf(ThreadUtils.getPID())).build();
            eventMeshHttpProducer = new EventMeshHttpProducer(eventMeshClientConfig);
            long startTime = System.currentTimeMillis();
            EventMeshMessage eventMeshMessage = EventMeshMessage.builder().bizSeqNo(RandomStringUtils.generateNum((int)30)).content("contentStr with special protocal").topic(topic).uniqueId(RandomStringUtils.generateNum((int)30)).build();
            EventMeshMessage rsp = eventMeshHttpProducer.request(eventMeshMessage, 10000L);
            if (logger.isDebugEnabled()) {
                logger.debug("sendmsg: {}, return: {}, cost:{} ms", new Object[]{eventMeshMessage.getContent(), rsp.getContent(), System.currentTimeMillis() - startTime});
            }
        }
        catch (Exception e) {
            logger.warn("send msg failed", (Throwable)e);
        }
        Thread.sleep(30000L);
        try {
            EventMeshHttpProducer close = eventMeshHttpProducer;
            Throwable throwable = null;
            if (close != null) {
                if (throwable != null) {
                    try {
                        close.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    close.close();
                }
            }
        }
        catch (Exception e1) {
            logger.warn("producer shutdown exception", (Throwable)e1);
        }
    }
}

