/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.http.demo.pub.eventmeshmessage;

import com.google.common.base.Preconditions;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.producer.EventMeshHttpProducer;
import org.apache.eventmesh.client.http.producer.RRCallback;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSyncRequestInstance {
    private static final Logger log = LoggerFactory.getLogger(AsyncSyncRequestInstance.class);

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        Preconditions.checkNotNull((Object)properties, (Object)"application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        String eventMeshHttpPort = properties.getProperty("eventmesh.http.port");
        EventMeshHttpProducer eventMeshHttpProducer = null;
        try {
            String eventMeshIPPort = eventMeshIp + ":" + eventMeshHttpPort;
            if (StringUtils.isBlank((CharSequence)eventMeshIPPort)) {
                eventMeshIPPort = "127.0.0.1:10105";
            }
            EventMeshHttpClientConfig eventMeshClientConfig = EventMeshHttpClientConfig.builder().liteEventMeshAddr(eventMeshIPPort).producerGroup("EventMeshTest-producerGroup").env("env").idc("idc").ip(IPUtils.getLocalAddress()).sys("1234").pid(String.valueOf(ThreadUtils.getPID())).build();
            eventMeshHttpProducer = new EventMeshHttpProducer(eventMeshClientConfig);
            final long startTime = System.currentTimeMillis();
            final EventMeshMessage eventMeshMessage = EventMeshMessage.builder().bizSeqNo(RandomStringUtils.generateNum((int)30)).content("testAsyncMessage").topic("TEST-TOPIC-TCP-ASYNC").uniqueId(RandomStringUtils.generateNum((int)30)).build();
            eventMeshHttpProducer.request(eventMeshMessage, (RRCallback)new RRCallback<EventMeshMessage>(){

                public void onSuccess(EventMeshMessage o) {
                    log.debug("sendmsg: {}, return: {}, cost: {} ms", new Object[]{eventMeshMessage.getContent(), o.getContent(), System.currentTimeMillis() - startTime});
                }

                public void onException(Throwable e) {
                    log.debug("send msg failed", e);
                }
            }, 3000L);
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            log.warn("async send msg failed", (Throwable)e);
        }
        Thread.sleep(30000L);
        try {
            EventMeshHttpProducer ignore = eventMeshHttpProducer;
            Throwable throwable = null;
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        catch (Exception e1) {
            log.warn("producer shutdown exception", (Throwable)e1);
        }
    }
}

