/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.http.demo.pub.eventmeshmessage;

import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.producer.EventMeshHttpProducer;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPublishInstance {
    private static final Logger log = LoggerFactory.getLogger(AsyncPublishInstance.class);
    public static int messageSize = 5;

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        String eventMeshHttpPort = properties.getProperty("eventmesh.http.port");
        String eventMeshIPPort = StringUtils.isBlank((CharSequence)eventMeshIp) || StringUtils.isBlank((CharSequence)eventMeshHttpPort) ? "127.0.0.1:10105" : eventMeshIp + ":" + eventMeshHttpPort;
        EventMeshHttpClientConfig eventMeshClientConfig = EventMeshHttpClientConfig.builder().liteEventMeshAddr(eventMeshIPPort).producerGroup("EventMeshTest-producerGroup").env("env").idc("idc").ip(IPUtils.getLocalAddress()).sys("1234").pid(String.valueOf(ThreadUtils.getPID())).userName("eventmesh").password("pass").build();
        try (EventMeshHttpProducer eventMeshHttpProducer = new EventMeshHttpProducer(eventMeshClientConfig);){
            for (int i = 0; i < messageSize; ++i) {
                HashMap<String, String> content = new HashMap<String, String>();
                content.put("content", "testPublishMessage");
                EventMeshMessage eventMeshMessage = EventMeshMessage.builder().bizSeqNo(RandomStringUtils.generateNum((int)30)).content(JsonUtils.serialize(content)).topic("TEST-TOPIC-HTTP-ASYNC").uniqueId(RandomStringUtils.generateNum((int)30)).build().addProp("ttl", String.valueOf(4000));
                eventMeshHttpProducer.publish(eventMeshMessage);
            }
            Thread.sleep(30000L);
        }
    }
}

