/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.http.demo.pub.cloudevents;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.producer.EventMeshHttpProducer;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPublishInstance {
    private static final Logger log = LoggerFactory.getLogger(AsyncPublishInstance.class);
    public static final int MESSAGE_SIZE = 1;

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        String eventMeshHttpPort = properties.getProperty("eventmesh.http.port");
        String eventMeshIPPort = "127.0.0.1:10105";
        if (StringUtils.isNotBlank((CharSequence)eventMeshIp) || StringUtils.isNotBlank((CharSequence)eventMeshHttpPort)) {
            eventMeshIPPort = eventMeshIp + ":" + eventMeshHttpPort;
        }
        EventMeshHttpClientConfig eventMeshClientConfig = EventMeshHttpClientConfig.builder().liteEventMeshAddr(eventMeshIPPort).producerGroup("EventMeshTest-producerGroup").env("env").idc("idc").ip(IPUtils.getLocalAddress()).sys("1234").pid(String.valueOf(ThreadUtils.getPID())).userName("eventmesh").password("pass").build();
        try (EventMeshHttpProducer eventMeshHttpProducer = new EventMeshHttpProducer(eventMeshClientConfig);){
            for (int i = 0; i < 1; ++i) {
                HashMap<String, String> content = new HashMap<String, String>();
                content.put("content", "testAsyncMessage");
                CloudEvent event = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withSubject("TEST-TOPIC-HTTP-ASYNC").withSource(URI.create("/")).withDataContentType("application/cloudevents+json").withType(EventMeshCommon.CLOUD_EVENTS_PROTOCOL_NAME).withData(JsonUtils.serialize(content).getBytes(StandardCharsets.UTF_8))).withExtension("ttl", String.valueOf(4000))).build();
                eventMeshHttpProducer.publish(event);
                log.info("publish event success content: {}", content);
            }
            Thread.sleep(30000L);
        }
    }
}

