/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.grpc.sub.app.service;

import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.annotation.PreDestroy;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.consumer.EventMeshGrpcConsumer;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.grpc.pub.eventmeshmessage.AsyncPublishInstance;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class SubService
implements InitializingBean {
    public static Logger logger = LoggerFactory.getLogger(SubService.class);
    private EventMeshGrpcConsumer eventMeshGrpcConsumer;
    final Properties properties = Utils.readPropertiesFile("application.properties");
    final SubscriptionItem subscriptionItem = new SubscriptionItem();
    final String localIp = IPUtils.getLocalAddress();
    final String localPort = this.properties.getProperty("server.port");
    final String eventMeshIp = this.properties.getProperty("eventmesh.ip");
    final String eventMeshGrpcPort = this.properties.getProperty("eventmesh.grpc.port");
    final String url = "http://" + this.localIp + ":" + this.localPort + "/sub/test";
    final String env = "P";
    final String idc = "FT";
    final String subsys = "1234";
    private CountDownLatch countDownLatch = new CountDownLatch(AsyncPublishInstance.messageSize);

    public void afterPropertiesSet() throws Exception {
        EventMeshGrpcClientConfig eventMeshClientConfig = EventMeshGrpcClientConfig.builder().serverAddr(this.eventMeshIp).serverPort(Integer.parseInt(this.eventMeshGrpcPort)).consumerGroup("EventMeshTest-consumerGroup").env("P").idc("FT").sys("1234").build();
        this.eventMeshGrpcConsumer = new EventMeshGrpcConsumer(eventMeshClientConfig);
        this.eventMeshGrpcConsumer.init();
        this.subscriptionItem.setTopic("TEST-TOPIC-GRPC-ASYNC");
        this.subscriptionItem.setMode(SubscriptionMode.CLUSTERING);
        this.subscriptionItem.setType(SubscriptionType.ASYNC);
        this.eventMeshGrpcConsumer.subscribe(Collections.singletonList(this.subscriptionItem), this.url);
        Thread stopThread = new Thread(() -> {
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.info("stopThread start....");
            System.exit(0);
        });
        stopThread.start();
    }

    @PreDestroy
    public void cleanup() {
        logger.info("start destory ....");
        try {
            this.eventMeshGrpcConsumer.unsubscribe(Collections.singletonList(this.subscriptionItem), this.url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            EventMeshGrpcConsumer ignore = this.eventMeshGrpcConsumer;
            Throwable throwable = null;
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("end destory.");
    }

    public void consumeMessage(String msg) {
        logger.info("consume message: {}", (Object)msg);
        this.countDownLatch.countDown();
        logger.info("remaining number of messages to be consumed: {}", (Object)this.countDownLatch.getCount());
    }
}

