/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.grpc.sub;

import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.consumer.EventMeshGrpcConsumer;
import org.apache.eventmesh.client.grpc.consumer.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.SubscriptionType;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventmeshSubscribeReply
implements ReceiveMsgHook<EventMeshMessage> {
    private static final Logger log = LoggerFactory.getLogger(EventmeshSubscribeReply.class);
    public static EventmeshSubscribeReply handler = new EventmeshSubscribeReply();

    public static void main(String[] args) throws InterruptedException {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        String eventMeshGrpcPort = properties.getProperty("eventmesh.grpc.port");
        EventMeshGrpcClientConfig eventMeshClientConfig = EventMeshGrpcClientConfig.builder().serverAddr(eventMeshIp).serverPort(Integer.parseInt(eventMeshGrpcPort)).consumerGroup("EventMeshTest-consumerGroup").env("env").idc("idc").sys("1234").build();
        SubscriptionItem subscriptionItem = new SubscriptionItem();
        subscriptionItem.setTopic("TEST-TOPIC-GRPC-RR");
        subscriptionItem.setMode(SubscriptionMode.CLUSTERING);
        subscriptionItem.setType(SubscriptionType.SYNC);
        EventMeshGrpcConsumer eventMeshGrpcConsumer = new EventMeshGrpcConsumer(eventMeshClientConfig);
        eventMeshGrpcConsumer.init();
        eventMeshGrpcConsumer.registerListener((ReceiveMsgHook)handler);
        eventMeshGrpcConsumer.subscribe(Collections.singletonList(subscriptionItem));
        Thread.sleep(60000L);
        eventMeshGrpcConsumer.unsubscribe(Collections.singletonList(subscriptionItem));
    }

    public Optional<EventMeshMessage> handle(EventMeshMessage msg) {
        log.info("receive request-reply msg: {}", (Object)msg);
        if (msg != null) {
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    public String getProtocolType() {
        return EventMeshCommon.EM_MESSAGE_PROTOCOL_NAME;
    }
}

