/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.grpc.pub.eventmeshmessage;

import java.util.HashMap;
import java.util.Properties;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.producer.EventMeshGrpcProducer;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPublishInstance {
    private static final Logger log = LoggerFactory.getLogger(AsyncPublishInstance.class);
    public static int messageSize = 5;

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        String eventMeshGrpcPort = properties.getProperty("eventmesh.grpc.port");
        EventMeshGrpcClientConfig eventMeshClientConfig = EventMeshGrpcClientConfig.builder().serverAddr(eventMeshIp).serverPort(Integer.parseInt(eventMeshGrpcPort)).producerGroup("EventMeshTest-producerGroup").env("env").idc("idc").sys("1234").build();
        EventMeshGrpcProducer eventMeshGrpcProducer = new EventMeshGrpcProducer(eventMeshClientConfig);
        eventMeshGrpcProducer.init();
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("content", "testAsyncMessage");
        for (int i = 0; i < messageSize; ++i) {
            EventMeshMessage eventMeshMessage = EventMeshMessage.builder().content(JsonUtils.serialize(content)).topic("TEST-TOPIC-GRPC-ASYNC").uniqueId(RandomStringUtils.generateNum((int)30)).bizSeqNo(RandomStringUtils.generateNum((int)30)).build().addProp("ttl", String.valueOf(4000));
            eventMeshGrpcProducer.publish(eventMeshMessage);
            Thread.sleep(1000L);
        }
        Thread.sleep(30000L);
        EventMeshGrpcProducer ignore = eventMeshGrpcProducer;
        Throwable throwable = null;
        if (ignore != null) {
            if (throwable != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignore.close();
            }
        }
    }
}

