/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.grpc.pub.cloudevents;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.producer.EventMeshGrpcProducer;
import org.apache.eventmesh.client.tcp.common.EventMeshCommon;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventsBatchPublishInstance {
    private static final Logger log = LoggerFactory.getLogger(CloudEventsBatchPublishInstance.class);

    public static void main(String[] args) throws Exception {
        Properties properties = Utils.readPropertiesFile("application.properties");
        String eventMeshIp = properties.getProperty("eventmesh.ip");
        String eventMeshGrpcPort = properties.getProperty("eventmesh.grpc.port");
        EventMeshGrpcClientConfig eventMeshClientConfig = EventMeshGrpcClientConfig.builder().serverAddr(eventMeshIp).serverPort(Integer.parseInt(eventMeshGrpcPort)).producerGroup("EventMeshTest-producerGroup").env("env").idc("idc").sys("1234").build();
        EventMeshGrpcProducer eventMeshGrpcProducer = new EventMeshGrpcProducer(eventMeshClientConfig);
        eventMeshGrpcProducer.init();
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("content", "testRequestReplyMessage");
        ArrayList<CloudEvent> cloudEventList = new ArrayList<CloudEvent>();
        for (int i = 0; i < 5; ++i) {
            CloudEvent event = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withSubject("TEST-TOPIC-GRPC-ASYNC").withSource(URI.create("/")).withDataContentType("application/cloudevents+json").withType(EventMeshCommon.CLOUD_EVENTS_PROTOCOL_NAME).withData(JsonUtils.serialize(content).getBytes(StandardCharsets.UTF_8))).withExtension("ttl", String.valueOf(4000))).build();
            cloudEventList.add(event);
        }
        eventMeshGrpcProducer.publish(cloudEventList);
        Thread.sleep(10000L);
        EventMeshGrpcProducer ignore = eventMeshGrpcProducer;
        Throwable throwable = null;
        if (ignore != null) {
            if (throwable != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignore.close();
            }
        }
    }
}

