/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.web;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.empire.struts2.action.Disposable;
import org.apache.empire.struts2.web.DefaultWebRequest;
import org.apache.empire.struts2.web.EmpireThreadManager;
import org.apache.empire.struts2.web.WebApplication;
import org.apache.empire.struts2.web.WebRequest;
import org.apache.empire.struts2.web.WebSession;
import org.apache.empire.struts2.web.servlet.ServletContextWrapper;
import org.apache.empire.struts2.web.servlet.ServletRequestWrapper;
import org.apache.empire.struts2.web.servlet.ServletResponseWrapper;
import org.apache.empire.struts2.web.servlet.ServletSessionWrapper;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmpireStrutsDispatcher
extends Dispatcher {
    protected static Logger log = LoggerFactory.getLogger(EmpireStrutsDispatcher.class);
    public final String APPLICATION_CLASS = "ApplicationClass";
    public final String SESSION_CLASS = "SessionClass";
    public final String REQUEST_CLASS = "RequestClass";
    private String sessionClassName = null;
    private String requestClassName = null;
    private boolean logRequestWarning = true;

    @Deprecated
    public static Object getCurrentRequest() {
        return EmpireThreadManager.getCurrentRequest();
    }

    public EmpireStrutsDispatcher(ServletContext servletContext, Map<String, String> initParams) {
        super(servletContext, initParams);
        String appClassName = initParams.get("ApplicationClass");
        if (appClassName != null) {
            this.createApplicationObject(servletContext, appClassName);
        }
        this.sessionClassName = initParams.get("SessionClass");
        this.requestClassName = initParams.get("RequestClass");
        if (this.requestClassName == null || this.requestClassName.length() == 0) {
            this.requestClassName = DefaultWebRequest.class.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAction(HttpServletRequest request, HttpServletResponse response, ServletContext context, ActionMapping mapping) throws ServletException {
        try {
            if (this.sessionClassName != null) {
                Object applObj = context.getAttribute("webApp");
                this.createSessionObject(request, applObj);
            }
            boolean continueProcessing = true;
            if (this.requestClassName != null) {
                Object sessObj = request.getSession().getAttribute("webSession");
                continueProcessing = this.createRequestObject(request, response, sessObj);
            }
            if (continueProcessing) {
                if (log.isDebugEnabled()) {
                    log.debug("starting servlet service request");
                }
                super.serviceAction(request, response, context, mapping);
            }
        }
        catch (Exception e) {
            log.error("Failed to process request due to Exception.", (Throwable)e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("cleanung up request");
            }
            int exitCode = this.disposeAction(request);
            EmpireThreadManager.exit(exitCode);
        }
    }

    private int disposeAction(HttpServletRequest request) {
        int exitCode = 0;
        Object action = request.getAttribute("action");
        if (action != null) {
            if (action instanceof Disposable) {
                exitCode = ((Disposable)action).dispose();
            } else {
                log.warn("Cannot dispose action. Action does not implement the Disposible interface)");
            }
            request.removeAttribute("action");
        } else {
            log.warn("Cannot dispose action. Action is not supplied on the request. (Missing ActionBasicsInterceptor?)");
        }
        return exitCode;
    }

    private Object createObject(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> c = Class.forName(className);
        return c.newInstance();
    }

    protected void createApplicationObject(ServletContext servletContext, String appClassName) {
        try {
            if (servletContext.getAttribute("webApp") == null) {
                Object app = this.createObject(appClassName);
                if (app instanceof WebApplication) {
                    ((WebApplication)app).init(new ServletContextWrapper(servletContext));
                } else {
                    log.warn("Application object does not implement IWebApplication!");
                }
                servletContext.setAttribute("webApp", app);
            }
        }
        catch (Exception e) {
            log.error("Failed to create web application object of type " + appClassName + " --> " + e.getMessage());
        }
    }

    protected void createSessionObject(HttpServletRequest request, Object applObj) {
        try {
            HttpSession httpSession = request.getSession(false);
            if (httpSession == null || httpSession.getAttribute("webSession") == null) {
                Object session = this.createObject(this.sessionClassName);
                httpSession = request.getSession(true);
                if (session instanceof WebSession) {
                    ((WebSession)session).init(new ServletSessionWrapper(httpSession), applObj);
                } else {
                    log.warn("Session object does not implement IWebSession!");
                }
                httpSession.setAttribute("webSession", session);
            }
        }
        catch (Exception e) {
            log.error("Failed to create session [" + this.sessionClassName + "] msg= " + e.getMessage());
        }
    }

    protected boolean createRequestObject(HttpServletRequest request, HttpServletResponse response, Object sessObj) {
        try {
            Object reqObj = request.getAttribute("webRequest");
            if (reqObj == null) {
                reqObj = this.createObject(this.requestClassName);
                EmpireThreadManager.setCurrentRequest(reqObj);
                if (reqObj instanceof WebRequest) {
                    ServletRequestWrapper req = new ServletRequestWrapper(request);
                    ServletResponseWrapper res = new ServletResponseWrapper(response);
                    return ((WebRequest)reqObj).init(req, res, sessObj);
                }
                if (this.logRequestWarning) {
                    log.warn("Request object does not implement IWebRequest!");
                    this.logRequestWarning = false;
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error("Failed to create request [" + this.requestClassName + "] msg= " + e.getMessage());
            this.requestClassName = null;
            return true;
        }
    }
}

