/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import java.io.Writer;
import java.util.HashMap;
import javax.servlet.jsp.JspException;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.components.AnchorComponent;
import org.apache.empire.struts2.jsp.tags.LinkTag;
import org.apache.empire.struts2.jsp.tags.TableHeadRowTag;

public class TableHeadColumnTag
extends LinkTag {
    protected ColumnExpr column;
    protected ColumnExpr[] select;
    protected String selectName;
    protected String selectAction;
    protected String width;
    protected String height;
    protected String colspan;
    protected String rowspan;
    protected String align;
    protected String valign;
    protected String wrap;
    protected String bgcolor;
    protected String columnname;
    private String orderIndicator = null;

    protected void resetParams() {
        this.column = null;
        this.select = null;
        this.width = null;
        this.height = null;
        this.colspan = null;
        this.rowspan = null;
        this.align = null;
        this.valign = null;
        this.wrap = null;
        this.bgcolor = null;
        this.columnname = null;
        super.resetParams();
    }

    public String getBody() {
        String body = super.getBody();
        if (this.orderIndicator == null || this.orderIndicator.length() == 0) {
            return body;
        }
        if (body == null || body.length() == 0) {
            return this.orderIndicator;
        }
        return this.orderIndicator + " " + body;
    }

    public int doStartTag() throws JspException {
        TableHeadRowTag.HeadRowInfo hri = this.getHeadRowInfo();
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        this.orderIndicator = this.getSortOrderIdicator(hri, dic);
        HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
        HtmlWriter.HtmlTag wrap = w.startTag(dic.TableHeadColumnTag());
        wrap.addAttribute("id", this.getId());
        wrap.addAttribute("class", this.getCssClass(hri));
        this.setStyleAndWrap(wrap, hri);
        wrap.addAttribute("width", this.width);
        wrap.addAttribute("height", this.height);
        wrap.addAttribute("colspan", this.colspan);
        wrap.addAttribute("rowspan", this.rowspan);
        wrap.addAttribute("align", this.str(this.align, hri.columnAlign));
        wrap.addAttribute("valign", this.valign);
        wrap.addAttribute("bgcolor", this.bgcolor);
        wrap.beginBody();
        if (this.prepareLinkParams(hri)) {
            this.cssClass = this.getLinkClass(hri, dic);
            this.cssStyle = null;
            if (this.onclick == null) {
                this.onclick = dic.TableHeadLinkDefaultOnClickScript();
            }
            if (this.select != null) {
                this.renderColumnSelect(w);
                this.text = "";
            }
            super.doStartTag();
            AnchorComponent anchor = (AnchorComponent)this.component;
            anchor.addParameter(hri.sortColumnParam, this.getColumnName());
            if (hri.sortOrderChangeable && hri.sortOrderParam != null) {
                anchor.addParameter(hri.sortOrderParam, hri.sortDescending ? "0" : "1");
            }
            super.doEndTag();
        } else {
            HtmlWriter.HtmlTag text = w.startTag("span");
            text.addAttribute("class", this.getLinkClass(hri, dic));
            text.beginBody(this.getColumnTitle());
            text.endTag(this.getBody());
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
        HtmlWriter.HtmlTag wrap = w.continueTag(dic.TableHeadColumnTag(), true);
        wrap.endTag();
        this.resetParams();
        return 6;
    }

    private void renderColumnSelect(HtmlWriter w) {
        HtmlWriter.HtmlTag selectTag = w.startTag("select");
        selectTag.addAttribute("name", this.selectName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(this.selectName, "");
        selectTag.addAttribute("onchange", "window.location='" + this.getActionURL(this.selectAction, params) + "'+options[selectedIndex].value");
        selectTag.beginBody();
        for (int i = 0; i < this.select.length; ++i) {
            HtmlWriter.HtmlTag option = w.startTag("option");
            option.addAttribute("value", this.select[i].getName());
            option.addAttribute("selected", this.select[i].equals(this.column));
            option.endTag(this.getString(this.select[i].getTitle()));
        }
        selectTag.endTag();
    }

    private TableHeadRowTag.HeadRowInfo getHeadRowInfo() {
        Object hri = this.getPageAttribute("tableHeadRowInfo", null);
        if (hri instanceof TableHeadRowTag.HeadRowInfo) {
            return (TableHeadRowTag.HeadRowInfo)hri;
        }
        log.error("No table head row information available! <e:thr> Tag missing?" + this.getPageName());
        return new TableHeadRowTag.HeadRowInfo();
    }

    private void setStyleAndWrap(HtmlWriter.HtmlTag tag, TableHeadRowTag.HeadRowInfo hri) {
        String style = this.str(this.cssStyle, hri.columnStyle);
        String wordwrap = this.str(this.wrap, hri.columnWrap);
        if ("nowrap".equalsIgnoreCase(wordwrap)) {
            tag.addAttribute("nowrap");
        } else if (wordwrap != null && wordwrap.length() > 0) {
            wordwrap = "word-wrap: " + wordwrap + ";";
            style = style != null ? style + " " + wordwrap : wordwrap;
        }
        tag.addAttribute("style", style);
    }

    private boolean prepareLinkParams(TableHeadRowTag.HeadRowInfo hri) {
        if (this.action == null) {
            this.action = hri.sortAction;
        }
        if (this.text == null) {
            this.text = this.getColumnTitle();
        }
        return this.action != null && this.column != null;
    }

    private String getColumnName() {
        return this.str(this.columnname, this.column.getName());
    }

    private String getColumnTitle() {
        if (this.text != null) {
            return this.getString((Object)this.text, "");
        }
        if (this.column != null) {
            return this.getTranslation(this.column.getTitle());
        }
        log.error("No Title given for Table Head Column on page " + this.getPageName());
        return "";
    }

    private boolean isCurrentColumn(TableHeadRowTag.HeadRowInfo hri) {
        if (this.column == null || hri.currentColumnName == null) {
            return false;
        }
        return hri.currentColumnName.equalsIgnoreCase(this.column.getName());
    }

    private String getSortOrderIdicator(TableHeadRowTag.HeadRowInfo hri, HtmlTagDictionary dic) {
        if (!hri.sortOrderChangeable) {
            return null;
        }
        if (this.isCurrentColumn(hri)) {
            boolean desc = hri.sortDescending;
            if (this.select != null) {
                return desc ? dic.TableHeadSelectAscendingIndicator() : dic.TableHeadSelectDescendingIndicator();
            }
            return desc ? dic.TableHeadSortDescendingIndicator() : dic.TableHeadSortAscendingIndicator();
        }
        if (this.select != null) {
            return dic.TableHeadSelectColumnIndicator();
        }
        return null;
    }

    private String getCssClass(TableHeadRowTag.HeadRowInfo hri) {
        if (this.cssClass != null) {
            return this.cssClass;
        }
        if (hri.currentClass != null && this.isCurrentColumn(hri)) {
            return hri.currentClass;
        }
        return hri.columnClass;
    }

    private String getLinkClass(TableHeadRowTag.HeadRowInfo hri, HtmlTagDictionary dic) {
        if (this.isCurrentColumn(hri)) {
            if (!hri.sortOrderChangeable) {
                return dic.TableHeadColumnLinkCurrentClass();
            }
            if (hri.sortDescending) {
                return dic.TableHeadColumnLinkCurrentDescendingClass();
            }
            return dic.TableHeadColumnLinkCurrentAscendingClass();
        }
        if (this.action == null || this.item == null || this.getBoolean(this.disabled, false)) {
            return dic.TableHeadColumnLinkDisabledClass();
        }
        return dic.TableHeadColumnLinkEnabledClass();
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
    }

    public void setColspan(String colspan) {
        this.colspan = colspan;
    }

    public void setColumn(ColumnExpr column) {
        this.column = column;
    }

    public void setColumnname(String columnname) {
        this.columnname = columnname;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setWrap(String wrap) {
        this.wrap = wrap;
    }

    public void setRowspan(String rowspan) {
        this.rowspan = rowspan;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setSelect(ColumnExpr[] select) {
        this.select = select;
    }

    public void setSelectAction(String selectAction) {
        this.selectAction = selectAction;
    }

    public void setSelectName(String selectName) {
        this.selectName = selectName;
    }
}

