/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.struts2.action.ListPagingInfo;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.components.AnchorComponent;
import org.apache.empire.struts2.jsp.tags.EmpireTagSupport;
import org.apache.struts2.components.Component;

public class ListPageBarTag
extends EmpireTagSupport {
    protected ListPagingInfo pagingInfo;
    protected Object size;
    protected String action;
    protected String setPageParam;
    protected String label;
    protected String linkClass;
    protected String textClass;
    protected String padding;
    protected String onclick;

    public ListPageBarTag() {
        this.autoResetParams = false;
    }

    protected void resetParams() {
        this.pagingInfo = null;
        this.action = null;
        this.label = null;
        this.linkClass = null;
        this.textClass = null;
        this.padding = null;
        this.setPageParam = null;
        this.onclick = null;
        super.resetParams();
    }

    public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        return new AnchorComponent(stack, req, res);
    }

    protected void populateParams() {
        super.populateParams();
        AnchorComponent anchor = (AnchorComponent)this.component;
        anchor.setAction(this.action);
    }

    protected void populatePageParams(int pageIndex, boolean isCurrent, String text) {
        AnchorComponent anchor = (AnchorComponent)this.component;
        anchor.setAction(this.action);
        anchor.setText(text);
        anchor.setDisabled(isCurrent);
        anchor.addParameter(this.setPageParam, String.valueOf(pageIndex));
        anchor.setOnclick(this.onclick);
    }

    public int doStartTag() throws JspException {
        this.action = this.checkAction(this.action);
        return 2;
    }

    public int doEndTag() throws JspException {
        String pagerLabel;
        int current = Math.max(this.pagingInfo.getPage(), 0);
        int pageCnt = Math.max(this.pagingInfo.getPageCount(), 1);
        if (pageCnt <= 1) {
            return 6;
        }
        int ctlSize = Math.max(this.getInt(this.size, 5), 1);
        int begIndex = current / ctlSize * ctlSize;
        int endIndex = begIndex + ctlSize;
        this.setPageParam = this.getSetPageParamName();
        String body = this.getBody();
        this.setBodyContent(null);
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
        if (this.padding == null) {
            this.padding = dic.PagerPaddingText();
        }
        String pbeg_e = dic.PagerFirstPageText();
        String prwd_e = dic.PagerRewindText();
        String pfwd_e = dic.PagerForwardText();
        String pend_e = dic.PagerLastPageText();
        String pbeg_d = dic.PagerFirstPageTextDisabled();
        String prwd_d = dic.PagerRewindTextDisabled();
        String pfwd_d = dic.PagerForwardTextDisabled();
        String pend_d = dic.PagerLastPageTextDisabled();
        HtmlWriter.HtmlTag div = w.startTag(dic.PagerTag());
        this.addStandardAttributes(div, dic.PagerClass());
        div.beginBody(body, true);
        this.cssClass = this.str(this.linkClass, dic.PagerLinkClass());
        this.cssStyle = null;
        if (this.onclick == null) {
            this.onclick = dic.PagerLinkDefaultOnClickScript();
        }
        if ((pagerLabel = this.getString(this.str(this.label, dic.PagerLabelText()))) != null) {
            HtmlWriter.HtmlTag label = w.startTag(dic.PagerLabelTag());
            label.addAttribute("class", dic.PagerLabelClass());
            label.endTag(pagerLabel);
        }
        this.renderButton(w, pbeg_e, pbeg_d, true, pageCnt, current, 0);
        this.renderButton(w, prwd_e, prwd_d, true, pageCnt, current, Math.max(current - 1, 0));
        for (int pageIndex = begIndex; pageIndex < endIndex; ++pageIndex) {
            if (pageIndex > 0 && this.padding != null) {
                w.println(this.padding);
            }
            HtmlWriter.HtmlTag page = w.startTag(dic.PagerPageTag());
            div.addAttribute("class", dic.PagerPageClass());
            page.beginBody();
            String pageText = String.valueOf(pageIndex + 1);
            if (pageIndex >= pageCnt) {
                pageText = "&nbsp;";
            }
            this.renderButton(w, pageText, pageText, false, pageCnt, current, pageIndex);
            page.endTag(true);
        }
        this.renderButton(w, pfwd_e, pfwd_d, true, pageCnt, current, Math.min(current + 1, pageCnt));
        this.renderButton(w, pend_e, pend_d, true, pageCnt, current, pageCnt - 1);
        div.endTag();
        this.resetParams();
        return 6;
    }

    private void renderButton(HtmlWriter w, String text_enabled, String text_disabled, boolean image, int count, int current, int page) throws JspException {
        boolean disabled;
        boolean bl = disabled = page == current;
        if (page < 0 || page >= count) {
            disabled = true;
        }
        super.doStartTag();
        this.populatePageParams(page, disabled, disabled ? text_disabled : text_enabled);
        super.doEndTag();
        w.println();
    }

    private String getSetPageParamName() {
        if (this.pagingInfo == null) {
            return "page";
        }
        String listProperty = this.pagingInfo.getListPropertyName();
        if (StringUtils.isEmpty((String)listProperty)) {
            return "page";
        }
        return listProperty + ".page";
    }

    public void setPagingInfo(ListPagingInfo pagingInfo) {
        this.pagingInfo = pagingInfo;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setLinkClass(String linkClass) {
        this.linkClass = linkClass;
    }

    public void setSize(Object size) {
        this.size = size;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }
}

