/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.empire.db.DBReader;
import org.apache.struts2.components.Component;
import org.apache.struts2.components.IteratorComponent;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.views.jsp.IteratorStatus;
import org.apache.struts2.views.jsp.IteratorTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemListTag
extends IteratorTag {
    protected static Logger log = LoggerFactory.getLogger(ItemListTag.class);
    private Object source;
    private Object maxItems;
    private String property;
    private Object sourceObject;
    private Object oldProperty;
    private Object oldStatusAttr;

    public void resetParams() {
        this.source = null;
        this.maxItems = null;
        this.statusAttr = null;
        this.sourceObject = null;
    }

    public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        Iterator iterator = this.getIterator(this.sourceObject);
        return new ItemIteratorComponent(stack, this.pageContext, this.sourceObject, iterator);
    }

    public int doStartTag() throws JspException {
        this.sourceObject = this.getSourceObject(this.source);
        if (this.source == null) {
            log.error("No reader or beanlist supplied for e:list tag. Skipping body.");
            this.property = null;
            return 0;
        }
        this.oldStatusAttr = this.pageContext.getAttribute("listRowStatus");
        this.statusAttr = this.oldStatusAttr != null ? this.oldStatusAttr.toString() + "Nested" : "listStatusAttrName";
        this.pageContext.setAttribute("listRowStatus", (Object)this.statusAttr);
        if (this.property != null) {
            this.oldProperty = this.pageContext.getAttribute("parentPropertyName");
            this.pageContext.setAttribute("parentPropertyName", (Object)this.property);
        }
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        if (this.property != null) {
            this.removePageAttribute("parentPropertyName", this.oldProperty);
        }
        this.oldProperty = null;
        if (this.statusAttr != null) {
            this.removePageAttribute("listRowStatus", this.oldStatusAttr);
        }
        this.oldStatusAttr = null;
        if (this.component != null) {
            ((ItemIteratorComponent)this.component).dispose();
        }
        this.resetParams();
        return super.doEndTag();
    }

    private void removePageAttribute(String name, Object oldValue) {
        if (oldValue != null) {
            this.pageContext.setAttribute(name, oldValue);
        } else {
            this.pageContext.removeAttribute(name);
        }
    }

    private Object getSourceObject(Object value) {
        if (value instanceof String) {
            String strval = value.toString();
            if (strval.startsWith("%{") && strval.endsWith("}")) {
                strval = strval.substring(2, strval.length() - 1);
                value = this.getStack().findValue(strval);
            } else if (strval.startsWith("#")) {
                value = this.getStack().findValue(strval);
            } else if (strval.startsWith("$")) {
                if (!(strval = strval.substring(1)).startsWith("$")) {
                    value = this.getAttribute(strval);
                }
                if (value == null) {
                    return null;
                }
            }
        }
        return value;
    }

    private Iterator getIterator(Object value) {
        if (value instanceof DBReader) {
            int maxCount = this.getIntValue(this.maxItems, -1);
            return ((DBReader)value).iterator(maxCount);
        }
        if (!MakeIterator.isIterable((Object)value)) {
            log.error("Cannot make an iterator of class " + value.getClass().getName());
            return null;
        }
        return MakeIterator.convert((Object)value);
    }

    private int getIntValue(Object value, int defValue) {
        if (value == null) {
            return defValue;
        }
        if (value instanceof String) {
            String strval = value.toString();
            if (strval.startsWith("%{") && strval.endsWith("}")) {
                strval = strval.substring(2, strval.length() - 1);
                value = this.getStack().findValue(strval, Integer.class);
            }
            if (strval.startsWith("#")) {
                value = this.getStack().findValue(strval, Integer.class);
            }
            if (strval.startsWith("$")) {
                if (!(strval = strval.substring(1)).startsWith("$")) {
                    value = this.getAttribute(strval);
                }
                if (value == null) {
                    return defValue;
                }
            }
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            log.error("getIntFromString: given value is not a number!");
            return defValue;
        }
    }

    protected Object getAttribute(String attribute) {
        Object obj = this.pageContext.getAttribute(attribute);
        if (obj != null) {
            return obj;
        }
        obj = this.pageContext.getRequest().getAttribute(attribute);
        if (obj != null) {
            return obj;
        }
        obj = this.pageContext.getSession().getAttribute(attribute);
        if (obj != null) {
            return obj;
        }
        return this.pageContext.getServletContext().getAttribute(attribute);
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public void setMaxItems(Object maxItems) {
        this.maxItems = maxItems;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public static class ItemIteratorComponent
    extends IteratorComponent {
        private PageContext pageContext;
        private boolean isReader;
        private Object oldSource;
        private Object srcObject;

        public ItemIteratorComponent(ValueStack stack, PageContext pageContext, Object source, Iterator iterator) {
            super(stack);
            this.pageContext = pageContext;
            this.iterator = iterator;
            this.isReader = source instanceof DBReader;
            this.srcObject = source;
            if (this.isReader) {
                this.oldSource = pageContext.getAttribute("record");
                pageContext.setAttribute("record", source);
            } else {
                this.oldSource = pageContext.getAttribute("bean");
                pageContext.setAttribute("bean", null);
            }
        }

        public void dispose() {
            String pageAttribute;
            if (this.isReader) {
                ((DBReader)this.srcObject).close();
                pageAttribute = "record";
            } else {
                pageAttribute = "bean";
            }
            if (this.oldSource != null) {
                this.pageContext.setAttribute(pageAttribute, this.oldSource);
            } else {
                this.pageContext.removeAttribute(pageAttribute);
            }
            this.pageContext = null;
            this.oldSource = null;
            this.srcObject = null;
        }

        public boolean start(Writer writer) {
            Object currentValue;
            if (this.iterator == null) {
                log.error("No Iterator for ItemListTag supplied. Ignoring body");
                return false;
            }
            if (this.statusAttr != null) {
                this.statusState = new IteratorStatus.StatusState();
                this.status = new IteratorStatus(this.statusState);
            }
            ValueStack stack = this.getStack();
            if (this.iterator != null && this.iterator.hasNext() && (currentValue = this.iterator.next()) != null) {
                stack.push(currentValue);
                String id = this.getVar();
                if (id != null) {
                    stack.getContext().put(id, currentValue);
                }
                if (this.statusAttr != null) {
                    this.statusState.setLast(!this.isReader ? !this.iterator.hasNext() : false);
                    this.oldStatus = stack.getContext().get(this.statusAttr);
                    stack.getContext().put(this.statusAttr, this.status);
                }
                if (!this.isReader) {
                    this.pageContext.setAttribute("bean", currentValue);
                }
                return true;
            }
            this.iterator = null;
            super.end(writer, "");
            return false;
        }

        public boolean end(Writer writer, String body) {
            if (this.isReader) {
                IteratorStatus tmpStatus = this.status;
                this.status = null;
                boolean result = super.end(writer, body);
                this.status = tmpStatus;
                if (this.status != null) {
                    if (result) {
                        this.statusState.next();
                    } else if (this.oldStatus == null) {
                        this.stack.getContext().put(this.statusAttr, null);
                    } else {
                        this.stack.getContext().put(this.statusAttr, this.oldStatus);
                    }
                }
                return result;
            }
            boolean result = super.end(writer, body);
            if (result) {
                ValueStack stack = this.getStack();
                this.pageContext.setAttribute("bean", stack.peek());
            }
            return result;
        }
    }
}

