/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.Record;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.jsp.components.InputControlComponent;
import org.apache.empire.struts2.jsp.controls.InputControl;
import org.apache.empire.struts2.jsp.controls.InputControlManager;
import org.apache.empire.struts2.jsp.tags.EmpireValueTagSupport;
import org.apache.struts2.components.Component;

public class InputControlTag
extends EmpireValueTagSupport {
    protected Column column;
    protected Options options;
    protected String controlType;
    protected String render;
    protected String disabledMode;
    protected String format;
    protected Object hsize;
    protected Object vsize;
    protected String name;
    protected String label;
    protected String labelClass;
    protected String labelStyle;
    protected Object required;
    protected Object disabled;
    protected String tabindex;
    protected String onclick;
    protected String onchange;
    protected String onfocus;
    protected String onblur;
    protected Object nullValue;

    protected void resetParams() {
        this.column = null;
        this.options = null;
        this.controlType = null;
        this.render = null;
        this.disabledMode = null;
        this.format = null;
        this.hsize = null;
        this.vsize = null;
        this.name = null;
        this.label = null;
        this.labelClass = null;
        this.labelStyle = null;
        this.required = null;
        this.disabled = null;
        this.onclick = null;
        this.onchange = null;
        this.onfocus = null;
        this.onblur = null;
        this.tabindex = null;
        this.nullValue = null;
        super.resetParams();
    }

    public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        InputControl control;
        if (this.controlType == null) {
            this.controlType = this.getControlType();
        }
        if (this.cssClass == null) {
            HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
            this.cssClass = dic.InputDefaultClass(this.controlType, this.isReadOnly());
        }
        if ((control = InputControlManager.getControl(this.controlType)) == null) {
            control = InputControlManager.getControl("text");
        }
        return new InputControlComponent(control, stack, req, res);
    }

    protected void populateParams() {
        super.populateParams();
        if (this.disabledMode == null) {
            this.disabledMode = StringUtils.toString((Object)this.getPageAttribute("defaultDisabledMode", null));
        }
        InputControlComponent comp = (InputControlComponent)this.component;
        comp.setOptions(this.getLookupOptions());
        comp.setColumn(this.column);
        comp.setRecordValue(this.getValue());
        comp.setNullValue(this.getObject(this.nullValue, this.getPageAttribute("defaultNullValue", null)));
        comp.setName(this.getString((Object)this.name, this.getControlName()));
        comp.setLabel(this.getString((Object)this.label, this.getTranslation(this.column.getTitle())));
        comp.setLabelClass(this.labelClass);
        comp.setLabelStyle(this.labelStyle);
        comp.setRequired(this.isRequired() ? "true" : "false");
        comp.setReadOnly(this.isReadOnly());
        comp.setRenderType(this.render);
        comp.setDisabledMode(this.disabledMode);
        comp.setFormat(this.format);
        comp.setHSize(this.getString(this.hsize, this.getPageAttribute("defaultControlSize", null)));
        comp.setVSize(this.getString(this.vsize));
        comp.setOnclick(this.onclick);
        comp.setOnchange(this.onchange);
        comp.setOnfocus(this.onfocus);
        comp.setOnblur(this.onblur);
        comp.setTabindex(this.getString(this.tabindex));
    }

    private boolean isReadOnly() {
        if (this.disabled != null) {
            return this.getBoolean(this.disabled, false);
        }
        Object readOnly = this.getPageAttribute("readOnly", null);
        if (readOnly != null && ObjectUtils.getBoolean((Object)readOnly)) {
            return true;
        }
        Record record = this.getRecord();
        if (record != null) {
            return record.isFieldReadOnly(this.column);
        }
        if (this.getRecordData() != null) {
            return true;
        }
        if (this.getBean() != null) {
            return this.column.isReadOnly();
        }
        return false;
    }

    private boolean isRequired() {
        if (this.required != null) {
            return this.getBoolean(this.required, false);
        }
        if (this.getRecord() != null || this.getBean() != null) {
            return this.column.isRequired();
        }
        return false;
    }

    private String getControlName() {
        String name = this.getPropertyFieldName();
        if (name != null) {
            return name;
        }
        return this.getColumnPropertyName((ColumnExpr)this.column);
    }

    private Options getLookupOptions() {
        if (this.options == null) {
            Record rec = this.getRecord();
            if (rec != null && rec.isValid()) {
                return rec.getFieldOptions(this.column);
            }
            return this.column.getOptions();
        }
        return this.options;
    }

    public final void setColumn(Column column) {
        this.column = column;
        super.setColumn((ColumnExpr)column);
    }

    public final void setRecordProperty(String property) {
        super.setParentProperty(property);
    }

    public final void setOptions(Options options) {
        this.options = options;
    }

    public final void setRender(String render) {
        this.render = render;
    }

    public final void setDisabledMode(String disabledMode) {
        this.disabledMode = disabledMode;
    }

    public final void setFormat(String format) {
        this.format = format;
    }

    public final void setDisabled(Object disabled) {
        this.disabled = disabled;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public final void setLabelClass(String labelClass) {
        this.labelClass = labelClass;
    }

    public final void setLabelStyle(String labelStyle) {
        this.labelStyle = labelStyle;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setRequired(Object required) {
        this.required = required;
    }

    public final void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }

    public final void setHsize(Object hsize) {
        this.hsize = hsize;
    }

    public final void setVsize(Object vsize) {
        this.vsize = vsize;
    }

    public final void setNullValue(Object nullValue) {
        this.nullValue = nullValue;
    }

    public final void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public final void setControlType(String controlType) {
        this.controlType = controlType;
    }

    public final void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    public final void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public final void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }
}

