/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.Record;
import org.apache.empire.data.RecordData;
import org.apache.empire.struts2.jsp.tags.EmpireTagSupport;

public abstract class EmpireValueTagSupport
extends EmpireTagSupport {
    public static final String RECORD_ATTRIBUTE = "record";
    public static final String BEAN_ITEM_ATTRIBUTE = "bean";
    public static final String PARENT_PROPERTY_ATTRIBUTE = "parentPropertyName";
    private ColumnExpr column;
    private Object value;
    private String field;
    private String property;
    private String parentProperty;
    private RecordData record;

    protected void resetParams() {
        this.column = null;
        this.value = null;
        this.field = null;
        this.property = null;
        this.parentProperty = null;
        this.record = null;
        super.resetParams();
    }

    protected boolean hasValue() {
        return this.property != null || this.field != null || this.value != null;
    }

    protected RecordData getRecordData() {
        Object recObj;
        if (this.record == null && (recObj = this.pageContext.getAttribute(RECORD_ATTRIBUTE)) instanceof RecordData) {
            this.record = (RecordData)recObj;
        }
        return this.record;
    }

    protected Record getRecord() {
        if (this.getRecordData() instanceof Record) {
            if (!((Record)this.record).isValid()) {
                log.warn("The record supplied is not valid!");
                return null;
            }
            return (Record)this.record;
        }
        return null;
    }

    protected Object getBean() {
        return this.pageContext.getAttribute(BEAN_ITEM_ATTRIBUTE);
    }

    protected ColumnExpr getColumnExpr() {
        if (this.column != null) {
            return this.column;
        }
        if (this.value instanceof ColumnExpr) {
            return (ColumnExpr)this.value;
        }
        if (this.field != null && this.getRecordData() != null) {
            return this.record.getColumnExpr(this.record.getFieldIndex(this.field));
        }
        return null;
    }

    protected Column getColumn() {
        ColumnExpr column = this.getColumnExpr();
        if (column == null) {
            return null;
        }
        return column.getSourceColumn();
    }

    protected String getControlType() {
        Column column = this.getColumn();
        if (column == null) {
            return "text";
        }
        return column.getControlType();
    }

    protected String getTagName(String suppliedName) {
        if (StringUtils.isNotEmpty((String)suppliedName)) {
            return suppliedName;
        }
        if (this.property != null) {
            return this.getFullPropertyName(this.property);
        }
        if (this.field != null) {
            return this.getFullPropertyName(this.field);
        }
        if (this.value instanceof ColumnExpr) {
            return this.getColumnPropertyName((ColumnExpr)this.value);
        }
        if (this.column != null) {
            return this.getColumnPropertyName(this.column);
        }
        log.error("Cannot detect name from value.");
        return "";
    }

    protected Object getValue() {
        if (this.value == null) {
            if (this.property != null) {
                return this.getStack().findValue(this.getFullPropertyName(this.property), Object.class);
            }
            if (this.field != null) {
                return this.getRecordFieldValue(this.getRecordData(), this.field, null);
            }
        }
        return this.getRecordValue(this.getRecordData(), this.value, null);
    }

    protected String getStringValue() {
        return StringUtils.toString((Object)this.getValue());
    }

    protected String getItemValue(Object item) {
        if (item instanceof String) {
            String str = item.toString();
            if (str.length() == 0) {
                return null;
            }
            char prefix = str.charAt(0);
            if (prefix == '%' || prefix == '#' || prefix == '$') {
                return this.getString((Object)str, null);
            }
            if (prefix == '!') {
                return ((String)item).substring(1);
            }
            if (prefix < 'A') {
                log.error("Invalid property or field name supplied for item.");
                return null;
            }
            if (this.property != null) {
                String fullName = this.getFullPropertyName(str);
                return (String)this.getStack().findValue(fullName, String.class);
            }
            return StringUtils.toString((Object)this.getRecordFieldValue(this.record, str, null));
        }
        return StringUtils.toString((Object)this.getRecordValue(this.record, item, null));
    }

    protected String getPropertyFieldName() {
        if (this.property != null) {
            return this.getFullPropertyName(this.property);
        }
        if (this.field != null) {
            return this.getFullPropertyName(this.field);
        }
        return null;
    }

    protected String getFullPropertyName(String name) {
        if ("*".equals(name) && this.column != null) {
            name = this.column.getBeanPropertyName();
        }
        if (this.parentProperty == null) {
            this.parentProperty = StringUtils.toString((Object)this.getPageAttribute(PARENT_PROPERTY_ATTRIBUTE, null));
        }
        if (this.parentProperty != null) {
            return this.parentProperty + "." + name;
        }
        return name;
    }

    protected String getColumnPropertyName(ColumnExpr col) {
        return this.getFullPropertyName(col.getName());
    }

    protected boolean setPropertyNameFromValue() {
        String strval;
        if (this.property == null && this.value instanceof String && (strval = (String)this.value).startsWith("%{") && strval.endsWith("}")) {
            this.property = strval.substring(2, strval.length() - 1).trim();
            return true;
        }
        return false;
    }

    protected boolean hasDefaultValue() {
        return this.value != null && (this.property != null || this.field != null || this.column != null);
    }

    protected Object getDefaultValue() {
        if (this.property != null) {
            return this.getStack().findValue(this.getFullPropertyName(this.property), Object.class);
        }
        if (this.field != null) {
            return this.getRecordFieldValue(this.getRecordData(), this.field, null);
        }
        return this.getRecordValue(this.getRecordData(), null, null);
    }

    private Object getRecordFieldValue(RecordData rec, String field, Object defValue) {
        if (field == null) {
            return defValue;
        }
        if (rec != null) {
            int index = rec.getFieldIndex(field);
            if (index >= 0) {
                return rec.getValue(index);
            }
            log.error("Supplied field '" + field + "' not found in record.");
        } else {
            log.error("No record supplied for field value");
        }
        return defValue;
    }

    private Object getRecordValue(RecordData rec, Object value, Object defValue) {
        if (value == null && this.column != null) {
            value = this.column;
        }
        if (value instanceof ColumnExpr) {
            ColumnExpr column = (ColumnExpr)value;
            if (rec != null) {
                int index = rec.getFieldIndex(column);
                if (index < 0) {
                    log.debug("Column object '" + column.getName() + "' not found. Trying name.");
                    index = rec.getFieldIndex(column.getName());
                    if (index < 0) {
                        log.error("Column '" + column.getName() + "' not found in record.");
                        return null;
                    }
                }
                return rec.getValue(index);
            }
            Object bean = this.getBean();
            if (bean != null) {
                String prop = column.getBeanPropertyName();
                return this.getBeanProperty(bean, prop);
            }
            return defValue;
        }
        return this.getObject(value, defValue);
    }

    public final void setField(String field) {
        this.field = StringUtils.validate((String)field);
    }

    public final void setProperty(String property) {
        this.property = StringUtils.validate((String)property);
    }

    public final void setParentProperty(String property) {
        this.parentProperty = StringUtils.validate((String)property);
    }

    public final void setRecord(RecordData record) {
        this.record = record;
    }

    public final void setValue(Object value) {
        this.value = value;
    }

    public final void setColumn(ColumnExpr column) {
        this.column = column;
    }
}

