/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.empire.struts2.action.ActionErrorProvider;
import org.apache.empire.struts2.action.ErrorInfo;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.tags.EmpireTagSupport;
import org.apache.struts2.components.Component;

public class ActionErrorsTag
extends EmpireTagSupport {
    private String actionErrorClass;
    private String fieldErrorClass;

    protected void resetParams() {
        this.actionErrorClass = null;
        this.fieldErrorClass = null;
        super.resetParams();
    }

    public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        return null;
    }

    public int doStartTag() throws JspException {
        Object action = this.getAction();
        if (action instanceof ActionErrorProvider) {
            HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
            this.renderAllErrors(w, (ActionErrorProvider)action);
        } else {
            log.error("Cannot render errors. Action does implement ActionErrorProvider.");
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.resetParams();
        return 6;
    }

    private void renderAllErrors(HtmlWriter w, ActionErrorProvider provider) {
        boolean hasFieldErrors;
        ErrorInfo lastActionError = provider.getLastActionError(true);
        Map<String, ErrorInfo> fieldErrors = provider.getItemErrors();
        boolean hasActionError = lastActionError != null;
        boolean bl = hasFieldErrors = fieldErrors != null && fieldErrors.size() > 0;
        if (!hasActionError && !hasFieldErrors) {
            return;
        }
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        HtmlWriter.HtmlTag list = w.startTag(dic.ErrorListTag());
        this.addStandardAttributes(list, dic.ErrorListClass());
        list.beginBody();
        if (hasFieldErrors) {
            Collection<ErrorInfo> errors = fieldErrors.values();
            String fieldErrClass = this.str(this.fieldErrorClass, dic.ErrorItemEntryClass());
            for (ErrorInfo e : errors) {
                String msg = provider.getLocalizedErrorMessage(e);
                this.renderError(w, fieldErrClass, msg);
            }
        }
        if (hasActionError) {
            String actionErrClass = this.str(this.actionErrorClass, dic.ErrorActionEntryClass());
            String msg = provider.getLocalizedErrorMessage(lastActionError);
            this.renderError(w, actionErrClass, msg);
        }
        list.endTag();
    }

    private void renderError(HtmlWriter w, String cssClassName, String msg) {
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        HtmlWriter.HtmlTag tag = w.startTag(dic.ErrorEntryTag());
        String wrapTag = dic.ErrorEntryWrapperTag();
        if (wrapTag != null && wrapTag.length() > 0) {
            tag.beginBody();
            HtmlWriter.HtmlTag wrap = w.startTag(wrapTag);
            wrap.addAttribute("class", cssClassName);
            wrap.endTag(msg);
        } else {
            tag.addAttribute("class", cssClassName);
            tag.beginBody(msg);
        }
        tag.endTag();
    }

    public void setActionErrorClass(String actionErrorClass) {
        this.actionErrorClass = actionErrorClass;
    }

    public void setFieldErrorClass(String fieldErrorClass) {
        this.fieldErrorClass = fieldErrorClass;
    }
}

