/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.controls;

import java.util.Locale;
import org.apache.commons.lang.xwork.StringEscapeUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.controls.InputControl;

public class TextAreaInputControl
extends InputControl {
    private static final char NBSP = '\u00a0';

    protected Object parseValue(String value, Locale locale, Column column) {
        int idx;
        int len = value.length();
        for (idx = len - 1; idx >= 0 && (value.charAt(idx) == '\u00a0' || value.charAt(idx) == ' '); --idx) {
        }
        if (++idx < len) {
            value = value.substring(0, idx);
        }
        len = idx;
        for (idx = 0; idx < len && (value.charAt(idx) == '\u00a0' || value.charAt(idx) == ' '); ++idx) {
        }
        if (idx > 0) {
            value = value.substring(idx);
        }
        return value;
    }

    public void renderText(HtmlWriter writer, InputControl.ValueInfo vi) {
        if (vi instanceof InputControl.ControlInfo) {
            InputControl.ControlInfo ci = (InputControl.ControlInfo)vi;
            String style = StringUtils.valueOf((Object)ci.getCssStyle());
            if (style.toLowerCase().indexOf("height") < 0) {
                if (style.length() > 0) {
                    style = style + ";";
                }
                double height = (double)Math.max(ci.getVSize(), 2) * 1.25;
                style = style + "height:" + height + "em";
            }
            HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
            HtmlWriter.HtmlTag div = writer.startTag(dic.InputReadOnlyDataWrapperTag());
            div.addAttribute("id", ci.getId());
            div.addAttribute("class", ci.getCssClass());
            div.addAttribute("style", style);
            div.beginBody();
            this.internalRenderText(writer, vi);
            div.endTag();
        } else {
            super.internalRenderText(writer, vi);
        }
    }

    protected void internalRenderText(HtmlWriter writer, InputControl.ValueInfo vi) {
        String text = this.formatValue(vi);
        text = StringUtils.replaceAll((String)text, (String)"\r", (String)"");
        text = StringUtils.replaceAll((String)text, (String)"\n", (String)"<br />");
        this.printText(writer, text, "&nbsp;");
    }

    public void renderInput(HtmlWriter writer, InputControl.ControlInfo ci) {
        String checklength;
        HtmlWriter.HtmlTag input = writer.startTag("textarea");
        input.addAttribute("id", ci.getId());
        input.addAttribute("class", ci.getCssClass());
        input.addAttribute("style", ci.getCssStyle());
        input.addAttribute("name", ci.getName());
        input.addAttribute("disabled", ci.getDisabled());
        input.addAttribute("rows", Math.max(ci.getVSize(), 2));
        input.addAttribute("cols", Math.max(ci.getHSize(), 1));
        if (!ci.getDisabled() && StringUtils.isNotEmpty((String)(checklength = this.getFormatOption(ci, "maxlength:")))) {
            int maxLength = (int)ci.getColumn().getSize();
            checklength = StringUtils.replace((String)checklength, (String)"{0}", (String)String.valueOf(maxLength));
            input.addAttribute("onkeypress", checklength);
            input.addAttribute("onkeyup", checklength);
        }
        input.addAttribute("onclick", ci.getOnclick());
        input.addAttribute("onchange", ci.getOnchange());
        input.addAttribute("onfocus", ci.getOnfocus());
        input.addAttribute("onblur", ci.getOnblur());
        String value = StringUtils.toString((Object)ci.getValue());
        value = StringEscapeUtils.escapeHtml((String)value);
        input.beginBody(value);
        input.endTag();
    }
}

