/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.controls;

import java.util.Locale;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.struts2.action.RequestParamProvider;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.controls.InputControl;

public class RadioInputControl
extends InputControl {
    private static String RBCHECK_POSTFIX = "__RBCHECK";

    public Object getFieldValue(String name, RequestParamProvider request, Locale locale, Column column) {
        Object val = super.getFieldValue(name, request, locale, column);
        if (val == NO_VALUE && request.getRequestParam(name + RBCHECK_POSTFIX) != null) {
            return NULL_VALUE;
        }
        return val;
    }

    public void renderInput(HtmlWriter writer, InputControl.ControlInfo ci) {
        HtmlWriter.HtmlTag radioGroupWrapper = writer.startTag("table");
        radioGroupWrapper.addAttribute("cellspacing", "0");
        radioGroupWrapper.addAttribute("cellpadding", "0");
        radioGroupWrapper.addAttribute("id", ci.getId());
        radioGroupWrapper.addAttribute("class", ci.getCssClass());
        radioGroupWrapper.addAttribute("style", ci.getCssStyle());
        radioGroupWrapper.beginBody();
        Options options = ci.getOptions();
        if (options != null) {
            if (this.hasFormatOption(ci, "labelAbove")) {
                this.renderLabelAboveControl(writer, ci, options);
            } else {
                this.renderLabelNextToControl(writer, ci, options, this.hasFormatOption(ci, "labelLeft"));
            }
            if (!options.contains(ci.getValue()) && !ci.getDisabled()) {
                HtmlWriter.HtmlTag hidden = writer.startTag("input");
                hidden.addAttribute("type", "hidden");
                hidden.addAttribute("name", ci.getName() + RBCHECK_POSTFIX);
                hidden.addAttribute("value", ci.getValue());
                hidden.endTag();
            }
        } else {
            log.error("No option list supplied for control type 'radio'");
        }
        radioGroupWrapper.endTag();
    }

    private void renderInput(HtmlWriter writer, InputControl.ControlInfo ci, OptionEntry entry, int pairs) {
        boolean disabled = ci.getDisabled();
        Object current = ci.getValue();
        Object value = entry.getValue();
        HtmlWriter.HtmlTag input = writer.startTag("input");
        input.addAttribute("type", "radio");
        input.addAttribute("id", ci.getId() + pairs);
        input.addAttribute("value", value);
        input.addAttribute("name", ci.getName());
        if (ObjectUtils.compareEqual((Object)current, (Object)value)) {
            input.addAttribute("checked");
        }
        if (disabled) {
            input.addAttribute("disabled");
        }
        input.addAttribute("onclick", ci.getOnclick());
        input.addAttribute("onchange", ci.getOnchange());
        input.addAttribute("onfocus", ci.getOnfocus());
        input.addAttribute("onblur", ci.getOnblur());
        input.endTag();
    }

    private void renderLabel(HtmlWriter writer, InputControl.ControlInfo ci, OptionEntry entry, int pairs) {
        HtmlWriter.HtmlTag label = writer.startTag("label");
        label.addAttribute("for", ci.getId() + pairs);
        label.beginBody(ci.getTranslation(entry.getText()));
        label.endTag();
    }

    private void renderLabelAboveControl(HtmlWriter writer, InputControl.ControlInfo ci, Options options) {
        HtmlWriter.HtmlTag td;
        int pairs = 1;
        HtmlWriter.HtmlTag row = writer.startTag("tr");
        row.beginBody();
        for (OptionEntry entry : options) {
            td = writer.startTag("th");
            td.beginBody();
            this.renderLabel(writer, ci, entry, pairs);
            td.endTag();
            ++pairs;
        }
        row.endTag();
        pairs = 1;
        row = writer.startTag("tr");
        row.beginBody();
        for (OptionEntry entry : options) {
            td = writer.startTag("td");
            td.beginBody();
            this.renderInput(writer, ci, entry, pairs);
            td.endTag();
            ++pairs;
        }
        row.endTag();
    }

    private void renderLabelNextToControl(HtmlWriter writer, InputControl.ControlInfo ci, Options options, boolean labelFirst) {
        int pairs = 1;
        HtmlWriter.HtmlTag row = writer.startTag("tr");
        row.beginBody();
        for (OptionEntry entry : options) {
            HtmlWriter.HtmlTag radioOptionWrapper = writer.startTag("td");
            radioOptionWrapper.beginBody();
            if (labelFirst) {
                this.renderLabel(writer, ci, entry, pairs);
                this.renderInput(writer, ci, entry, pairs);
            } else {
                this.renderInput(writer, ci, entry, pairs);
                this.renderLabel(writer, ci, entry, pairs);
            }
            ++pairs;
            radioOptionWrapper.endTag();
        }
        row.endTag();
    }
}

