/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.controls;

import java.util.Locale;
import org.apache.empire.data.Column;
import org.apache.empire.struts2.action.RequestParamProvider;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.controls.InputControl;

public class PhoneInputControl
extends InputControl {
    private static final String LKZ = "__LKZ";
    private static final String OKZ = "__OKZ";
    private static final String TKZ = "__TKZ";

    public Object getFieldValue(String name, RequestParamProvider request, Locale locale, Column column) {
        String lkz = request.getRequestParam(name + LKZ);
        String okz = request.getRequestParam(name + OKZ);
        String tnk = request.getRequestParam(name + TKZ);
        if (lkz == null && okz == null && tnk == null) {
            return NO_VALUE;
        }
        return this.getPhone(lkz, okz, tnk);
    }

    public void renderInput(HtmlWriter writer, InputControl.ControlInfo ci) {
        String phone = this.formatValue(ci);
        String lkz = this.GetLKZ(phone);
        String okz = this.GetOKZ(phone);
        String tnr = this.GetTNR(phone);
        this.renderPart(writer, ci, LKZ, lkz, 4, false);
        writer.print(" - ");
        this.renderPart(writer, ci, OKZ, okz, 8, false);
        writer.print(" - ");
        this.renderPart(writer, ci, TKZ, tnr, 20, true);
    }

    private void renderPart(HtmlWriter writer, InputControl.ControlInfo ci, String namePostFix, String part, int size, boolean setIdForLabel) {
        HtmlWriter.HtmlTag input = writer.startTag("input");
        input.addAttribute("type", "text");
        input.addAttribute("id", setIdForLabel ? ci.getId() : null);
        input.addAttribute("class", ci.getCssClass());
        input.addAttribute("style", ci.getCssStyle());
        input.addAttribute("size", size);
        if (!ci.getDisabled()) {
            input.addAttribute("name", ci.getName() + namePostFix);
            input.addAttribute("maxLength", size);
        } else {
            input.addAttribute("disabled");
        }
        input.addAttribute("value", part);
        input.addAttribute("onclick", ci.getOnclick());
        input.addAttribute("onchange", ci.getOnchange());
        input.addAttribute("onfocus", ci.getOnfocus());
        input.addAttribute("onblur", ci.getOnblur());
        input.endTag();
    }

    private String GetLKZ(String phone) {
        if (phone == null) {
            return "";
        }
        int idx = phone.indexOf(45);
        if (idx < 0) {
            return "";
        }
        int end = phone.indexOf(45, idx + 1);
        if (end < 0) {
            return "";
        }
        return idx > 0 ? phone.substring(0, idx) : "";
    }

    private String GetOKZ(String phone) {
        if (phone == null) {
            return "";
        }
        int idx = phone.indexOf(45);
        if (idx < 0) {
            return "";
        }
        int end = phone.indexOf(45, idx + 1);
        if (end < 0) {
            return phone.substring(0, idx);
        }
        return phone.substring(idx + 1, end);
    }

    private String GetTNR(String phone) {
        if (phone == null) {
            return "";
        }
        int idx = phone.indexOf(45);
        if (idx < 0) {
            return phone;
        }
        int end = phone.indexOf(45, idx + 1);
        if (end < 0) {
            return phone.substring(idx + 1);
        }
        return phone.substring(end + 1);
    }

    private String getPhone(String lkz, String okz, String tkn) {
        String phone;
        StringBuffer buf = new StringBuffer();
        if (lkz != null && lkz.length() > 0) {
            if ((lkz = lkz.trim()).indexOf(45) >= 0) {
                lkz = lkz.replace('-', '$');
            }
            if (lkz.startsWith("00")) {
                buf.append("+");
                buf.append(lkz.substring(2));
            } else {
                if (!lkz.startsWith("+")) {
                    buf.append("+");
                }
                buf.append(lkz);
            }
        }
        buf.append("-");
        if (okz != null && okz.length() > 0) {
            if ((okz = okz.trim()).indexOf(45) >= 0) {
                okz = okz.replace('-', '$');
            }
            buf.append(okz);
        }
        buf.append("-");
        if (tkn != null && tkn.length() > 0) {
            tkn = tkn.trim();
            buf.append(tkn);
        }
        if ((phone = buf.toString()).equals("--")) {
            return "";
        }
        return phone;
    }
}

