/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.controls;

import java.util.Locale;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.Column;
import org.apache.empire.struts2.action.RequestParamProvider;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.controls.InputControl;

public class CheckboxInputControl
extends InputControl {
    private static String CHECK_POSTFIX = "__CBCHECK";

    public Object getFieldValue(String name, RequestParamProvider request, Locale locale, Column column) {
        String val = request.getRequestParam(name);
        if (val != null) {
            return Boolean.TRUE;
        }
        if (request.getRequestParam(name + CHECK_POSTFIX) == null) {
            return NO_VALUE;
        }
        return Boolean.FALSE;
    }

    public void renderText(HtmlWriter writer, InputControl.ValueInfo vi) {
        HtmlWriter.HtmlTag input = writer.startTag("input");
        input.addAttribute("type", "checkbox");
        input.addAttribute("id", vi.getId());
        input.addAttribute("class", vi.getCssClass());
        input.addAttribute("style", vi.getCssStyle());
        input.addAttribute("disabled");
        if (ObjectUtils.getBoolean((Object)vi.getValue())) {
            input.addAttribute("checked");
        }
        input.endTag();
    }

    public void renderInput(HtmlWriter writer, InputControl.ControlInfo ci) {
        if (ci.getDisabled()) {
            this.renderText(writer, ci);
            return;
        }
        HtmlWriter.HtmlTag input = writer.startTag("input");
        input.addAttribute("type", "checkbox");
        input.addAttribute("id", ci.getId());
        input.addAttribute("class", ci.getCssClass());
        input.addAttribute("style", ci.getCssStyle());
        input.addAttribute("name", ci.getName());
        if (ObjectUtils.getBoolean((Object)ci.getValue())) {
            input.addAttribute("checked");
        }
        input.addAttribute("onclick", ci.getOnclick());
        input.addAttribute("onchange", ci.getOnchange());
        input.addAttribute("onfocus", ci.getOnfocus());
        input.addAttribute("onblur", ci.getOnblur());
        input.endTag();
        HtmlWriter.HtmlTag hidden = writer.startTag("input");
        hidden.addAttribute("type", "hidden");
        hidden.addAttribute("name", ci.getName() + CHECK_POSTFIX);
        hidden.addAttribute("value", ci.getValue());
        hidden.endTag();
    }
}

