/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.components;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.controls.InputControl;
import org.apache.struts2.components.UIBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ControlComponent
extends UIBean
implements InputControl.ValueInfo {
    protected static Logger log = LoggerFactory.getLogger(ControlComponent.class);
    protected Column column;
    protected Options options;
    protected Object recordValue;
    protected Object nullValue;
    protected String bodyUsage;
    protected String format;
    private InputControl control;
    private TextProvider textProvider;

    protected ControlComponent(InputControl control, ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack, req, res);
        this.control = control;
    }

    protected String getDefaultTemplate() {
        return null;
    }

    public boolean start(Writer writer) {
        return super.start(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean end(Writer writer, String body) {
        try {
            if (this.recordValue == ObjectUtils.NO_VALUE) {
                boolean bl = false;
                return bl;
            }
            HtmlWriter hw = new HtmlWriter(writer);
            this.render(hw, body, this.control);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error("error when rendering", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.popComponentStack();
        }
    }

    protected Object getAction() {
        try {
            return ActionContext.getContext().getActionInvocation().getAction();
        }
        catch (Exception e) {
            log.error("Unable to detect Action. Action Invocation not available!");
            return "";
        }
    }

    private TextProvider getTextProvider(Object action) {
        if (action instanceof TextProvider) {
            return (TextProvider)action;
        }
        return null;
    }

    public Locale getUserLocale() {
        Object action = this.getAction();
        if (action instanceof LocaleProvider) {
            return ((LocaleProvider)action).getLocale();
        }
        return ActionContext.getContext().getLocale();
    }

    public final String getTranslation(String text) {
        String result;
        if (text == null || text.length() == 0 || !text.startsWith("!")) {
            return text;
        }
        String key = text.substring(1);
        if (key.startsWith("!")) {
            return key;
        }
        if (this.textProvider == null) {
            this.textProvider = this.getTextProvider(this.getAction());
            if (this.textProvider == null) {
                log.error("No Text Provider available for control component");
                return "[" + key + "]";
            }
        }
        if ((result = this.textProvider.getText(key)) == null) {
            log.error("No translation found for key=" + key);
            return "[" + key + "]";
        }
        return result;
    }

    protected abstract void render(HtmlWriter var1, String var2, InputControl var3);

    public boolean usesBody() {
        return StringUtils.isNotEmpty((String)this.bodyUsage);
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setRecordValue(Object recordValue) {
        this.recordValue = recordValue;
    }

    public void setBodyUsage(String bodyUsage) {
        this.bodyUsage = bodyUsage;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getId() {
        return this.id;
    }

    public final Column getColumn() {
        return this.column;
    }

    public final Options getOptions() {
        return this.options;
    }

    public final Object getValue() {
        return this.recordValue;
    }

    public final Object getNullValue() {
        return this.nullValue;
    }

    public final String getCssClass() {
        return this.cssClass;
    }

    public final String getCssStyle() {
        return this.cssStyle;
    }

    public final String getOnclick() {
        return this.onclick;
    }

    public final String getOndblclick() {
        return this.ondblclick;
    }

    public final String getFormat() {
        return this.format;
    }

    public void setNullValue(Object nullValue) {
        this.nullValue = nullValue;
    }
}

