/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.interceptors;

import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.io.IOException;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.portlet.servlet.PortletServletRequest;
import org.apache.struts2.portlet.servlet.PortletServletResponse;
import org.apache.struts2.views.util.UrlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InterceptorSupport
extends AbstractInterceptor {
    protected static Logger log = LoggerFactory.getLogger(InterceptorSupport.class);
    public static final String NONE = "none";

    protected String redirect(String target, boolean appendSourceUri) throws IOException {
        HttpServletRequest req = ServletActionContext.getRequest();
        if (req instanceof PortletServletRequest) {
            return this.redirectPortletRequest(((PortletServletRequest)req).getPortletRequest(), target, appendSourceUri);
        }
        return this.redirectServletRequest(req, target, appendSourceUri);
    }

    private String redirectServletRequest(HttpServletRequest req, String target, boolean appendSourceUri) throws IOException {
        StringBuffer url = new StringBuffer();
        if (target.indexOf(47) < 0) {
            url.append(req.getContextPath());
            url.append('/');
        }
        url.append(target);
        if (target.indexOf(63) < 0 && target.indexOf(46) < 0) {
            url.append(".action");
        }
        if (appendSourceUri) {
            url.append(target.indexOf(63) < 0 ? (char)'?' : '&');
            url.append("source-uri=");
            url.append(UrlHelper.translateAndEncode((String)req.getRequestURI()));
        }
        if (log.isInfoEnabled()) {
            log.info("Redirecting request from " + req.getRequestURI() + " to " + url.toString());
        }
        HttpServletResponse response = ServletActionContext.getResponse();
        String redirectURL = response.encodeRedirectURL(url.toString());
        response.sendRedirect(redirectURL);
        return NONE;
    }

    private String redirectPortletRequest(PortletRequest req, String target, boolean appendSourceUri) throws IOException {
        HttpServletResponse servletResponse;
        PortletResponse portletResponse;
        StringBuffer url = new StringBuffer();
        if (target.indexOf(47) < 0) {
            url.append(req.getContextPath());
            url.append('/');
        }
        url.append(target);
        if (target.indexOf(63) < 0 && target.indexOf(46) < 0) {
            url.append(".action");
        }
        if ((portletResponse = ((PortletServletResponse)(servletResponse = ServletActionContext.getResponse())).getPortletResponse()) instanceof ActionResponse) {
            ActionResponse actionResponse = (ActionResponse)portletResponse;
            String redirectURL = actionResponse.encodeURL(url.toString());
            actionResponse.sendRedirect(redirectURL);
        } else {
            log.error("Unable to redirect the portlet RenderRequest to " + url.toString());
        }
        return NONE;
    }
}

