/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.html;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.xwork.StringEscapeUtils;
import org.apache.empire.commons.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlWriter {
    protected static Logger log = LoggerFactory.getLogger(HtmlWriter.class);
    private Writer writer;

    public HtmlWriter(Writer writer) {
        this.writer = writer;
    }

    private void print(String text, boolean endOfLine) {
        try {
            if (text == null) {
                log.warn("cannot print text value of null!");
                return;
            }
            this.writer.write(text);
            if (endOfLine) {
                this.writer.write("\n");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void print(String text) {
        this.print(text, false);
    }

    public void println(String text) {
        this.print(text, true);
    }

    public void println() {
        this.print("", true);
    }

    public HtmlTag startTag(String name) {
        HtmlTag tag = new HtmlTag(this, name, false);
        tag.startTag();
        return tag;
    }

    public HtmlTag continueTag(String name, boolean hasBody) {
        return new HtmlTag(this, name, hasBody);
    }

    public static class HtmlTag {
        private HtmlWriter w;
        private String name;
        private boolean hasBody;

        protected HtmlTag(HtmlWriter writer, String name, boolean hasBody) {
            this.w = writer;
            this.name = name;
            this.hasBody = hasBody;
        }

        protected void startTag() {
            if (this.name != null) {
                this.w.print("<");
                this.w.print(this.name);
            }
        }

        public boolean isValid() {
            return this.w != null && this.name != null;
        }

        public void addAttributes(String attributes) {
            if (this.name == null || attributes == null) {
                return;
            }
            this.w.print(" ");
            this.w.print(attributes);
        }

        public void addAttributeNoCheck(String attrib, Object value, boolean escapeHtml) {
            if (this.name == null) {
                return;
            }
            String strValue = StringUtils.valueOf((Object)value);
            if (escapeHtml) {
                strValue = StringEscapeUtils.escapeHtml((String)strValue);
            }
            this.w.print(" ");
            this.w.print(attrib);
            this.w.print("=\"");
            this.w.print(strValue);
            this.w.print("\"");
        }

        public void addAttribute(String attrib, Object value, boolean escapeHtml) {
            if (this.name == null || value == null) {
                return;
            }
            String strValue = value.toString();
            if (strValue == null || strValue.length() == 0) {
                return;
            }
            if (escapeHtml) {
                strValue = StringEscapeUtils.escapeHtml((String)strValue);
            }
            this.w.print(" ");
            this.w.print(attrib);
            this.w.print("=\"");
            this.w.print(strValue);
            this.w.print("\"");
        }

        public void addAttribute(String attrib, Object value) {
            this.addAttribute(attrib, value, false);
        }

        public void addAttribute(String attrib) {
            this.addAttribute(attrib, attrib, false);
        }

        public void addAttribute(String attrib, boolean present) {
            if (present) {
                this.addAttribute(attrib, attrib, false);
            }
        }

        public void beginBody(String body, boolean newLine) {
            if (this.name != null) {
                this.w.print(">", newLine);
            }
            if (body != null) {
                this.w.print(body);
            }
            this.hasBody = true;
        }

        public void beginBody(String body) {
            this.beginBody(body, false);
        }

        public void beginBody(boolean newLine) {
            this.beginBody(null, newLine);
        }

        public void beginBody() {
            this.beginBody(null, false);
        }

        public void endTag(String body, boolean newLine) {
            if (body != null && body.length() > 0) {
                if (!this.hasBody) {
                    this.beginBody(body, false);
                } else {
                    this.w.print(body);
                }
            }
            if (this.name != null) {
                if (this.hasBody) {
                    this.w.print("</");
                    this.w.print(this.name);
                    this.w.print(">", newLine);
                } else {
                    this.w.print(" />", newLine);
                }
            }
            this.w = null;
        }

        public void endTag(String body) {
            this.endTag(body, false);
        }

        public void endTag(boolean newLine) {
            this.endTag(null, newLine);
        }

        public void endTag() {
            this.endTag(null, false);
        }
    }
}

