/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.actionsupport;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.struts2.action.ErrorInfo;
import org.apache.empire.struts2.actionsupport.ActionBase;
import org.apache.empire.struts2.actionsupport.ActionError;
import org.apache.empire.struts2.actionsupport.FormActionSupport;
import org.apache.empire.struts2.actionsupport.SessionPersistence;
import org.apache.empire.struts2.jsp.controls.InputControl;
import org.apache.empire.struts2.jsp.controls.InputControlManager;
import org.apache.empire.struts2.web.FieldErrors;

public abstract class RecordFormActionSupport
extends FormActionSupport {
    protected SessionPersistence persistence;

    protected RecordFormActionSupport(ActionBase action, SessionPersistence persistence) {
        this(action, persistence, action.getItemPropertyName());
    }

    protected RecordFormActionSupport(ActionBase action, SessionPersistence persistence, String propertyName) {
        super(action, propertyName);
        this.persistence = persistence;
    }

    public SessionPersistence getPersistence() {
        return this.persistence;
    }

    public abstract Record getRecord();

    public String getRecordKeyString() {
        Record record = this.getRecord();
        if (record == null || !record.isValid()) {
            String property = this.getRecordPropertyName();
            String key = this.getActionParam(property, this.persistence == SessionPersistence.Key);
            if (key != null || this.persistence != SessionPersistence.Data) {
                return key;
            }
            record = this.getRecordFromSession();
            if (record == null) {
                return null;
            }
        }
        return this.action.getRecordKeyString(record);
    }

    public boolean isNewRecord() {
        Record record = this.getRecord();
        if (record == null || !record.isValid()) {
            String property = this.getRecordPropertyName();
            String key = this.getActionParam(property, this.persistence == SessionPersistence.Key);
            if (key != null) {
                return this.action.getRecordNewFlagFromString(key);
            }
            if (this.persistence != SessionPersistence.Data) {
                return false;
            }
            record = this.getRecordFromSession();
            if (record == null) {
                return false;
            }
        }
        return record.isNew();
    }

    public String getRequestFieldName(Column column) {
        String name = column.getName();
        if (this.propertyName != null && this.propertyName.length() > 0) {
            return this.propertyName + "." + name;
        }
        return name;
    }

    protected Record getRecordFromSession() {
        if (this.persistence != SessionPersistence.Data) {
            return null;
        }
        Object rec = this.action.getActionObject(this.getRecordPropertyName() + ".data");
        if (rec == null || !(rec instanceof Record)) {
            return null;
        }
        return (Record)rec;
    }

    protected void persistOnSession() {
        if (this.persistence == SessionPersistence.Key) {
            String key = this.action.getRecordKeyString(this.getRecord());
            this.action.putActionObject(this.getRecordPropertyName(), key);
        } else if (this.persistence == SessionPersistence.Data) {
            this.action.putActionObject(this.getRecordPropertyName() + ".data", this.getRecord());
        }
    }

    protected void removeFromSession() {
        if (this.persistence == SessionPersistence.Key) {
            this.action.removeActionObject(this.getRecordPropertyName());
        } else if (this.persistence == SessionPersistence.Data) {
            this.action.removeActionObject(this.getRecordPropertyName() + ".data");
        }
    }

    public boolean hasActionKey(boolean acceptSessionKey) {
        String property = this.getRecordPropertyName();
        String param = this.getActionParam(property, acceptSessionKey && this.persistence == SessionPersistence.Key);
        return param != null;
    }

    public Object[] getActionParamKey() {
        String property = this.getRecordPropertyName();
        String param = this.getActionParam(property, this.persistence == SessionPersistence.Key);
        return this.action.getRecordKeyFromString(param);
    }

    public boolean getActionParamNewFlag() {
        String property = this.getRecordPropertyName();
        return this.action.getRecordNewFlagFromString(this.getActionParam(property, false));
    }

    public boolean loadFormData() {
        try {
            Record record = this.getRecord();
            if (!record.isValid()) {
                throw new ObjectNotValidException((Object)record);
            }
            return this.setUpdateFields(record);
        }
        catch (Exception e) {
            this.action.setActionError(e);
            return false;
        }
    }

    protected boolean setRecordFieldValue(int i, Object value, boolean verify) {
        if (ObjectUtils.isEmpty((Object)value)) {
            value = null;
        }
        try {
            this.getRecord().setValue(i, value);
            return true;
        }
        catch (EmpireException e) {
            log.info("setRecordFieldValue failed. Message is {}.", (Object)e.getMessage());
            return false;
        }
    }

    protected boolean setUpdateFields(Record record) {
        boolean valid = true;
        Locale locale = this.action.getLocale();
        String sysdate = DBDatabase.SYSDATE.toString();
        Object[] keyColumns = record.getKeyColumns();
        int fieldCount = record.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            Column col = record.getColumn(i);
            if (ObjectUtils.contains((Object[])keyColumns, (Object)col)) continue;
            Object value = null;
            String field = this.getRequestFieldName(col);
            InputControl control = null;
            if (!record.isFieldReadOnly(col)) {
                control = InputControlManager.getControl(col.getControlType());
            }
            if (control != null && (value = control.getFieldValue(field, this.action, locale, col)) != null) {
                InputControl.FieldValueError fieldError;
                if (value instanceof InputControl.FieldValueError) {
                    fieldError = (InputControl.FieldValueError)value;
                    String errorValue = fieldError.getValue();
                    this.addFieldError(field, col, fieldError, errorValue);
                    this.setRecordFieldValue(i, errorValue, false);
                    valid = false;
                    continue;
                }
                if (value.equals(InputControl.NULL_VALUE) && col.isRequired()) {
                    fieldError = new InputControl.FieldValueError(FieldErrors.InputValueRequired, null, "");
                    this.addFieldError(field, col, fieldError, value);
                    valid = false;
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info("SetUpdateFields: setting field '" + col.getName() + "' to " + String.valueOf(value));
                }
                if (this.setRecordFieldValue(i, value, true)) continue;
                if (record instanceof ErrorInfo) {
                    this.addFieldError(field, col, (ErrorInfo)record, value);
                } else {
                    this.addFieldError(field, col, new ActionError(FieldErrors.InputInvalidValue), value);
                }
                this.setRecordFieldValue(i, value, false);
                valid = false;
                continue;
            }
            value = this.action.getRequestParam(field + "!");
            if (value == null) continue;
            if (!(col.getDataType() != DataType.DATE && col.getDataType() != DataType.DATETIME || value.equals(sysdate))) {
                String format = col.getDataType() == DataType.DATE ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss.S";
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                try {
                    value = sdf.parseObject(value.toString());
                }
                catch (ParseException e) {
                    log.error("Failed to parse date for record", (Throwable)e);
                    continue;
                }
            }
            if (log.isInfoEnabled()) {
                log.info("SetUpdateFields: directly setting field '" + col.getName() + "' to " + String.valueOf(value));
            }
            if (ObjectUtils.compareEqual((Object)record.getValue(i), (Object)value)) continue;
            this.setRecordFieldValue(i, value, false);
        }
        if (!valid) {
            if (log.isInfoEnabled()) {
                log.info("SetUpdateFields: Failed to modify record! At least one field error!");
            }
            return false;
        }
        return true;
    }

    protected final boolean compareKey(Object[] currentKey, Object[] updateKey) {
        if (currentKey == null || currentKey.length != updateKey.length) {
            return false;
        }
        for (int i = 0; i < currentKey.length; ++i) {
            if (ObjectUtils.compareEqual((Object)currentKey[i], (Object)updateKey[i])) continue;
            return false;
        }
        return true;
    }
}

