/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.actionsupport;

import java.util.ArrayList;
import java.util.List;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBReader;
import org.apache.empire.struts2.actionsupport.ActionBase;
import org.apache.empire.struts2.actionsupport.ListActionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanListActionSupport<T>
extends ListActionSupport {
    protected ArrayList<T> list = null;
    protected Class<T> beanClass;

    public BeanListActionSupport(ActionBase action, Class<T> beanClass, String propertyName) {
        super(action, propertyName);
        this.beanClass = beanClass;
    }

    public ArrayList<T> getList() {
        if (this.list == null) {
            log.warn("Bean List has not been initialized!");
        }
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initBeanList(DBCommand cmd) {
        DBReader reader = new DBReader();
        try {
            reader.open((DBCommandExpr)cmd, this.action.getConnection());
            int first = this.getFirstItemIndex();
            if (first > 0 && !reader.skipRows(first)) {
                reader.close();
                this.setFirstItem(0);
                this.initBeanList(cmd);
            }
            this.list = reader.getBeanList(this.beanClass, this.getPageSize());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.action.setActionError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            reader.close();
        }
    }

    public void setList(List<T> list) {
        this.list = new ArrayList<T>(list);
    }
}

