/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.maven;

import java.io.File;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.codegen.CodeGenConfig;
import org.apache.empire.db.codegen.CodeGenParser;
import org.apache.empire.db.codegen.CodeGenWriter;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class CodeGenMojo
extends AbstractMojo {
    private MavenProject project;
    private File configFile;
    private File targetDirectory;
    private String jdbcURL;
    private String jdbcClass;
    private String jdbcUser;
    private String jdbcPwd;
    private String templateDirectory;
    private String packageName;

    public void execute() throws MojoExecutionException {
        this.setupLogging();
        CodeGenConfig config = new CodeGenConfig();
        if (this.configFile != null) {
            this.getLog().info((CharSequence)("Loading configuration file: " + this.configFile));
            config.init(this.configFile.getAbsolutePath());
        } else {
            config.setJdbcURL(this.jdbcURL);
            config.setJdbcClass(this.jdbcClass);
            config.setJdbcUser(this.jdbcUser);
            config.setJdbcPwd(this.jdbcPwd);
            config.setTargetFolder(this.targetDirectory.getAbsolutePath());
            config.setTemplateFolder(this.templateDirectory);
            config.setPackageName(this.packageName);
        }
        this.getLog().info((CharSequence)("Generating code for " + this.jdbcURL + " ..."));
        CodeGenParser parser = new CodeGenParser(config);
        DBDatabase db = parser.loadDbModel();
        CodeGenWriter codeGen = new CodeGenWriter(config);
        codeGen.generateCodeFiles(db);
        this.getLog().info((CharSequence)("Code successfully generated in: " + this.targetDirectory));
        if (this.project != null && this.targetDirectory != null && this.targetDirectory.exists()) {
            this.project.addCompileSourceRoot(this.targetDirectory.getAbsolutePath());
        }
    }

    private void setupLogging() {
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)new MavenAppender(this));
    }

    private static final class MavenAppender
    extends AppenderSkeleton {
        private final AbstractMojo mojo;

        public MavenAppender(AbstractMojo mojo) {
            this.mojo = mojo;
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        protected void append(LoggingEvent event) {
            if (Level.INFO.equals((Object)event.getLevel())) {
                this.mojo.getLog().info((CharSequence)String.valueOf(event.getMessage()));
            } else if (Level.ERROR.equals((Object)event.getLevel())) {
                this.mojo.getLog().error((CharSequence)String.valueOf(event.getMessage()));
            } else if (Level.WARN.equals((Object)event.getLevel())) {
                this.mojo.getLog().warn((CharSequence)String.valueOf(event.getMessage()));
            }
        }
    }
}

