/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.empire.commons.DateUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.utils.ParameterObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterMap {
    private static final Logger log = LoggerFactory.getLogger(ParameterMap.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss", Locale.GERMAN);
    private static MessageDigest md5 = null;
    private final byte[] salt;
    protected Hashtable<String, String> codeMap;
    protected final Hashtable<String, Hashtable<String, Object>> typeMap;

    public ParameterMap() {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("MessageDigest NoSuchAlgorithmException.", (Throwable)e);
            throw new InternalException((Throwable)e);
        }
        this.codeMap = new Hashtable();
        this.typeMap = new Hashtable();
        String dateTime = dateFormat.format(DateUtils.getTimeNow());
        this.salt = dateTime.getBytes();
    }

    public synchronized String encodeString(String valueAsString) {
        if (valueAsString == null) {
            throw new InvalidArgumentException("valueAsString", (Object)valueAsString);
        }
        if (log.isTraceEnabled()) {
            log.trace("Generating code for value {}.", (Object)valueAsString);
        }
        md5.reset();
        if (this.salt != null) {
            md5.update(this.salt);
        }
        md5.update(valueAsString.getBytes());
        byte[] s = md5.digest();
        StringBuilder hash = new StringBuilder(32);
        block4: for (int i = 0; i < s.length; ++i) {
            String part = Integer.toHexString(0xFF & s[i]);
            switch (part.length()) {
                case 1: {
                    hash.append('0');
                }
                case 2: {
                    hash.append(part);
                    continue block4;
                }
                default: {
                    throw new UnexpectedReturnValueException((Object)part, "Integer.toHexString");
                }
            }
        }
        return hash.toString();
    }

    public String encodeStringWithCache(String valueAsString) {
        String code = this.codeMap.get(valueAsString);
        if (code == null) {
            code = this.encodeString(valueAsString);
            this.codeMap.put(valueAsString, code);
        }
        return code;
    }

    protected String getRowSetTypeName(DBRowSet rowset) {
        return rowset.getClass().getName();
    }

    protected void putValue(String typeName, String encodedId, Object item) {
        if (encodedId == null) {
            throw new InvalidArgumentException("encodedId", (Object)encodedId);
        }
        Hashtable<String, Object> map = this.typeMap.get(typeName);
        if (map == null) {
            map = new Hashtable(1);
            this.typeMap.put(typeName, map);
        }
        map.put(encodedId, item);
    }

    protected String encodeAndStore(String typeName, String objectKey, Object item, boolean useCache) {
        String encodedId = useCache ? this.encodeStringWithCache(objectKey) : this.encodeString(objectKey);
        this.putValue(typeName, encodedId, item);
        return encodedId;
    }

    public String put(String type, String key, boolean useCache) {
        return this.encodeAndStore(type, key, key, useCache);
    }

    public String put(ParameterObject paramObject) {
        String objectKey;
        if (paramObject == null || StringUtils.isEmpty((String)(objectKey = paramObject.getObjectKey()))) {
            throw new InvalidArgumentException("paramObject", (Object)paramObject);
        }
        String type = paramObject.getClass().getName();
        return this.encodeAndStore(type, objectKey, paramObject, false);
    }

    public String put(DBRowSet rowset, Object[] key) {
        String rowKey = StringUtils.valueOf((Object[])key);
        String type = this.getRowSetTypeName(rowset);
        return this.encodeAndStore(type, rowKey, key, false);
    }

    public String put(PageDefinition targetPage, DBRowSet rowset, Object[] key) {
        String ref = StringUtils.valueOf((Object[])key);
        String type = targetPage.getPageBeanName() + "$" + this.getRowSetTypeName(rowset);
        return this.encodeAndStore(type, ref, key, false);
    }

    public Object get(String type, String id) {
        Hashtable<String, Object> map = this.typeMap.get(type);
        return map != null ? map.get(id) : null;
    }

    public void clear(String type) {
        Hashtable<String, Object> map = this.typeMap.get(type);
        if (map != null) {
            map.clear();
        }
    }

    public <T extends ParameterObject> T get(Class<T> paramType, String id) {
        String type = paramType.getName();
        Hashtable<String, Object> map = this.typeMap.get(type);
        return (T)((ParameterObject)(map != null ? map.get(id) : null));
    }

    public void clear(Class<? extends ParameterObject> paramType) {
        String type = paramType.getName();
        this.clear(type);
    }

    public Object[] getKey(DBRowSet rowset, String id) {
        String type = this.getRowSetTypeName(rowset);
        Hashtable<String, Object> map = this.typeMap.get(type);
        return map != null ? (Object[])map.get(id) : null;
    }

    public void clear(DBRowSet rowset) {
        String type = this.getRowSetTypeName(rowset);
        this.clear(type);
    }

    public Object[] getKey(PageDefinition page, DBRowSet rowset, String id) {
        String type = page.getPageBeanName() + "$" + this.getRowSetTypeName(rowset);
        Hashtable<String, Object> map = this.typeMap.get(type);
        return map != null ? (Object[])map.get(id) : null;
    }
}

