/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueTag
extends UIOutput {
    private static final Logger log = LoggerFactory.getLogger(ValueTag.class);
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create(this, TagStyleClass.VALUE.get());

    public ValueTag() {
        log.trace("component value created");
    }

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    public String getId() {
        String compId = super.getId();
        if ("null".equals(compId)) {
            compId = this.helper.completeInputTagId(null);
        }
        return compId;
    }

    public void setId(String id) {
        id = this.helper.completeInputTagId(id);
        super.setId(id);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.helper.encodeBegin();
        InputControl control = this.helper.getInputControl();
        InputControl.ValueInfo vi = this.helper.getValueInfo(context);
        String wrapperTag = this.helper.writeWrapperTag(context, true, true);
        this.renderControlValue(control, vi, context);
        if (wrapperTag != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.endElement(wrapperTag);
        }
    }

    protected void renderControlValue(InputControl control, InputControl.ValueInfo vi, FacesContext context) throws IOException {
        String tagName = this.helper.getTagAttributeString("tag");
        String tooltip = this.helper.getValueTooltip(this.helper.getTagAttributeValue("title"));
        String styleClass = this.helper.getTagAttributeString("styleClass");
        if (StringUtils.isNotEmpty((String)tagName) || StringUtils.isNotEmpty((String)styleClass) || StringUtils.isNotEmpty((String)tooltip)) {
            if (StringUtils.isEmpty((String)tagName)) {
                tagName = "span";
            }
            String addlStyle = null;
            DataType dataType = vi.getColumn().getDataType();
            styleClass = this.helper.getTagStyleClass(dataType, addlStyle);
        }
        control.renderValue((UIComponent)this, tagName, styleClass, tooltip, vi, context);
    }
}

