/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.impl.FacesImplementation;
import org.apache.empire.jsf2.impl.ResourceTextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebApplication {
    private static final Logger log = LoggerFactory.getLogger(WebApplication.class);
    private static final String CONNECTION_ATTRIBUTE = "dbConnections";
    public static String APPLICATION_BEAN_NAME = "webApplication";
    protected TextResolver[] textResolvers = null;
    private String webRoot = null;
    private FacesImplementation facesImpl = null;
    private static WebApplication appInstance = null;

    public static WebApplication getInstance() {
        if (appInstance == null) {
            log.warn("No WebApplication instance available. Please add a PostConstructApplicationEvent using WebAppStartupListener in your faces-config.xml to create the WebApplication object.");
        }
        return appInstance;
    }

    protected abstract void init(ServletContext var1);

    protected abstract DataSource getAppDataSource(DBDatabase var1);

    protected WebApplication() {
        log.info("WebApplication {} created", (Object)this.getClass().getName());
        if (appInstance != null) {
            throw new RuntimeException("An attempt was made to create second instance of WebApplication. WebApplication must be a singleton!");
        }
        appInstance = this;
    }

    public final void init(FacesImplementation facesImpl, FacesContext startupContext) {
        if (this.facesImpl != null || this.webRoot != null) {
            log.warn("WARNING: WebApplication has already been initialized! Continuing without init...");
            return;
        }
        this.facesImpl = facesImpl;
        ServletContext servletContext = (ServletContext)startupContext.getExternalContext().getContext();
        this.webRoot = servletContext.getContextPath();
        servletContext.setAttribute("webRoot", (Object)this.webRoot);
        servletContext.setAttribute("app", (Object)this);
        this.init(servletContext);
        log.info("*** initTextResolvers() ***");
        ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application app = appFactory.getApplication();
        this.initTextResolvers(app);
        log.info("*** WebApplication initialization complete ***");
        log.info("JSF-Implementation is '{}'", (Object)facesImpl.getClass().getName());
        log.info("WebRoot is '{}'", (Object)this.webRoot);
    }

    public void destroy() {
    }

    public void onRequestComplete(FacesContext ctx) {
        this.releaseAllConnections(ctx);
    }

    public void onViewNotFound(FacesContext fc, HttpServletRequest req) {
        log.warn("No view found for request to '{}'. Use FacesUtils.redirectDirectly() to redirect to valid view.", (Object)req.getRequestURI());
    }

    public void onChangeView(FacesContext fc, String viewId) {
        Map<String, Object> sm = FacesUtils.getSessionMap(fc);
        if (sm != null) {
            sm.remove("pageResources");
        }
    }

    public void addJavascriptCall(FacesContext fc, String function) {
        throw new NotSupportedException((Object)this, "addJavascriptCall");
    }

    public FacesImplementation getFacesImplementation() {
        return this.facesImpl;
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public Locale getContextLocale(FacesContext ctx) {
        Locale defaultLocale;
        Locale locale = defaultLocale = Locale.getDefault();
        UIViewRoot root = ctx.getViewRoot();
        if (null != root && null == (locale = root.getLocale())) {
            locale = defaultLocale;
        }
        return locale;
    }

    public TextResolver getTextResolver(Locale locale) {
        if (this.textResolvers == null || this.textResolvers.length == 0) {
            throw new NotSupportedException((Object)this, "getTextResolver");
        }
        for (int i = 0; i < this.textResolvers.length; ++i) {
            if (!locale.equals(this.textResolvers[i].getLocale())) continue;
            return this.textResolvers[i];
        }
        return this.textResolvers[0];
    }

    public TextResolver getTextResolver(FacesContext ctx) {
        return this.getTextResolver(this.getContextLocale(ctx));
    }

    public boolean hasError(FacesContext fc) {
        Iterator msgIterator = fc.getMessages();
        if (msgIterator != null) {
            while (msgIterator.hasNext()) {
                FacesMessage.Severity fms = ((FacesMessage)msgIterator.next()).getSeverity();
                if (fms != FacesMessage.SEVERITY_ERROR && fms != FacesMessage.SEVERITY_FATAL) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPartialSubmit(FacesContext fc) {
        return false;
    }

    public String getPartialSubmitComponentId(FacesContext fc) {
        return null;
    }

    public UIComponent findComponent(FacesContext fc, String componentId, UIComponent nearComponent) {
        if (StringUtils.isEmpty((String)componentId)) {
            throw new InvalidArgumentException("componentId", (Object)componentId);
        }
        UIComponent component = null;
        if (nearComponent != null && (component = nearComponent.findComponent(componentId)) == null) {
            UIComponent nextParent = nearComponent;
            do {
                for (nextParent = nextParent.getParent(); nextParent != null && !(nextParent instanceof NamingContainer); nextParent = nextParent.getParent()) {
                }
            } while (nextParent != null && (component = nextParent.findComponent(componentId)) == null);
        }
        if (component == null) {
            component = WebApplication.findChildComponent((UIComponent)fc.getViewRoot(), componentId);
        }
        return component;
    }

    public static UIComponent findChildComponent(UIComponent parent, String componentId) {
        UIComponent component = null;
        if (parent.getChildCount() == 0) {
            return null;
        }
        for (UIComponent nextChild : parent.getChildren()) {
            if (nextChild instanceof NamingContainer) {
                component = nextChild.findComponent(componentId);
            }
            if (component == null) {
                component = WebApplication.findChildComponent(nextChild, componentId);
            }
            if (component == null) continue;
            break;
        }
        return component;
    }

    public String getDefaultControlType(DataType dataType) {
        switch (dataType) {
            case CLOB: {
                return "textarea";
            }
        }
        return "text";
    }

    protected void initTextResolvers(Application app) {
        int count = 0;
        Iterator locales = app.getSupportedLocales();
        count = 0;
        while (locales.hasNext()) {
            locales.next();
            ++count;
        }
        String messageBundle = app.getMessageBundle();
        this.textResolvers = new TextResolver[count];
        locales = app.getSupportedLocales();
        int i = 0;
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            this.textResolvers[i] = new ResourceTextResolver(ResourceBundle.getBundle(messageBundle, locale));
            log.info("added TextResolver for {} bundle='{}'", (Object)locale.getLanguage(), (Object)messageBundle);
            ++i;
        }
    }

    protected Connection getConnection(DBDatabase db) {
        try {
            Connection conn = this.getAppDataSource(db).getConnection();
            conn.setAutoCommit(false);
            return conn;
        }
        catch (SQLException e) {
            log.error("Failed to get connection from pool.", (Throwable)e);
            throw new InternalException((Throwable)e);
        }
    }

    protected void releaseConnection(DBDatabase db, Connection conn, boolean commit) {
        try {
            if (conn == null) {
                return;
            }
            if (commit) {
                db.commit(conn);
                log.debug("REQUEST commited.");
            } else {
                db.rollback(conn);
                log.debug("REQUEST rolled back.");
            }
            conn.close();
            if (log.isDebugEnabled()) {
                log.debug("REQUEST returned connection to pool.");
            }
        }
        catch (SQLException e) {
            log.error("Error releasing connection", (Throwable)e);
            e.printStackTrace();
        }
    }

    public Connection getConnectionForRequest(FacesContext fc, DBDatabase db) {
        if (fc == null) {
            throw new InvalidArgumentException("FacesContext", (Object)fc);
        }
        if (db == null) {
            throw new InvalidArgumentException("DBDatabase", (Object)db);
        }
        HashMap<DBDatabase, Connection> connMap = (HashMap<DBDatabase, Connection>)FacesUtils.getRequestAttribute(fc, CONNECTION_ATTRIBUTE);
        if (connMap != null && connMap.containsKey(db)) {
            return (Connection)connMap.get(db);
        }
        Connection conn = this.getConnection(db);
        if (conn == null) {
            return null;
        }
        if (connMap == null) {
            connMap = new HashMap<DBDatabase, Connection>();
            FacesUtils.setRequestAttribute(fc, CONNECTION_ATTRIBUTE, connMap);
        }
        connMap.put(db, conn);
        return conn;
    }

    public void releaseAllConnections(FacesContext fc, boolean commit) {
        Map connMap = (Map)FacesUtils.getRequestAttribute(fc, CONNECTION_ATTRIBUTE);
        if (connMap != null) {
            for (Map.Entry e : connMap.entrySet()) {
                this.releaseConnection((DBDatabase)e.getKey(), (Connection)e.getValue(), commit);
            }
            FacesUtils.setRequestAttribute(fc, CONNECTION_ATTRIBUTE, null);
        }
    }

    public void releaseAllConnections(FacesContext fc) {
        this.releaseAllConnections(fc, !this.hasError(fc));
    }

    public void releaseConnection(FacesContext fc, DBDatabase db, boolean commit) {
        Map connMap = (Map)FacesUtils.getRequestAttribute(fc, CONNECTION_ATTRIBUTE);
        if (connMap != null && connMap.containsKey(db)) {
            this.releaseConnection(db, (Connection)connMap.get(db), commit);
            connMap.remove(db);
            if (connMap.size() == 0) {
                FacesUtils.setRequestAttribute(fc, CONNECTION_ATTRIBUTE, null);
            }
        }
    }

    public void releaseConnection(FacesContext fc, DBDatabase db) {
        this.releaseConnection(fc, db, !this.hasError(fc));
    }
}

