/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.exceptions.EmpireException;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.app.WebApplication;
import org.apache.empire.jsf2.impl.FacesImplementation;
import org.apache.empire.jsf2.pages.Page;
import org.apache.empire.jsf2.pages.PageDefinition;
import org.apache.empire.jsf2.pages.PageOutcome;
import org.apache.empire.jsf2.utils.ParameterMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacesUtils {
    private static final Logger log = LoggerFactory.getLogger(FacesUtils.class);
    public static final String SKIP_INPUT_VALIDATION_PARAM = "empire.jsf.input.skipValidation";
    public static final String PARAMETER_MAP_ATTRIBUTE = "PARAMETER_MAP";
    public static final String PARAMETER_MAP_CLASS_ATTRIBUTE = "PARAMETER_MAP_CLASS";
    public static final String PAGE_RESOURCE_MAP_ATTRIBUTE = "pageResources";

    public static WebApplication getWebApplication() {
        return WebApplication.getInstance();
    }

    public static FacesImplementation getFacesImplementation() {
        return FacesUtils.getWebApplication().getFacesImplementation();
    }

    public static FacesContext getContext() {
        return FacesContext.getCurrentInstance();
    }

    public static Map<String, Object> getSessionMap(FacesContext fc) {
        return fc.getExternalContext().getSessionMap();
    }

    public static HttpServletRequest getHttpRequest(FacesContext fc) {
        return (HttpServletRequest)fc.getExternalContext().getRequest();
    }

    public static String getRequestUserAgent() {
        String agent = null;
        Object req = FacesContext.getCurrentInstance().getExternalContext().getRequest();
        if (req instanceof HttpServletRequest) {
            agent = ((HttpServletRequest)req).getHeader("user-agent");
        }
        return agent != null ? agent : "";
    }

    public static boolean isRequestUserAgentIE() {
        String userAgent = FacesUtils.getRequestUserAgent();
        return userAgent.indexOf("MSIE") >= 0;
    }

    public static String getRequestContextPath() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath();
    }

    public static Object getRequestAttribute(String key) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getRequestAttribute(fc, key);
    }

    public static Object getRequestAttribute(FacesContext fc, String key) {
        return FacesUtils.getHttpRequest(fc).getAttribute(key);
    }

    public static void setRequestAttribute(String key, Object value) {
        FacesContext fc = FacesUtils.getContext();
        FacesUtils.setRequestAttribute(fc, key, value);
    }

    public static void setRequestAttribute(FacesContext fc, String key, Object value) {
        if (value != null) {
            FacesUtils.getHttpRequest(fc).setAttribute(key, value);
        } else {
            FacesUtils.getHttpRequest(fc).removeAttribute(key);
        }
    }

    public static String getRequestParam(FacesContext context, String param) {
        return (String)context.getExternalContext().getRequestParameterMap().get(param);
    }

    public static String getRequestParam(String key) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getRequestParam(fc, key);
    }

    public static boolean isSkipInputValidation(FacesContext fc) {
        String val = FacesUtils.getRequestParam(fc, SKIP_INPUT_VALIDATION_PARAM);
        return val != null && ObjectUtils.getBoolean((Object)val);
    }

    public static boolean isSkipInputValidation() {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.isSkipInputValidation(fc);
    }

    public static void redirectDirectly(FacesContext fc, String url) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Redirecting directly to {}.", (Object)url);
            }
            if (fc.getResponseComplete()) {
                log.warn("Redirecting although response is already complete!");
            }
            fc.getExternalContext().redirect(url);
            fc.responseComplete();
        }
        catch (IOException e) {
            log.error("Unable to redirect to " + url);
        }
    }

    public static void redirectDirectly(FacesContext fc, PageOutcome outcome) {
        String ctxPath = fc.getExternalContext().getRequestContextPath();
        String pageURI = ctxPath + outcome.toString();
        FacesUtils.redirectDirectly(fc, pageURI);
    }

    public static void redirectDirectly(FacesContext fc, PageDefinition page) {
        FacesUtils.redirectDirectly(fc, page.getOutcome());
    }

    public Connection getConnection(FacesContext fc, DBDatabase db) {
        return FacesUtils.getWebApplication().getConnectionForRequest(fc, db);
    }

    public void releaseAllConnections(FacesContext fc, boolean commit) {
        FacesUtils.getWebApplication().releaseAllConnections(fc, commit);
    }

    public void releaseAllConnections(FacesContext fc, DBDatabase db, boolean commit) {
        FacesUtils.getWebApplication().releaseConnection(fc, db, commit);
    }

    public static Page getPage(FacesContext fc) {
        UIViewRoot vr = fc.getViewRoot();
        if (vr == null) {
            throw new ItemNotFoundException((Object)"ViewRoot");
        }
        Page page = (Page)vr.getViewMap().get("page");
        if (page == null) {
            throw new ItemNotFoundException((Object)"page");
        }
        return page;
    }

    public static void setParameterMapClass(FacesContext fc, Class<? extends ParameterMap> clazz) {
        Map am = fc.getExternalContext().getApplicationMap();
        am.put(PARAMETER_MAP_CLASS_ATTRIBUTE, clazz);
    }

    public static ParameterMap getParameterMap(FacesContext fc) {
        Map sm = fc.getExternalContext().getSessionMap();
        ParameterMap pm = (ParameterMap)sm.get(PARAMETER_MAP_ATTRIBUTE);
        if (pm == null) {
            try {
                Map am = fc.getExternalContext().getApplicationMap();
                Object pmClass = am.get(PARAMETER_MAP_CLASS_ATTRIBUTE);
                pm = pmClass instanceof Class ? (ParameterMap)((Class)pmClass).newInstance() : (pmClass instanceof String ? (ParameterMap)Class.forName((String)pmClass).newInstance() : new ParameterMap());
            }
            catch (ClassNotFoundException e) {
                throw new InternalException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new InternalException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new InternalException((Throwable)e);
            }
            sm.put(PARAMETER_MAP_ATTRIBUTE, pm);
        }
        return pm;
    }

    public static ParameterMap getParameterMap() {
        return FacesUtils.getParameterMap(FacesUtils.getContext());
    }

    public static Map<String, Object> getPageResourceMap(FacesContext fc) {
        Map sm = fc.getExternalContext().getSessionMap();
        HashMap rm = (HashMap)sm.get(PAGE_RESOURCE_MAP_ATTRIBUTE);
        if (rm == null) {
            rm = new HashMap();
            sm.put(PAGE_RESOURCE_MAP_ATTRIBUTE, rm);
        }
        return rm;
    }

    public static Map<String, Object> getPageResourceMap() {
        return FacesUtils.getPageResourceMap(FacesUtils.getContext());
    }

    public static Object getManagedBean(FacesContext fc, String name) {
        if (fc == null) {
            throw new NullPointerException("context must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        return FacesUtils.getWebApplication().getFacesImplementation().getManagedBean(name, fc);
    }

    public static <T> T getManagedBean(FacesContext fc, Class<T> cls, String name) {
        Object bean = FacesUtils.getManagedBean(fc, name);
        if (bean == null) {
            log.warn("Managed Bean {} ist not available.", (Object)name);
            throw new ItemNotFoundException((Object)name);
        }
        return (T)bean;
    }

    public static <T> T getManagedBean(FacesContext fc, Class<T> cls) {
        String name = cls.getName();
        int i = name.lastIndexOf(46) + 1;
        name = name.substring(i, i + 1).toLowerCase() + name.substring(i + 1);
        return FacesUtils.getManagedBean(fc, cls, name);
    }

    public static <T> T getManagedBean(Class<T> cls) {
        FacesContext fc = FacesUtils.getContext();
        return FacesUtils.getManagedBean(fc, cls);
    }

    public static String getRealPath(FacesContext fc, String path) {
        return ((ServletContext)fc.getExternalContext().getContext()).getRealPath(path);
    }

    public static String getFilePath(FacesContext fc, String path, String file) {
        String realPath = FacesUtils.getRealPath(fc, path);
        return realPath.endsWith(File.separator) ? realPath + file : realPath + File.separator + file;
    }

    public static TextResolver getTextResolver(FacesContext fc) {
        return FacesUtils.getWebApplication().getTextResolver(fc);
    }

    public static String getMessage(FacesContext fc, String key) {
        return FacesUtils.getTextResolver(fc).resolveKey(key);
    }

    public static String getMessage(String messageKey) {
        return FacesUtils.getMessage(FacesUtils.getContext(), messageKey);
    }

    public static void addInfoMessage(FacesContext fc, String clientId, String msg) {
        fc.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg));
    }

    public static void addInfoMessage(FacesContext fc, String msg) {
        FacesUtils.addInfoMessage(fc, null, msg);
    }

    public static void addWarnMessage(FacesContext fc, String clientId, String msg) {
        fc.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_WARN, msg, msg));
    }

    public static void addWarnMessage(FacesContext fc, String msg) {
        FacesUtils.addWarnMessage(fc, null, msg);
    }

    public static void addErrorMessage(FacesContext fc, String clientId, String msg) {
        fc.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
    }

    public static void addErrorMessage(FacesContext fc, String msg) {
        FacesUtils.addErrorMessage(fc, null, msg);
    }

    public static FacesMessage getFacesErrorMessage(FacesContext fc, Throwable t) {
        if (!(t instanceof EmpireException)) {
            t = new InternalException(t);
        }
        TextResolver tr = FacesUtils.getWebApplication().getTextResolver(fc);
        String msg = tr.getExceptionMessage((Exception)((EmpireException)t));
        return new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
    }

    public static void redirectFromError(Page page, Throwable t) {
        PageOutcome pageTarget = page.getPageDefinition().getOutcome();
        FacesContext fc = FacesUtils.getContext();
        boolean committed = fc.getExternalContext().isResponseCommitted();
        if (committed) {
            log.warn("Cannot redirect to {} from an already committed response! Error is {}.", (Object)pageTarget, (Object)t.getMessage());
            return;
        }
        FacesMessage facesMsg = FacesUtils.getFacesErrorMessage(fc, t);
        ExternalContext ec = fc.getExternalContext();
        ec.getSessionMap().put("PAGE_SESSION_MESSAGE", facesMsg);
        FacesUtils.redirectDirectly(fc, pageTarget);
    }

    public static UIInput findInputComponent(UIComponent parent, Column column) {
        Iterator children = parent.getFacetsAndChildren();
        while (children.hasNext()) {
            UIComponent nextChild = (UIComponent)children.next();
            log.info("Checking child {}", (Object)nextChild.getClass().getName());
            if (nextChild instanceof UIInput) {
                Object col = nextChild.getAttributes().get("column");
                if (col == null) {
                    ValueExpression ve = nextChild.getValueExpression("column");
                    if (ve == null) continue;
                    log.warn("TODO: evaluate Value Expression!");
                    continue;
                }
                if (!column.equals(col)) continue;
                return (UIInput)nextChild;
            }
            UIInput input = FacesUtils.findInputComponent(nextChild, column);
            if (input == null) continue;
            return input;
        }
        return null;
    }

    public static UIInput findInputComponent(FacesContext fc, String formId, Column column) {
        UIViewRoot parent = fc.getViewRoot();
        if (StringUtils.isNotEmpty((String)formId) && (parent = WebApplication.findChildComponent((UIComponent)parent, formId)) == null) {
            return null;
        }
        return FacesUtils.findInputComponent((UIComponent)parent, column);
    }
}

