/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.FacesWrapper;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.data.Record;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.FieldNotNullException;
import org.apache.empire.exceptions.BeanPropertyGetException;
import org.apache.empire.exceptions.BeanPropertySetException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidPropertyException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.app.WebApplication;
import org.apache.empire.jsf2.components.ControlTag;
import org.apache.empire.jsf2.components.InputTag;
import org.apache.empire.jsf2.components.LabelTag;
import org.apache.empire.jsf2.components.LinkTag;
import org.apache.empire.jsf2.components.RecordTag;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.apache.empire.jsf2.utils.TagContextInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagEncodingHelper
implements NamingContainer {
    private static final String SPACE = " ";
    private static final Logger log = LoggerFactory.getLogger(TagEncodingHelper.class);
    public static final String ORIGINAL_COMPONENT_ID = "ORIGINAL_COMPONENT_ID";
    public static final String COLATTR_TOOLTIP = "TOOLTIP";
    public static final String COLATTR_ABBR_TITLE = "ABBR_TITLE";
    protected final UIOutput component;
    protected final String cssStyleClass;
    protected Column column = null;
    protected Object record = null;
    protected RecordTag recordTag = null;
    protected UIData uiDataTag = null;
    protected Boolean hasValueExpr = null;
    protected InputControl control = null;
    protected TextResolver textResolver = null;
    protected Object mostRecentValue = null;
    protected boolean skipValidation = false;
    protected boolean hasError = false;
    protected Boolean insideUIData = null;
    protected static final String PH_COLUMN_NAME = "@";
    protected static final String PH_COLUMN_FULL = "&";
    protected static final String CC_ATTR_EXPR = "#{cc.attrs.";
    public static final String CSS_DATA_TYPE_NONE = "";
    public static final String CSS_DATA_TYPE_IDENT = " eTypeIdent";
    public static final String CSS_DATA_TYPE_NUMBER = " eTypeNumber";
    public static final String CSS_DATA_TYPE_TEXT = " eTypeText";
    public static final String CSS_DATA_TYPE_LONGTEXT = " eTypeLongText";
    public static final String CSS_DATA_TYPE_DATE = " eTypeDate";
    public static final String CSS_DATA_TYPE_BOOL = " eTypeBool";

    protected TagEncodingHelper(UIOutput component, String cssStyleClass) {
        this.component = component;
        this.cssStyleClass = cssStyleClass;
    }

    public void encodeBegin() {
        if (this.component instanceof UIInput && ((UIInput)this.component).isLocalValueSet()) {
            if (log.isDebugEnabled()) {
                log.debug("clearing local value for {}. value is {}.", (Object)this.getColumnName(), ((UIInput)this.component).getLocalValue());
            }
            ((UIInput)this.component).setValue(null);
            ((UIInput)this.component).setLocalValueSet(false);
        }
        this.checkRecord();
    }

    public void prepareData() {
        this.checkRecord();
    }

    public String completeInputTagId(String id) {
        if (StringUtils.isEmpty((String)id) || PH_COLUMN_NAME.equals(id)) {
            return this.getColumnName();
        }
        if (id.indexOf(PH_COLUMN_NAME) >= 0) {
            id = id.replace(PH_COLUMN_NAME, this.getColumnName());
        } else if (id.indexOf(PH_COLUMN_FULL) >= 0) {
            String name = null;
            if (this.column == null) {
                this.column = this.findColumn();
            }
            if (this.column instanceof DBColumn) {
                name = ((DBColumn)this.column).getFullName().replace('.', '_');
            } else if (this.column != null) {
                name = this.column.getName();
            }
            id = id.replace(PH_COLUMN_FULL, String.valueOf(name));
        }
        return id;
    }

    public InputControl getInputControl() {
        Object attr;
        if (this.getColumn() == null) {
            throw new NotSupportedException((Object)this, "getInputControl");
        }
        String controlType = this.getTagAttributeString("controlType");
        if (controlType == null && "text".equalsIgnoreCase(controlType = this.column.getControlType()) && (attr = this.getTagAttributeValue("options")) != null && attr instanceof Options && !((Options)attr).isEmpty()) {
            controlType = "select";
        }
        this.control = this.detectInputControl(controlType, this.column.getDataType(), this.column.getOptions() != null);
        return this.control;
    }

    protected InputControl detectInputControl(String controlType, DataType dataType, boolean hasOptions) {
        if (dataType == null) {
            throw new InvalidArgumentException("dataType", (Object)dataType);
        }
        InputControl control = null;
        if (StringUtils.isNotEmpty((String)controlType)) {
            control = InputControlManager.getControl(controlType);
        }
        if (control == null) {
            if (hasOptions) {
                controlType = "select";
            } else {
                switch (dataType) {
                    case CLOB: {
                        controlType = "textarea";
                        break;
                    }
                    default: {
                        controlType = "text";
                    }
                }
            }
            control = InputControlManager.getControl(controlType);
            if (control == null) {
                control = InputControlManager.getControl("text");
            }
        }
        return control;
    }

    protected void checkRecord() {
        if (this.record == null) {
            return;
        }
        Object rec = this.getTagAttributeValue("record");
        if (rec != null) {
            if (rec != this.record) {
                if (log.isTraceEnabled()) {
                    if (rec instanceof DBRecord && this.record instanceof DBRecord) {
                        String keyOld = StringUtils.toString((Object[])((DBRecord)this.record).getKeyValues());
                        String keyNew = StringUtils.toString((Object[])((DBRecord)rec).getKeyValues());
                        String rowSet = StringUtils.valueOf((Object)((DBRecord)rec).getRowSet().getName());
                        log.trace("Changing " + this.component.getClass().getSimpleName() + " record of rowset " + rowSet + " from {} to {}", (Object)keyOld, (Object)keyNew);
                    } else {
                        log.trace("Changing " + this.component.getClass().getSimpleName() + " record of class " + rec.getClass().getSimpleName());
                    }
                }
                this.setRecord(rec);
            }
        } else if (this.recordTag != null) {
            rec = this.recordTag.getRecord();
            if (rec != this.record) {
                this.setRecord(rec);
            }
        } else if (this.isInsideUIData()) {
            this.setRecord(null);
        }
    }

    public InputControl.ValueInfo getValueInfo(FacesContext ctx) {
        return new ValueInfoImpl(this.getColumn(), this.getTextResolver(ctx));
    }

    public InputControl.InputInfo getInputInfo(FacesContext ctx) {
        this.skipValidation = FacesUtils.isSkipInputValidation(ctx);
        this.hasError = this.detectError(ctx);
        return new InputInfoImpl(this.getColumn(), this.getTextResolver(ctx));
    }

    public boolean isPartialSubmit(FacesContext ctx) {
        return FacesUtils.getWebApplication().isPartialSubmit(ctx);
    }

    public boolean isSkipValidation() {
        return this.skipValidation;
    }

    public boolean hasColumn() {
        if (this.column == null) {
            this.column = this.findColumn();
        }
        if (this.column == null) {
            if (this.getTagAttributeValue("column") != null) {
                return false;
            }
            this.column = this.findColumnFromValue();
            if (this.column != null) {
                log.warn("Providing the column as the value is deprecated. Use column attribute insteam. This might be removed in future versions!");
            }
        }
        return this.column != null;
    }

    public Column getColumn() {
        if (this.hasColumn()) {
            return this.column;
        }
        throw new InvalidArgumentException("column", (Object)this.column);
    }

    public String getColumnName() {
        if (this.column == null) {
            this.column = this.findColumn();
        }
        return this.column != null ? this.column.getName() : "null";
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Object getRecord() {
        if (this.record == null && (this.record = this.findRecord()) != null) {
            this.setRecord(this.record);
        }
        return this.record;
    }

    public void setRecord(Object record) {
        this.record = record;
        this.mostRecentValue = null;
    }

    public Object findRecordComponent() {
        if (this.recordTag != null) {
            return this.recordTag.getRecord();
        }
        if (this.uiDataTag != null) {
            if (this.uiDataTag.isRowAvailable()) {
                return this.uiDataTag.getRowData();
            }
            return null;
        }
        UIOutput parent = this.component;
        while ((parent = parent.getParent()) != null) {
            if (parent instanceof RecordTag) {
                this.recordTag = (RecordTag)parent;
                return this.recordTag.getRecord();
            }
            if (!(parent instanceof UIData)) continue;
            this.uiDataTag = (UIData)parent;
            this.insideUIData = true;
            return this.uiDataTag.getRowData();
        }
        return null;
    }

    protected boolean isDetectFieldChange() {
        Object v = this.getTagAttributeValue("detectFieldChange");
        if (v == null && this.recordTag != null) {
            v = this.recordTag.getAttributes().get("detectFieldChange");
        }
        return v != null ? ObjectUtils.getBoolean((Object)v) : true;
    }

    public Object getDataValue(boolean evalExpression) {
        if (this.getRecord() != null) {
            if (this.record instanceof RecordData) {
                ColumnExpr col = this.unwrapColumnExpr(this.getColumn());
                this.mostRecentValue = ((RecordData)this.record).getValue(col);
                return this.mostRecentValue;
            }
            String prop = this.getColumn().getBeanPropertyName();
            return this.getBeanPropertyValue(this.record, prop);
        }
        if (evalExpression) {
            return this.component.getValue();
        }
        Object value = this.component.getLocalValue();
        if (value != null && this.component instanceof UIInput && !((UIInput)this.component).isLocalValueSet()) {
            value = null;
        }
        if (value == null) {
            value = this.findValueExpression("value", false);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataValue(Object value) {
        if (this.getRecord() != null) {
            if (this.record instanceof Record) {
                Object currentValue;
                this.getColumn();
                if (this.mostRecentValue != null && this.isDetectFieldChange() && !ObjectUtils.compareEqual((Object)(currentValue = ((Record)this.record).getValue((ColumnExpr)this.column)), (Object)this.mostRecentValue)) {
                    log.info("Concurrent data change for " + this.column.getName() + ". Current Value is {}. Ignoring new value {}", currentValue, value);
                    return;
                }
                boolean reenableValidation = false;
                if (this.skipValidation && this.record instanceof DBRecord) {
                    if (this.isReadOnly()) {
                        return;
                    }
                    if (ObjectUtils.isEmpty((Object)value) && ((Record)this.record).isFieldRequired(this.column)) {
                        return;
                    }
                    reenableValidation = ((DBRecord)this.record).isValidateFieldValues();
                    if (reenableValidation) {
                        ((DBRecord)this.record).setValidateFieldValues(false);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Input Validation skipped for {}.", (Object)this.column.getName());
                    }
                }
                try {
                    ((Record)this.record).setValue(this.column, value);
                    this.mostRecentValue = value;
                }
                finally {
                    if (reenableValidation) {
                        ((DBRecord)this.record).setValidateFieldValues(true);
                    }
                }
            } else {
                if (this.record instanceof RecordData) {
                    throw new PropertyReadOnlyException("record");
                }
                String prop = this.getColumn().getBeanPropertyName();
                this.setBeanPropertyValue(this.record, prop, value);
            }
        } else {
            ValueExpression ve = this.component.getValueExpression("value");
            if (ve == null) {
                throw new PropertyReadOnlyException("value");
            }
            FacesContext ctx = FacesContext.getCurrentInstance();
            ve.setValue(ctx.getELContext(), value);
        }
    }

    public boolean isRenderValueComponent() {
        return this.isRecordReadOnly();
    }

    public boolean isRecordReadOnly() {
        Object val = this.getTagAttributeValue("readonly");
        if (val != null && ObjectUtils.getBoolean((Object)val)) {
            return true;
        }
        if (this.getRecord() instanceof RecordData ? !(this.record instanceof Record) || ((Record)this.record).isReadOnly() : !this.hasValueExpression()) {
            return true;
        }
        return this.recordTag != null && this.recordTag.isReadOnly();
    }

    public boolean isVisible() {
        Object recordTagValue;
        if (this.record != null && (recordTagValue = this.getTagAttributeValue("record")) instanceof DBRecord && this.record != recordTagValue) {
            log.warn("Record in call to IsVisible has unexpectedly changed!");
            this.record = null;
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isFieldVisible(this.getColumn());
        }
        return true;
    }

    public boolean isReadOnly() {
        if (this.isRecordReadOnly()) {
            return true;
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isFieldReadOnly(this.getColumn());
        }
        return this.getColumn().isReadOnly();
    }

    public boolean isValueRequired() {
        Object mandatory = this.getTagAttributeValue("mandatory");
        if (mandatory != null) {
            return ObjectUtils.getBoolean((Object)mandatory);
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isFieldRequired(this.getColumn());
        }
        if (this.hasValueExpression()) {
            return false;
        }
        return this.getColumn().isRequired();
    }

    public boolean isValueModified() {
        Object modified = this.getTagAttributeValue("modified");
        if (modified != null) {
            return ObjectUtils.getBoolean((Object)modified);
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.wasModified(this.getColumn());
        }
        return false;
    }

    public boolean validateNullValue() {
        if (this.isValueRequired()) {
            throw new FieldNotNullException(this.column);
        }
        return true;
    }

    public boolean isTempoaryNullable() {
        return !this.getColumn().isRequired();
    }

    protected Column findColumn() {
        Object col = this.getTagAttributeValue("column");
        if (col instanceof Column) {
            return (Column)col;
        }
        if (col instanceof ColumnExpr) {
            if (this.component instanceof InputTag || this.component instanceof ControlTag) {
                log.warn("ColumnExpresion cannot be used with InputTag or ControlTag");
                throw new InvalidPropertyException("column", (Object)this.column);
            }
            return this.createColumnExprWrapper((ColumnExpr)col);
        }
        if (col instanceof String) {
            String name = String.valueOf(col);
            int dbix = name.indexOf(46);
            if (dbix <= 0) {
                log.error("Invalid column expression '{}'!", (Object)name);
                return null;
            }
            DBDatabase db = DBDatabase.findById((String)name.substring(0, dbix));
            if (db == null) {
                log.error("Database '{}' not found!", (Object)name.substring(0, dbix));
                return null;
            }
            int co = name.lastIndexOf(46);
            int to = name.lastIndexOf(46, co - 1);
            String cn = name.substring(co + 1);
            String tn = name.substring(to + 1, co);
            DBRowSet rs = db.getRowSet(tn);
            if (rs == null) {
                log.error("Table/View '{}' not found in database!", (Object)tn);
                return null;
            }
            DBColumn column = rs.getColumn(cn);
            if (column == null) {
                log.error("Column '{}' not found in table/view '{}'!", (Object)cn, (Object)tn);
                return null;
            }
            return column;
        }
        if (log.isDebugEnabled() && !(this.component instanceof LinkTag)) {
            log.warn("No Column provided for value tag!");
        }
        return null;
    }

    protected Column findColumnFromValue() {
        Object col = this.component.getValue();
        if (col instanceof Column) {
            return (Column)col;
        }
        if (col instanceof ColumnExpr) {
            Column source = ((ColumnExpr)col).getSourceColumn();
            if (source != null) {
                return source;
            }
            return this.createColumnExprWrapper((ColumnExpr)col);
        }
        return null;
    }

    protected Column createColumnExprWrapper(ColumnExpr colExpr) {
        return new ColumnExprWrapper(colExpr);
    }

    protected ColumnExpr unwrapColumnExpr(Column col) {
        if (col instanceof ColumnExprWrapper) {
            return ((ColumnExprWrapper)col).getExpr();
        }
        return col;
    }

    protected Column unwrapColumn(Column col) {
        if (col instanceof ColumnExprWrapper) {
            return ((ColumnExprWrapper)col).getSourceColumn();
        }
        return col;
    }

    protected Object findRecord() {
        Object rec = this.getTagAttributeValue("record");
        if (rec != null) {
            return rec;
        }
        if (this.hasValueExpression()) {
            return null;
        }
        rec = this.findRecordComponent();
        if (rec == null && this.component instanceof ControlTag && !((ControlTag)this.component).isCustomInput()) {
            log.warn("No record supplied for {} and column {}.", (Object)this.component.getClass().getSimpleName(), (Object)this.getColumnName());
        }
        return rec;
    }

    protected boolean hasValueExpression() {
        if (this.hasValueExpr != null) {
            return this.hasValueExpr;
        }
        ValueExpression ve = this.findValueExpression("value", false);
        if (ve != null) {
            String originalExpr = log.isDebugEnabled() ? ve.getExpressionString() : null;
            ve = FacesUtils.getFacesImplementation().unwrapValueExpression(ve);
            if (originalExpr != null) {
                if (ve != null && !originalExpr.equals(ve.getExpressionString())) {
                    log.debug("ValueExpression \"{}\" has been resolved to \"{}\" from class {}", new Object[]{originalExpr, ve.getExpressionString(), ve.getClass().getName()});
                } else if (ve == null) {
                    log.debug("ValueExpression \"{}\" has been resolved to NULL", (Object)originalExpr);
                }
            }
        }
        this.hasValueExpr = ve != null;
        return this.hasValueExpr;
    }

    protected ValueExpression findValueExpression(String attribute, boolean allowLiteral) {
        ValueExpression ve = this.component.getValueExpression(attribute);
        if (ve == null) {
            return null;
        }
        UIOutput parent = this.component;
        String expr = ve.getExpressionString();
        while (expr.startsWith(CC_ATTR_EXPR)) {
            UIComponent valueParent;
            if (ve instanceof FacesWrapper) {
                ve = (ValueExpression)((FacesWrapper)ve).getWrapped();
            }
            if ((parent = (valueParent = FacesUtils.getFacesImplementation().getValueParentComponent(ve)) != null ? valueParent : UIComponent.getCompositeComponentParent((UIComponent)parent)) == null) {
                return null;
            }
            int end = expr.indexOf(125);
            String attrib = expr.substring(CC_ATTR_EXPR.length(), end);
            if (attrib.indexOf(46) > 0) {
                return ve;
            }
            ValueExpression next = parent.getValueExpression(attrib);
            if (next == null) {
                if (allowLiteral && parent.getAttributes().get(attrib) != null) {
                    return ve;
                }
                return null;
            }
            ve = next;
            expr = ve.getExpressionString();
        }
        return ve;
    }

    protected Options getValueOptions() {
        Object attr = this.getTagAttributeValue("options");
        if (attr != null && attr instanceof Options) {
            return (Options)attr;
        }
        if (this.getColumn() != null) {
            if (this.getRecord() instanceof Record) {
                return ((Record)this.record).getFieldOptions(this.unwrapColumn(this.column));
            }
            return this.column.getOptions();
        }
        return null;
    }

    protected Object getBeanPropertyValue(Object bean, String property) {
        try {
            PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
            return pub.getSimpleProperty(bean, property);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn(bean.getClass().getName() + ": no getter available for property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
    }

    protected void setBeanPropertyValue(Object bean, String property, Object value) {
        try {
            if (ObjectUtils.isEmpty((Object)value)) {
                value = null;
            }
            if (value != null) {
                BeanUtils.setProperty((Object)bean, (String)property, (Object)value);
            } else {
                PropertyUtils.setProperty((Object)bean, (String)property, null);
            }
        }
        catch (IllegalArgumentException e) {
            log.error(bean.getClass().getName() + ": invalid argument for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error(bean.getClass().getName() + ": no setter available for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
    }

    public String getValueTooltip(Object value) {
        String text;
        Options options;
        if (value == null) {
            return null;
        }
        if (value instanceof Column) {
            Column ttc = (Column)value;
            if (this.getRecord() != null) {
                if (this.record instanceof RecordData) {
                    value = ((RecordData)this.record).getValue((ColumnExpr)ttc);
                } else {
                    String prop = ttc.getBeanPropertyName();
                    value = this.getBeanPropertyValue(this.record, prop);
                }
                return StringUtils.valueOf((Object)value);
            }
            log.warn("Unable to resolve Tooltip-value for column {}.", (Object)ttc.getName());
            return null;
        }
        String templ = StringUtils.valueOf((Object)value);
        int valIndex = templ.indexOf("{}");
        if (valIndex >= 0) {
            value = this.getDataValue(true);
        }
        if ((options = this.getValueOptions()) != null && !this.hasFormat("notitlelookup")) {
            String optValue = options.get(value);
            text = this.getDisplayText(optValue);
        } else {
            text = this.getDisplayText(StringUtils.toString((Object)value));
        }
        if (valIndex >= 0 && text != null) {
            text = StringUtils.replace((String)templ, (String)"{}", (String)text);
        }
        return text;
    }

    public String getLabelTooltip(Column column) {
        String title = this.getTagAttributeString("title");
        if (title == null) {
            title = StringUtils.toString((Object)column.getAttribute("tooltip"));
        }
        if (title != null) {
            return this.getDisplayText(title);
        }
        if (this.hasFormat("short") && !ObjectUtils.isEmpty((Object)column.getAttribute(COLATTR_ABBR_TITLE))) {
            return this.getDisplayText(column.getTitle());
        }
        return null;
    }

    public boolean hasFormat(String format) {
        String f = this.getTagAttributeString("format");
        return f != null && f.indexOf(format) >= 0;
    }

    public boolean hasFormat(InputControl.ValueInfo vi, String format) {
        String f = vi.getFormat();
        return f != null && f.indexOf(format) >= 0;
    }

    public void writeAttribute(ResponseWriter writer, String attribute, Object value) throws IOException {
        if (value != null) {
            writer.writeAttribute(attribute, value, null);
        }
    }

    public String getDisplayText(String text) {
        if (this.textResolver == null) {
            this.getTextResolver(FacesContext.getCurrentInstance());
        }
        return this.textResolver.resolveText(text);
    }

    public TextResolver getTextResolver(FacesContext context) {
        if (this.textResolver == null) {
            this.textResolver = WebApplication.getInstance().getTextResolver(context);
        }
        return this.textResolver;
    }

    protected boolean detectError(FacesContext context) {
        Iterator iter = context.getMessages(this.component.getClientId());
        while (iter.hasNext()) {
            FacesMessage m = (FacesMessage)iter.next();
            if (m.getSeverity() != FacesMessage.SEVERITY_ERROR) continue;
            return true;
        }
        return false;
    }

    public void addErrorMessage(FacesContext context, Exception e) {
        String msgText = this.getTextResolver(context).getExceptionMessage(e);
        FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msgText, msgText);
        context.addMessage(this.component.getClientId(), msg);
    }

    public Object getAttributeValueEx(String name) {
        Object value = this.getTagAttributeValue(name);
        if (value == null && this.hasColumn()) {
            value = this.column.getAttribute(name);
        }
        if (value instanceof Column) {
            Column col = (Column)value;
            Object rec = this.getRecord();
            if (rec instanceof Record) {
                return ((Record)rec).getValue((ColumnExpr)col);
            }
            if (rec != null) {
                String property = col.getBeanPropertyName();
                try {
                    PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
                    return pub.getSimpleProperty(rec, property);
                }
                catch (Exception e) {
                    log.error("BeanUtils.getSimpleProperty failed for " + property, (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        return value;
    }

    public String getTagAttributeStringEx(String name) {
        Object value = this.getAttributeValueEx(name);
        return value != null ? StringUtils.toString((Object)value) : null;
    }

    public Object getTagAttributeValue(String name) {
        return TagEncodingHelper.getTagAttributeValue((UIComponent)this.component, name);
    }

    public static Object getTagAttributeValue(UIComponent comp, String name) {
        ValueExpression ve;
        Object value = comp.getAttributes().get(name);
        if (value == null && (ve = comp.getValueExpression(name)) != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            value = ve.getValue(ctx.getELContext());
        }
        return value;
    }

    public String getTagAttributeString(String name, String defValue) {
        Object v = this.getTagAttributeValue(name);
        return v != null ? StringUtils.toString((Object)v) : defValue;
    }

    public String getTagAttributeString(String name) {
        return this.getTagAttributeString(name, null);
    }

    protected String getLabelValue(Column column, boolean colon) {
        String label = this.getTagAttributeString("label");
        if (label == null) {
            if (this.hasFormat("short") && (label = StringUtils.toString((Object)column.getAttribute(COLATTR_ABBR_TITLE))) == null) {
                log.warn("No Abbreviation available for column {}. Using normal title.", (Object)column.getName());
            }
            if (label == null) {
                label = column.getTitle();
            }
            label = this.getDisplayText(label);
        }
        if (StringUtils.isEmpty((String)label)) {
            return CSS_DATA_TYPE_NONE;
        }
        if (colon) {
            label = label.trim() + ":";
        }
        return label;
    }

    public HtmlOutputLabel createLabelComponent(FacesContext context, String forInput, String styleClass, String style, boolean colon) {
        String title;
        Column column = null;
        boolean readOnly = false;
        boolean required = false;
        if (StringUtils.isNotEmpty((String)forInput)) {
            if (!forInput.equals("*")) {
                UIComponent input = FacesUtils.getWebApplication().findComponent(context, forInput, (UIComponent)this.component);
                if (input != null && input instanceof InputTag) {
                    InputTag inputTag = (InputTag)input;
                    column = inputTag.getInputColumn();
                    readOnly = inputTag.isInputReadOnly();
                    required = inputTag.isInputRequired();
                } else {
                    log.warn("Input component {} not found for label {}.", (Object)forInput, (Object)this.getColumn().getName());
                }
            } else if (this.component instanceof LabelTag) {
                forInput = this.getColumnName();
                Object val = this.getAttributeValueEx("readOnly");
                readOnly = val != null ? ObjectUtils.getBoolean((Object)val) : this.isReadOnly();
            } else {
                readOnly = this.isReadOnly();
            }
        }
        if (column == null) {
            column = this.getColumn();
            required = this.isValueRequired();
        }
        if (column == null) {
            throw new InvalidArgumentException("column", (Object)column);
        }
        HtmlOutputLabel label = InputControlManager.createComponent(context, InputControlManager.getLabelComponentClass());
        String labelText = this.getLabelValue(column, colon);
        if (StringUtils.isEmpty((String)labelText)) {
            label.setRendered(false);
        } else {
            label.setValue((Object)labelText);
        }
        if (StringUtils.isNotEmpty((String)styleClass)) {
            label.setStyleClass(this.completeLabelStyleClass(styleClass, required));
        }
        if (StringUtils.isNotEmpty((String)forInput) && !readOnly) {
            InputControl.InputInfo ii = this.getInputInfo(context);
            String inputId = this.getInputControl().getLabelForId(ii);
            if (StringUtils.isNotEmpty((String)inputId)) {
                if (forInput.equals("*")) {
                    label.setFor(inputId);
                } else {
                    label.setFor(forInput + ":" + inputId);
                }
            } else {
                log.info("No input-id provided for {}.", (Object)this.getColumn().getName());
            }
        }
        if (StringUtils.isNotEmpty((String)style)) {
            label.setStyle(style);
        }
        if ((title = this.getLabelTooltip(column)) != null) {
            label.setTitle(title);
        }
        if (required && InputControlManager.isShowLabelRequiredMark()) {
            this.addRequiredMark(label);
        }
        return label;
    }

    public void updateLabelComponent(FacesContext context, HtmlOutputLabel label, String forInput) {
        boolean hasMark;
        UIComponent input;
        InputTag inputTag = null;
        if (StringUtils.isNotEmpty((String)forInput) && !forInput.equals("*") && (input = FacesUtils.getWebApplication().findComponent(context, forInput, (UIComponent)this.component)) != null && input instanceof InputTag) {
            inputTag = (InputTag)input;
        }
        boolean required = inputTag != null ? inputTag.isInputRequired() : this.isValueRequired();
        String styleClass = label.getStyleClass();
        label.setStyleClass(this.completeLabelStyleClass(styleClass, required));
        boolean bl = hasMark = label.getChildCount() > 0;
        if (required == hasMark) {
            return;
        }
        if (required && InputControlManager.isShowLabelRequiredMark()) {
            this.addRequiredMark(label);
        } else {
            label.getChildren().clear();
        }
    }

    protected String completeLabelStyleClass(String styleClass, boolean required) {
        String LABEL_REQ_STYLE = " eInpReq";
        boolean hasRequired = StringUtils.contains((String)styleClass, (String)" eInpReq");
        if (required == hasRequired) {
            return styleClass;
        }
        if (styleClass == null) {
            styleClass = CSS_DATA_TYPE_NONE;
        }
        styleClass = required ? styleClass + " eInpReq" : StringUtils.remove((String)styleClass, (String)" eInpReq");
        return styleClass;
    }

    protected void addRequiredMark(HtmlOutputLabel label) {
        HtmlPanelGroup span = new HtmlPanelGroup();
        span.setStyleClass("required");
        HtmlOutputText text = new HtmlOutputText();
        text.setValue((Object)"*");
        span.getChildren().add(text);
        label.getChildren().add(span);
    }

    public static final String assembleStyleClassString(String tagCssStyle, String typeClass, String addlStyle, String userStyle) {
        if (StringUtils.isEmpty((String)userStyle) && StringUtils.isEmpty((String)addlStyle)) {
            return StringUtils.isEmpty((String)typeClass) ? tagCssStyle : tagCssStyle + typeClass;
        }
        StringBuilder b = new StringBuilder(tagCssStyle);
        if (StringUtils.isNotEmpty((String)typeClass)) {
            b.append(typeClass);
        }
        if (StringUtils.isNotEmpty((String)addlStyle)) {
            if (!addlStyle.startsWith(SPACE)) {
                b.append(SPACE);
            }
            b.append(addlStyle);
        }
        if (StringUtils.isNotEmpty((String)userStyle) && !StringUtils.compareEqual((String)userStyle, (String)addlStyle, (boolean)false)) {
            if (!userStyle.startsWith(SPACE)) {
                b.append(SPACE);
            }
            b.append(userStyle);
        }
        return b.toString();
    }

    protected String getDataTypeClass(DataType type) {
        switch (type) {
            case AUTOINC: {
                return CSS_DATA_TYPE_IDENT;
            }
            case INTEGER: 
            case DECIMAL: 
            case FLOAT: {
                return CSS_DATA_TYPE_NUMBER;
            }
            case TEXT: 
            case VARCHAR: 
            case CHAR: {
                return CSS_DATA_TYPE_TEXT;
            }
            case DATE: 
            case DATETIME: 
            case TIMESTAMP: {
                return CSS_DATA_TYPE_DATE;
            }
            case BOOL: {
                return CSS_DATA_TYPE_BOOL;
            }
            case CLOB: {
                return CSS_DATA_TYPE_LONGTEXT;
            }
        }
        return CSS_DATA_TYPE_NONE;
    }

    public String getTagStyleClass(DataType dataType, String addlStyle, String userStyle) {
        String typeClass = dataType != null ? this.getDataTypeClass(dataType) : null;
        String contextStyle = this.getContextStyleClass(addlStyle);
        return TagEncodingHelper.assembleStyleClassString(this.cssStyleClass, typeClass, contextStyle, userStyle);
    }

    public String getTagStyleClass(DataType dataType, String addlStyle) {
        String userStyle = this.getTagAttributeStringEx("styleClass");
        return this.getTagStyleClass(dataType, addlStyle, userStyle);
    }

    public String getTagStyleClass(String addlStyle) {
        DataType dataType = this.hasColumn() ? this.column.getDataType() : null;
        return this.getTagStyleClass(dataType, addlStyle);
    }

    public final String getTagStyleClass() {
        return this.getTagStyleClass(null);
    }

    protected String getContextStyleClass(String addlStyle) {
        String contextStyle = null;
        if (this.getRecord() instanceof TagContextInfo && this.hasColumn()) {
            contextStyle = ((TagContextInfo)this.getRecord()).getContextStyleClass(this.getColumn());
        }
        if (StringUtils.isEmpty((String)addlStyle)) {
            return contextStyle;
        }
        if (StringUtils.isEmpty(contextStyle)) {
            return addlStyle;
        }
        if (contextStyle.startsWith(SPACE)) {
            return addlStyle + contextStyle;
        }
        return addlStyle + SPACE + contextStyle;
    }

    public boolean isInsideUIData() {
        if (this.component == null) {
            return false;
        }
        if (this.insideUIData != null) {
            return this.insideUIData;
        }
        this.insideUIData = false;
        for (UIComponent p = this.component.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof UIData)) continue;
            this.insideUIData = true;
            break;
        }
        return this.insideUIData;
    }

    public void saveComponentId(UIComponent comp) {
        if (comp == null || comp.getId() == null) {
            return;
        }
        String compId = comp.getId();
        comp.getAttributes().put(ORIGINAL_COMPONENT_ID, compId);
        comp.setId(compId);
    }

    public void restoreComponentId(UIComponent comp) {
        if (comp == null) {
            return;
        }
        String compId = StringUtils.toString(comp.getAttributes().get(ORIGINAL_COMPONENT_ID));
        if (compId == null) {
            return;
        }
        if (!StringUtils.compareEqual((String)compId, (String)comp.getId(), (boolean)false)) {
            log.warn("Restoring original Component-id from {} to {}", (Object)comp.getId(), (Object)compId);
            comp.setId(compId);
        }
    }

    public void resetComponentId(UIComponent comp) {
        if (comp == null || comp.getId() == null) {
            return;
        }
        if (this.isInsideUIData()) {
            String resetId = comp.getId();
            if (log.isInfoEnabled()) {
                log.info("Resetting Component-id inside UIData to {}", (Object)resetId);
            }
            comp.setId(resetId);
        }
    }

    protected class InputInfoImpl
    extends ValueInfoImpl
    implements InputControl.InputInfo {
        public InputInfoImpl(Column column, TextResolver resolver) {
            super(column, resolver);
        }

        @Override
        public void setValue(Object value) {
            TagEncodingHelper.this.setDataValue(value);
        }

        @Override
        public void validate(Object value) {
            if (TagEncodingHelper.this.skipValidation) {
                return;
            }
            boolean isNull = ObjectUtils.isEmpty((Object)value);
            if (isNull && TagEncodingHelper.this.validateNullValue()) {
                return;
            }
            if (TagEncodingHelper.this.getRecord() instanceof Record) {
                ((Record)TagEncodingHelper.this.getRecord()).validateValue(TagEncodingHelper.this.column, value);
            } else {
                TagEncodingHelper.this.column.validate(value);
            }
        }

        @Override
        public boolean isRequired() {
            return TagEncodingHelper.this.isValueRequired();
        }

        @Override
        public boolean isModified() {
            return TagEncodingHelper.this.isValueModified();
        }

        @Override
        public boolean isDisabled() {
            Object val = TagEncodingHelper.this.getAttributeValueEx("disabled");
            return val != null && ObjectUtils.getBoolean((Object)val);
        }

        @Override
        public boolean isFieldReadOnly() {
            if (TagEncodingHelper.this.isRecordReadOnly()) {
                return true;
            }
            if (!(TagEncodingHelper.this.component instanceof UIInput)) {
                return true;
            }
            if (TagEncodingHelper.this.getRecord() instanceof Record) {
                Record r = (Record)TagEncodingHelper.this.record;
                return r.isFieldReadOnly(this.getColumn());
            }
            return this.getColumn().isReadOnly();
        }

        @Override
        public String getInputId() {
            return "inp";
        }

        @Override
        public boolean hasError() {
            return TagEncodingHelper.this.hasError;
        }

        @Override
        public Object getAttribute(String name) {
            return TagEncodingHelper.this.getTagAttributeValue(name);
        }

        @Override
        public Object getAttributeEx(String name) {
            return TagEncodingHelper.this.getAttributeValueEx(name);
        }
    }

    protected class ValueInfoImpl
    implements InputControl.ValueInfo {
        public ValueInfoImpl(Column column, TextResolver resolver) {
            if (column == null) {
                throw new InvalidArgumentException("column", (Object)resolver);
            }
            if (resolver == null) {
                throw new InvalidArgumentException("resolver", (Object)resolver);
            }
        }

        protected boolean hasColumn() {
            return TagEncodingHelper.this.column != null || TagEncodingHelper.this.hasColumn();
        }

        @Override
        public Column getColumn() {
            return TagEncodingHelper.this.column;
        }

        @Override
        public Object getValue(boolean evalExpression) {
            return TagEncodingHelper.this.getDataValue(evalExpression);
        }

        @Override
        public Options getOptions() {
            return TagEncodingHelper.this.getValueOptions();
        }

        @Override
        public String getStyleClass(String addlStyle) {
            String style = TagEncodingHelper.this.getTagStyleClass(addlStyle);
            return style;
        }

        @Override
        public String getFormat() {
            Object format;
            String attr = TagEncodingHelper.this.getTagAttributeString("format");
            if (attr != null) {
                return attr;
            }
            if (this.hasColumn() && (format = TagEncodingHelper.this.column.getAttribute("format")) != null) {
                return format.toString();
            }
            return null;
        }

        @Override
        public Locale getLocale() {
            return TagEncodingHelper.this.textResolver.getLocale();
        }

        @Override
        public String getText(String text) {
            return TagEncodingHelper.this.textResolver.resolveText(text);
        }

        @Override
        public TextResolver getTextResolver() {
            return TagEncodingHelper.this.textResolver;
        }

        @Override
        public boolean isInsideUIData() {
            return TagEncodingHelper.this.isInsideUIData();
        }
    }

    protected static class ColumnExprWrapper
    implements Column {
        private final ColumnExpr expr;

        public ColumnExprWrapper(ColumnExpr expr) {
            this.expr = expr;
        }

        public ColumnExpr getExpr() {
            return this.expr;
        }

        public DataType getDataType() {
            return this.expr.getDataType();
        }

        public String getName() {
            return this.expr.getName();
        }

        public String getTitle() {
            return this.expr.getTitle();
        }

        public String getControlType() {
            return this.expr.getControlType();
        }

        public Object getAttribute(String name) {
            return this.expr.getAttribute(name);
        }

        public Options getOptions() {
            return this.expr.getOptions();
        }

        public String getBeanPropertyName() {
            return this.expr.getBeanPropertyName();
        }

        public Column getSourceColumn() {
            return this.expr.getSourceColumn();
        }

        public double getSize() {
            return 0.0;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public Class<Enum<?>> getEnumType() {
            return this.getSourceColumn().getEnumType();
        }

        public Object validate(Object value) {
            log.warn("validate not supported for {}", (Object)this.expr.getName());
            return value;
        }
    }
}

