/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.NotImplementedException;

public class StringResponseWriter
extends ResponseWriter {
    private StringBuilder buf = new StringBuilder();

    public String getContentType() {
        return "text/html";
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    public void flush() throws IOException {
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.buf.append("<");
        this.buf.append(name);
        this.buf.append(">");
    }

    public void endElement(String name) throws IOException {
        this.buf.append("</");
        this.buf.append(name);
        this.buf.append(">");
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (StringUtils.isEmpty((String)name) || ObjectUtils.isEmpty((Object)value)) {
            return;
        }
        this.buf.append(name);
        this.buf.append("=");
        this.buf.append(String.valueOf(value));
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.writeAttribute(name, value, property);
    }

    public void writeComment(Object comment) throws IOException {
    }

    public void writeText(Object text, String property) throws IOException {
        this.buf.append(text);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.buf.append(text, off, len);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        throw new NotImplementedException(((Object)((Object)this)).getClass(), "cloneWithWriter");
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.buf.append(cbuf, off, len);
    }

    public void close() throws IOException {
    }

    public String toString() {
        return this.buf.toString();
    }
}

