/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.controls;

import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectInputControl
extends InputControl {
    private static final Logger log = LoggerFactory.getLogger(SelectInputControl.class);
    public static final String COLATTR_ABBR_OPTIONS = "ABBR_OPTIONS";
    public static final String VALUE_EXPRESSION_FLAG = "VALUE_EXPRESSION_FLAG";
    public static final String NAME = "select";
    private final Class<? extends HtmlSelectOneMenu> inputComponentClass;

    public SelectInputControl(String name, Class<? extends HtmlSelectOneMenu> inputComponentClass) {
        super(name);
        this.inputComponentClass = inputComponentClass;
    }

    public SelectInputControl() {
        this(NAME, HtmlSelectOneMenu.class);
    }

    public HtmlSelectOneMenu createMenuComponent(UIComponent parent) {
        return InputControlManager.createComponent(FacesContext.getCurrentInstance(), this.inputComponentClass);
    }

    @Override
    protected void createInputComponents(UIComponent parent, InputControl.InputInfo ii, FacesContext context, List<UIComponent> compList) {
        if (!compList.isEmpty()) {
            throw new InvalidArgumentException("compList", compList);
        }
        HtmlSelectOneMenu input = InputControlManager.createComponent(context, this.inputComponentClass);
        Object value = ii.getValue(false);
        input.getAttributes().put(VALUE_EXPRESSION_FLAG, value instanceof ValueExpression);
        this.copyAttributes(parent, ii, (UIInput)input);
        boolean disabled = ii.isDisabled();
        input.setDisabled(disabled);
        this.initOptions(input, ii.getTextResolver(), ii);
        compList.add((UIComponent)input);
        this.addRemoveDisabledStyle((UIInput)input, input.isDisabled());
        this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
        this.setInputValue((UIInput)input, ii);
    }

    @Override
    protected void updateInputState(List<UIComponent> compList, InputControl.InputInfo ii, FacesContext context, PhaseId phaseId) {
        UIComponent comp = compList.get(0);
        if (!(comp instanceof HtmlSelectOneMenu)) {
            throw new UnexpectedReturnValueException((Object)comp.getClass().getName(), "parent.getChildren()");
        }
        HtmlSelectOneMenu input = (HtmlSelectOneMenu)comp;
        this.addRemoveStyle((UIInput)input, " eInpReq", ii.isRequired());
        boolean disabled = ii.isDisabled();
        input.setDisabled(disabled);
        if (phaseId != PhaseId.APPLY_REQUEST_VALUES) {
            this.syncOptions(input, ii.getTextResolver(), ii);
        }
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.addRemoveDisabledStyle((UIInput)input, input.isDisabled());
            this.addRemoveInvalidStyle((UIInput)input, ii.hasError());
            this.setInputValue((UIInput)input, ii);
        }
    }

    protected boolean isEmptyEntryRequired(Options options, InputControl.InputInfo ii, Object currentValue) {
        if (options != null && options.containsNull()) {
            return false;
        }
        if (!ii.isRequired()) {
            return true;
        }
        return ObjectUtils.isEmpty((Object)currentValue);
    }

    public void initOptions(HtmlSelectOneMenu input, TextResolver textResolver, InputControl.InputInfo ii) {
        Object currentValue;
        Options options = ii.getOptions();
        if (options == null) {
            if (ii.getColumn() != null) {
                log.warn("No options given for column {}", (Object)ii.getColumn().getName());
            } else {
                log.warn("No options given for select tag {}", (Object)input.getClientId());
            }
            options = new Options();
        }
        if (this.isEmptyEntryRequired(options, ii, currentValue = ii.getValue(true))) {
            this.addSelectItem((UIComponent)input, textResolver, new OptionEntry(null, this.getNullText(ii)));
        }
        if (options != null && options.size() > 0) {
            for (OptionEntry oe : options) {
                if (oe.isActive() || ObjectUtils.compareEqual((Object)oe.getValue(), (Object)currentValue)) {
                    this.addSelectItem((UIComponent)input, textResolver, oe);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Select item {} is not active.", oe.getValue());
            }
        }
    }

    public void syncOptions(HtmlSelectOneMenu input, TextResolver textResolver, InputControl.InputInfo ii) {
        Options options = ii.getOptions();
        if (options == null) {
            if (ii.getValue(false) != null) {
                log.warn("No options have been set for column {}", (Object)ii.getColumn().getName());
            } else {
                input.getChildren().clear();
            }
            return;
        }
        Object currentValue = ii.getValue(true);
        boolean hasEmpty = this.isEmptyEntryRequired(options, ii, currentValue);
        Iterator ioe = options.iterator();
        OptionEntry oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        List childList = input.getChildren();
        Iterator ico = childList.iterator();
        int lastIndex = 0;
        boolean emptyPresent = false;
        while (ico.hasNext()) {
            ++lastIndex;
            UIComponent co = (UIComponent)ico.next();
            if (!(co instanceof UISelectItem)) continue;
            UISelectItem si = (UISelectItem)co;
            Object ov = si.getItemValue();
            if (ObjectUtils.isEmpty((Object)ov) && hasEmpty) {
                emptyPresent = true;
                continue;
            }
            while (oe != null && !oe.isActive() && !ObjectUtils.compareEqual((Object)oe.getValue(), (Object)currentValue)) {
                oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
            }
            if (oe == null) {
                --lastIndex;
                for (int index = childList.size() - 1; index >= lastIndex; --index) {
                    childList.remove(index);
                }
                return;
            }
            if (ObjectUtils.compareEqual((Object)ov, (Object)oe.getValue())) {
                oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
                continue;
            }
            input.getChildren().clear();
            if (hasEmpty) {
                this.addSelectItem((UIComponent)input, textResolver, new OptionEntry((Object)"", this.getNullText(ii)));
            }
            for (OptionEntry opt : options) {
                if (!opt.isActive() && !ObjectUtils.compareEqual((Object)opt.getValue(), (Object)currentValue)) continue;
                this.addSelectItem((UIComponent)input, textResolver, opt);
            }
            return;
        }
        if (hasEmpty && !emptyPresent) {
            this.addSelectItem((UIComponent)input, textResolver, new OptionEntry((Object)"", this.getNullText(ii)), 0);
        }
        while (oe != null) {
            if (oe.isActive() || ObjectUtils.compareEqual((Object)oe.getValue(), (Object)currentValue)) {
                this.addSelectItem((UIComponent)input, textResolver, oe);
            }
            oe = ioe.hasNext() ? (OptionEntry)ioe.next() : null;
        }
    }

    public void addSelectItem(UIComponent input, TextResolver textResolver, OptionEntry e, int pos) {
        UISelectItem selectItem = new UISelectItem();
        Object valueExpressionFlag = input.getAttributes().get(VALUE_EXPRESSION_FLAG);
        Object value = ObjectUtils.getBoolean(valueExpressionFlag) ? this.formatInputValue(e.getValue()) : e.getValueString();
        selectItem.setItemValue(value);
        String text = e.getText();
        text = textResolver.resolveText(text);
        selectItem.setItemLabel(text);
        if (pos >= 0) {
            input.getChildren().add(pos, selectItem);
        } else {
            input.getChildren().add(selectItem);
        }
    }

    public void addSelectItem(UIComponent input, TextResolver textResolver, OptionEntry e) {
        this.addSelectItem(input, textResolver, e, -1);
    }

    protected String getNullText(InputControl.InputInfo ii) {
        String nullText = this.getFormatString(ii, "null:", "format:null");
        return nullText != null ? ii.getText(nullText) : "";
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi) {
        Object attrValue;
        Column column;
        if (vi.getOptions() == null) {
            log.warn("Select field {} has no Option list attached!", (Object)vi.getColumn().getName());
            return super.formatValue(value, vi);
        }
        if (this.hasFormatOption(vi, "short") && (column = vi.getColumn()) != null && (attrValue = column.getAttribute(COLATTR_ABBR_OPTIONS)) instanceof Options) {
            String text = ((Options)attrValue).get(value);
            if (StringUtils.isNotEmpty((String)text)) {
                return vi.getText(text);
            }
            if (value != null) {
                log.error("The element '" + String.valueOf(value) + "' is not part of the supplied option list.");
            }
        }
        return super.formatValue(value, vi);
    }

    @Override
    protected Object formatInputValue(Object value, InputControl.InputInfo ii) {
        Class enumType;
        if (value instanceof Number && (enumType = ii.getColumn().getEnumType()) != null) {
            Enum enumVal = ObjectUtils.getEnum((Class)enumType, (Object)value);
            value = enumVal.name();
        }
        return this.formatInputValue(value);
    }

    protected Object formatInputValue(Object value) {
        if (value != null && value.getClass().isEnum()) {
            return ((Enum)value).name();
        }
        return value;
    }

    @Override
    protected Object parseInputValue(String value, InputControl.InputInfo ii) {
        Class enumType = ii.getColumn().getEnumType();
        if (enumType != null) {
            return ObjectUtils.getEnum((Class)enumType, (Object)value);
        }
        return value;
    }
}

