/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.FacesWrapper;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.data.Record;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.FieldNotNullException;
import org.apache.empire.exceptions.BeanPropertyGetException;
import org.apache.empire.exceptions.BeanPropertySetException;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.jsf2.app.FacesApplication;
import org.apache.empire.jsf2.app.FacesUtils;
import org.apache.empire.jsf2.app.TextResolver;
import org.apache.empire.jsf2.components.ControlTag;
import org.apache.empire.jsf2.components.InputTag;
import org.apache.empire.jsf2.components.LinkTag;
import org.apache.empire.jsf2.components.RecordTag;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.controls.InputControlManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagEncodingHelper
implements NamingContainer {
    private static final Logger log = LoggerFactory.getLogger(TagEncodingHelper.class);
    public static final String COLATTR_ABBR_TITLE = "ABBR_TITLE";
    private final UIOutput tag;
    private final String tagCssStyle;
    private Column column = null;
    private Object record = null;
    private RecordTag recordTag = null;
    private Boolean hasValueExpr = null;
    private InputControl control = null;
    private TextResolver textResolver = null;
    private Object mostRecentValue = null;
    private boolean skipValidation = false;
    private boolean hasError = false;
    private static final String CC_ATTR_EXPR = "#{cc.attrs.";
    public static final String CSS_DATA_TYPE_NONE = "";
    public static final String CSS_DATA_TYPE_IDENT = " eTypeIdent";
    public static final String CSS_DATA_TYPE_NUMBER = " eTypeNumber";
    public static final String CSS_DATA_TYPE_TEXT = " eTypeText";
    public static final String CSS_DATA_TYPE_LONGTEXT = " eTypeLongText";
    public static final String CSS_DATA_TYPE_DATE = " eTypeDate";
    public static final String CSS_DATA_TYPE_BOOL = " eTypeBool";

    public TagEncodingHelper(UIOutput tag, String tagCssStyle) {
        this.tag = tag;
        this.tagCssStyle = tagCssStyle;
    }

    public void encodeBegin() {
        if (this.tag instanceof UIInput && ((UIInput)this.tag).isLocalValueSet()) {
            if (log.isDebugEnabled()) {
                log.debug("clearing local value for {}. value is {}.", (Object)this.getColumnName(), ((UIInput)this.tag).getLocalValue());
            }
            ((UIInput)this.tag).setValue(null);
            ((UIInput)this.tag).setLocalValueSet(false);
        }
    }

    public InputControl getInputControl() {
        Object attr;
        if (this.control != null) {
            this.checkRecord();
            return this.control;
        }
        if (this.getColumn() == null) {
            throw new NotSupportedException((Object)this, "getInputControl");
        }
        String controlType = this.getTagAttributeString("controlType");
        if (controlType == null && "text".equalsIgnoreCase(controlType = this.column.getControlType()) && (attr = this.getTagAttributeValue("options")) != null && attr instanceof Options && !((Options)attr).isEmpty()) {
            controlType = "select";
        }
        if (StringUtils.isNotEmpty((String)controlType)) {
            this.control = InputControlManager.getControl(controlType);
        }
        if (this.control == null) {
            if (this.getValueOptions() != null) {
                controlType = "select";
            } else {
                DataType dataType = this.column.getDataType();
                controlType = FacesUtils.getFacesApplication().getDefaultControlType(dataType);
            }
            this.control = InputControlManager.getControl(controlType);
            if (this.control == null) {
                this.control = InputControlManager.getControl("text");
            }
            if (log.isDebugEnabled() && !controlType.equals("text")) {
                log.debug("Auto-detected field control for " + this.column.getName() + " is " + controlType);
            }
        }
        this.checkRecord();
        return this.control;
    }

    private void checkRecord() {
        if (this.record == null) {
            return;
        }
        Object rec = this.getTagAttributeValue("record");
        if (rec != null) {
            if (rec != this.record) {
                if (log.isTraceEnabled()) {
                    if (rec instanceof DBRecord && this.record instanceof DBRecord) {
                        String keyOld = StringUtils.toString((Object[])((DBRecord)this.record).getKeyValues());
                        String keyNew = StringUtils.toString((Object[])((DBRecord)rec).getKeyValues());
                        String rowSet = StringUtils.valueOf((Object)((DBRecord)rec).getRowSet().getName());
                        log.trace("Changing " + this.tag.getClass().getSimpleName() + " record of rowset " + rowSet + " from {} to {}", (Object)keyOld, (Object)keyNew);
                    } else {
                        log.trace("Changing " + this.tag.getClass().getSimpleName() + " record of class " + rec.getClass().getSimpleName());
                    }
                }
                this.setRecord(rec);
            }
        } else if (this.recordTag != null) {
            rec = this.recordTag.getRecord();
            if (rec != this.record) {
                this.setRecord(rec);
            }
        } else if (!(this.record instanceof Record)) {
            this.record = null;
        }
    }

    public InputControl.ValueInfo getValueInfo(FacesContext ctx) {
        return new ValueInfoImpl(this.getColumn(), this.getTextResolver(ctx));
    }

    public InputControl.InputInfo getInputInfo(FacesContext ctx) {
        this.skipValidation = FacesUtils.isSkipInputValidation(ctx);
        this.hasError = this.detectError(ctx);
        return new InputInfoImpl(this.getColumn(), this.getTextResolver(ctx));
    }

    public boolean isPartialSubmit(FacesContext ctx) {
        return FacesUtils.getFacesApplication().isPartialSubmit(ctx);
    }

    public boolean isSkipValidation() {
        return this.skipValidation;
    }

    public boolean hasColumn() {
        if (this.column == null) {
            this.column = this.findColumn();
        }
        return this.column != null;
    }

    public Column getColumn() {
        if (this.column == null) {
            this.column = this.findColumn();
        }
        if (this.column == null) {
            throw new InvalidArgumentException("column", (Object)this.column);
        }
        return this.column;
    }

    public String getColumnName() {
        return this.getColumn() != null ? this.column.getName() : "null";
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Object getRecord() {
        if (this.record == null) {
            this.record = this.findRecord();
        }
        return this.record;
    }

    public void setRecord(Object record) {
        this.record = record;
        this.mostRecentValue = null;
    }

    public RecordTag getRecordComponent() {
        if (this.recordTag != null) {
            return this.recordTag;
        }
        if (this.record != null || (this.record = this.getTagAttributeValue("record")) != null) {
            return null;
        }
        UIOutput parent = this.tag;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof RecordTag)) continue;
            this.recordTag = (RecordTag)parent;
            return this.recordTag;
        }
        return null;
    }

    private boolean isDetectFieldChange() {
        Object v = this.getTagAttributeValue("detectFieldChange");
        if (v == null && this.recordTag != null) {
            v = this.recordTag.getAttributes().get("detectFieldChange");
        }
        return v != null ? ObjectUtils.getBoolean((Object)v) : true;
    }

    public Object getDataValue(boolean evalExpression) {
        if (this.getRecord() != null) {
            if (this.record instanceof RecordData) {
                this.mostRecentValue = ((RecordData)this.record).getValue((ColumnExpr)this.getColumn());
                return this.mostRecentValue;
            }
            String prop = this.getColumn().getBeanPropertyName();
            return this.getBeanPropertyValue(this.record, prop);
        }
        if (evalExpression) {
            return this.tag.getValue();
        }
        Object value = this.tag.getLocalValue();
        if (value != null && this.tag instanceof UIInput && !((UIInput)this.tag).isLocalValueSet()) {
            value = null;
        }
        if (value == null) {
            value = this.findValueExpression("value", false);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataValue(Object value) {
        if (this.getRecord() != null) {
            if (this.record instanceof Record) {
                Object currentValue;
                this.getColumn();
                if (this.isDetectFieldChange() && !ObjectUtils.compareEqual((Object)(currentValue = ((Record)this.record).getValue((ColumnExpr)this.column)), (Object)this.mostRecentValue)) {
                    log.info("Concurrent data change for " + this.column.getName() + ". Current Value is {}. Ignoring new value {}", currentValue, value);
                    return;
                }
                boolean reenableValidation = false;
                if (this.skipValidation && this.record instanceof DBRecord) {
                    if (this.isReadOnly()) {
                        return;
                    }
                    if (this.column.isRequired() && ObjectUtils.isEmpty((Object)value)) {
                        return;
                    }
                    reenableValidation = ((DBRecord)this.record).isValidateFieldValues();
                    if (reenableValidation) {
                        ((DBRecord)this.record).setValidateFieldValues(false);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Input Validation skipped for {}.", (Object)this.column.getName());
                    }
                }
                try {
                    ((Record)this.record).setValue(this.column, value);
                    this.mostRecentValue = value;
                }
                finally {
                    if (reenableValidation) {
                        ((DBRecord)this.record).setValidateFieldValues(true);
                    }
                }
            } else {
                if (this.record instanceof RecordData) {
                    throw new PropertyReadOnlyException("record");
                }
                String prop = this.getColumn().getBeanPropertyName();
                this.setBeanPropertyValue(this.record, prop, value);
            }
        } else {
            ValueExpression ve = this.tag.getValueExpression("value");
            if (ve == null) {
                throw new PropertyReadOnlyException("value");
            }
            FacesContext ctx = FacesContext.getCurrentInstance();
            ve.setValue(ctx.getELContext(), value);
        }
    }

    public boolean isRecordReadOnly() {
        if (!(this.tag instanceof UIInput)) {
            return true;
        }
        Object val = this.getTagAttributeValue("readonly");
        if (val != null && ObjectUtils.getBoolean((Object)val)) {
            return true;
        }
        if (this.getRecord() instanceof RecordData ? !(this.record instanceof Record) || ((Record)this.record).isReadOnly() : !this.hasValueExpression()) {
            return true;
        }
        return this.recordTag != null && this.recordTag.isReadOnly();
    }

    public boolean isVisible() {
        if (this.record != null && this.getTagAttributeValue("record") instanceof Record) {
            this.record = null;
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isFieldVisible(this.getColumn());
        }
        return true;
    }

    public boolean isReadOnly() {
        Object val = this.getAttributeValueEx("disabled");
        if (val != null && ObjectUtils.getBoolean((Object)val)) {
            return true;
        }
        if (this.isRecordReadOnly()) {
            return true;
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isFieldReadOnly(this.getColumn());
        }
        return this.getColumn().isReadOnly();
    }

    public boolean isValueRequired() {
        Object mandatory = this.getTagAttributeValue("mandatory");
        if (mandatory != null) {
            return ObjectUtils.getBoolean((Object)mandatory);
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (this.getRecord() instanceof Record) {
            Record r = (Record)this.record;
            return r.isFieldRequired(this.getColumn());
        }
        if (this.hasValueExpression()) {
            return false;
        }
        return this.getColumn().isRequired();
    }

    public boolean isTempoaryNullable() {
        return !this.getColumn().isRequired();
    }

    protected Column findColumn() {
        Object col = this.getTagAttributeValue("column");
        if (col instanceof Column) {
            return (Column)col;
        }
        if (col instanceof String) {
            String name = String.valueOf(col);
            int dbix = name.indexOf(46);
            if (dbix <= 0) {
                log.error("Invalid column expression '{}'!", (Object)name);
                return null;
            }
            DBDatabase db = DBDatabase.findById((String)name.substring(0, dbix));
            if (db == null) {
                log.error("Database '{}' not found!", (Object)name.substring(0, dbix));
                return null;
            }
            int co = name.lastIndexOf(46);
            int to = name.lastIndexOf(46, co - 1);
            String cn = name.substring(co + 1);
            String tn = name.substring(to + 1, co);
            DBRowSet rs = db.getRowSet(tn);
            if (rs == null) {
                log.error("Table/View '{}' not found in database!", (Object)tn);
                return null;
            }
            DBColumn column = rs.getColumn(cn);
            if (column == null) {
                log.error("Column '{}' not found in table/view '{}'!", (Object)cn, (Object)tn);
                return null;
            }
            return column;
        }
        if (col == null) {
            col = this.tag.getValue();
            if (col instanceof Column) {
                return (Column)col;
            }
            if (col instanceof ColumnExpr) {
                Column source = ((ColumnExpr)col).getSourceColumn();
                if (source != null) {
                    return source;
                }
                return new ColumnExprWrapper((ColumnExpr)col);
            }
        }
        if (log.isDebugEnabled() && !(this.tag instanceof LinkTag)) {
            log.warn("No Column provided for value tag!");
        }
        return null;
    }

    protected Object findRecord() {
        Object rec = this.getTagAttributeValue("record");
        if (rec != null) {
            return rec;
        }
        if (this.hasValueExpression()) {
            return null;
        }
        RecordTag recordComponent = this.getRecordComponent();
        if (recordComponent != null) {
            rec = recordComponent.getRecord();
        } else if (this.tag instanceof ControlTag && !((ControlTag)this.tag).isCustomInput()) {
            log.warn("No record supplied for {} and column {}.", (Object)this.tag.getClass().getSimpleName(), (Object)this.getColumnName());
        }
        return rec;
    }

    protected boolean hasValueExpression() {
        if (this.hasValueExpr != null) {
            return this.hasValueExpr;
        }
        ValueExpression ve = this.findValueExpression("value", false);
        if (ve != null && log.isDebugEnabled()) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            boolean readOnly = ve.isReadOnly(ctx.getELContext());
            if (readOnly) {
                log.debug(this.tag.getClass().getSimpleName() + " for " + this.getColumnName() + " expression " + ve.getExpressionString() + " is readOnly!");
            } else {
                log.debug(this.tag.getClass().getSimpleName() + " for " + this.getColumnName() + " expression " + ve.getExpressionString() + " is updateable!");
            }
        }
        this.hasValueExpr = ve != null;
        return this.hasValueExpr;
    }

    protected ValueExpression findValueExpression(String attribute, boolean allowLiteral) {
        ValueExpression ve = this.tag.getValueExpression(attribute);
        if (ve == null) {
            return null;
        }
        UIOutput parent = this.tag;
        String expr = ve.getExpressionString();
        while (expr.startsWith(CC_ATTR_EXPR)) {
            UIComponent valueParent;
            if (ve instanceof FacesWrapper) {
                ve = (ValueExpression)((FacesWrapper)ve).getWrapped();
            }
            if ((parent = (valueParent = FacesUtils.getFacesApplication().getFacesImplementation().getValueParentComponent(ve)) != null ? valueParent : UIComponent.getCompositeComponentParent((UIComponent)parent)) == null) {
                return null;
            }
            int end = expr.indexOf(125);
            String attrib = expr.substring(CC_ATTR_EXPR.length(), end);
            if (attrib.indexOf(46) > 0) {
                return ve;
            }
            ValueExpression next = parent.getValueExpression(attrib);
            if (next == null) {
                if (allowLiteral && parent.getAttributes().get(attrib) != null) {
                    return ve;
                }
                return null;
            }
            ve = next;
            expr = ve.getExpressionString();
        }
        return ve;
    }

    protected Options getValueOptions() {
        Object attr = this.getTagAttributeValue("options");
        if (attr != null && attr instanceof Options) {
            return (Options)attr;
        }
        if (this.getColumn() != null) {
            if (this.getRecord() instanceof Record) {
                return ((Record)this.record).getFieldOptions(this.column);
            }
            return this.column.getOptions();
        }
        return null;
    }

    protected Object getBeanPropertyValue(Object bean, String property) {
        try {
            PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
            return pub.getSimpleProperty(bean, property);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn(bean.getClass().getName() + ": no getter available for property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
    }

    protected void setBeanPropertyValue(Object bean, String property, Object value) {
        try {
            if (ObjectUtils.isEmpty((Object)value)) {
                value = null;
            }
            if (value != null) {
                BeanUtils.setProperty((Object)bean, (String)property, (Object)value);
            } else {
                PropertyUtils.setProperty((Object)bean, (String)property, null);
            }
        }
        catch (IllegalArgumentException e) {
            log.error(bean.getClass().getName() + ": invalid argument for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error(bean.getClass().getName() + ": no setter available for property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
    }

    public String getValueTooltip(Object value) {
        String text;
        Options options;
        if (value == null) {
            return null;
        }
        String templ = StringUtils.valueOf((Object)value);
        int valIndex = templ.indexOf("{}");
        if (valIndex >= 0) {
            value = this.getDataValue(true);
        }
        if ((options = this.getValueOptions()) != null && !this.hasFormat("notitlelookup")) {
            String optValue = options.get(value);
            text = this.getDisplayText(optValue);
        } else {
            text = this.getDisplayText(StringUtils.toString((Object)value));
        }
        if (valIndex >= 0 && text != null) {
            text = StringUtils.replace((String)templ, (String)"{}", (String)text);
        }
        return text;
    }

    public String getLabelTooltip(Column column) {
        String title = this.getTagAttributeString("title");
        if (title != null) {
            return this.getDisplayText(title);
        }
        if (this.hasFormat("short") && !ObjectUtils.isEmpty((Object)column.getAttribute(COLATTR_ABBR_TITLE))) {
            return this.getDisplayText(column.getTitle());
        }
        return null;
    }

    public boolean hasFormat(String format) {
        String f = this.getTagAttributeString("format");
        return f != null && f.indexOf(format) >= 0;
    }

    public boolean hasFormat(InputControl.ValueInfo vi, String format) {
        String f = vi.getFormat();
        return f != null && f.indexOf(format) >= 0;
    }

    public void writeAttribute(ResponseWriter writer, String attribute, Object value) throws IOException {
        if (value != null) {
            writer.writeAttribute(attribute, value, null);
        }
    }

    public String getDisplayText(String text) {
        if (this.textResolver == null) {
            this.getTextResolver(FacesContext.getCurrentInstance());
        }
        return this.textResolver.resolveText(text);
    }

    public TextResolver getTextResolver(FacesContext context) {
        if (this.textResolver == null) {
            this.textResolver = ((FacesApplication)context.getApplication()).getTextResolver(context);
        }
        return this.textResolver;
    }

    private boolean detectError(FacesContext context) {
        Iterator iter = context.getMessages(this.tag.getClientId());
        while (iter.hasNext()) {
            FacesMessage m = (FacesMessage)iter.next();
            if (m.getSeverity() != FacesMessage.SEVERITY_ERROR) continue;
            return true;
        }
        return false;
    }

    public void addErrorMessage(FacesContext context, Exception e) {
        String msgText = this.getTextResolver(context).getExceptionMessage(e);
        FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msgText, msgText);
        context.addMessage(this.tag.getClientId(), msg);
    }

    public Object getAttributeValueEx(String name) {
        Object value = this.getTagAttributeValue(name);
        if (value == null) {
            value = this.getColumn().getAttribute(name);
        }
        if (value instanceof Column) {
            Column col = (Column)value;
            Object rec = this.getRecord();
            if (rec instanceof Record) {
                return ((Record)rec).getValue((ColumnExpr)col);
            }
            if (rec != null) {
                String property = col.getBeanPropertyName();
                try {
                    PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
                    return pub.getSimpleProperty(rec, property);
                }
                catch (Exception e) {
                    log.error("BeanUtils.getSimpleProperty failed for " + property, (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        return value;
    }

    public Object getTagAttributeValue(String name) {
        ValueExpression ve;
        Object value = this.tag.getAttributes().get(name);
        if (value == null && (ve = this.tag.getValueExpression(name)) != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            value = ve.getValue(ctx.getELContext());
        }
        return value;
    }

    public String getTagAttributeString(String name, String defValue) {
        Object v = this.getTagAttributeValue(name);
        return v != null ? StringUtils.toString((Object)v) : defValue;
    }

    public String getTagAttributeString(String name) {
        return this.getTagAttributeString(name, null);
    }

    protected String getLabelValue(Column column, boolean colon) {
        String label = this.getTagAttributeString("label");
        if (label == null) {
            if (this.hasFormat("short") && (label = StringUtils.toString((Object)column.getAttribute(COLATTR_ABBR_TITLE))) == null) {
                log.warn("No Abbreviation available for column {}. Using normal title.", (Object)column.getName());
            }
            if (label == null) {
                label = column.getTitle();
            }
            label = this.getDisplayText(label);
        }
        if (StringUtils.isEmpty((String)label)) {
            return CSS_DATA_TYPE_NONE;
        }
        if (colon) {
            label = label.trim() + ":";
        }
        return label;
    }

    public HtmlOutputLabel createLabelComponent(FacesContext context, String forInput, String styleClass, String style, boolean colon) {
        String title;
        HtmlOutputLabel label;
        Column column = null;
        boolean readOnly = false;
        boolean required = false;
        if (StringUtils.isNotEmpty((String)forInput) && !forInput.equals("*")) {
            UIComponent input = FacesUtils.getFacesApplication().findComponent(context, forInput, (UIComponent)this.tag);
            if (input != null && input instanceof InputTag) {
                InputTag inputTag = (InputTag)input;
                column = inputTag.getInputColumn();
                readOnly = inputTag.isInputReadOnly();
                required = inputTag.isInputRequired();
            } else {
                log.warn("Input component {} not found for label {}.", (Object)forInput, (Object)this.getColumn().getName());
            }
        }
        if (column == null) {
            column = this.getColumn();
            required = this.isValueRequired();
        }
        if (column == null) {
            throw new InvalidArgumentException("column", (Object)column);
        }
        try {
            label = InputControlManager.getLabelComponentClass().newInstance();
        }
        catch (InstantiationException e1) {
            throw new InternalException((Throwable)e1);
        }
        catch (IllegalAccessException e2) {
            throw new InternalException((Throwable)e2);
        }
        String labelText = this.getLabelValue(column, colon);
        if (StringUtils.isEmpty((String)labelText)) {
            label.setRendered(false);
        } else {
            label.setValue((Object)labelText);
        }
        if (StringUtils.isNotEmpty((String)styleClass)) {
            label.setStyleClass(styleClass);
        }
        if (StringUtils.isNotEmpty((String)forInput) && !readOnly) {
            InputControl.InputInfo ii = this.getInputInfo(context);
            String inputId = this.getInputControl().getLabelForId(ii);
            if (StringUtils.isNotEmpty((String)inputId)) {
                if (forInput.equals("*")) {
                    label.setFor(inputId);
                } else {
                    label.setFor(forInput + ":" + inputId);
                }
            } else {
                log.info("No input-id provided for {}.", (Object)this.getColumn().getName());
            }
        }
        if (StringUtils.isNotEmpty((String)style)) {
            label.setStyle(style);
        }
        if ((title = this.getLabelTooltip(column)) != null) {
            label.setTitle(title);
        }
        if (required) {
            this.addRequiredMark(label);
        }
        return label;
    }

    public void updateLabelComponent(FacesContext context, HtmlOutputLabel label, String forInput) {
        boolean required;
        UIComponent input;
        boolean hasMark = label.getChildCount() > 0;
        InputTag inputTag = null;
        if (StringUtils.isNotEmpty((String)forInput) && !forInput.equals("*") && (input = FacesUtils.getFacesApplication().findComponent(context, forInput, (UIComponent)this.tag)) != null && input instanceof InputTag) {
            inputTag = (InputTag)input;
        }
        boolean bl = required = inputTag != null ? inputTag.isInputRequired() : this.isValueRequired();
        if (required == hasMark) {
            return;
        }
        if (required) {
            this.addRequiredMark(label);
        } else {
            label.getChildren().clear();
        }
    }

    protected void addRequiredMark(HtmlOutputLabel label) {
        HtmlPanelGroup span = new HtmlPanelGroup();
        span.setStyleClass("required");
        HtmlOutputText text = new HtmlOutputText();
        text.setValue((Object)"*");
        span.getChildren().add(text);
        label.getChildren().add(span);
    }

    public static final String getTagStyleClass(String tagCssStyle, String typeClass, String addlStyle, String userStyle) {
        if (StringUtils.isEmpty((String)userStyle) && StringUtils.isEmpty((String)addlStyle)) {
            return StringUtils.isEmpty((String)typeClass) ? tagCssStyle : tagCssStyle + typeClass;
        }
        StringBuilder b = new StringBuilder(tagCssStyle);
        if (StringUtils.isNotEmpty((String)typeClass)) {
            b.append(typeClass);
        }
        if (StringUtils.isNotEmpty((String)addlStyle)) {
            b.append(" ");
            b.append(addlStyle);
        }
        if (StringUtils.isNotEmpty((String)userStyle)) {
            b.append(" ");
            b.append(userStyle);
        }
        return b.toString();
    }

    public static final String getDataTypeClass(DataType type) {
        switch (type) {
            case AUTOINC: {
                return CSS_DATA_TYPE_IDENT;
            }
            case INTEGER: 
            case DECIMAL: 
            case FLOAT: {
                return CSS_DATA_TYPE_NUMBER;
            }
            case TEXT: 
            case CHAR: {
                return CSS_DATA_TYPE_TEXT;
            }
            case DATE: 
            case DATETIME: {
                return CSS_DATA_TYPE_DATE;
            }
            case BOOL: {
                return CSS_DATA_TYPE_BOOL;
            }
            case CLOB: {
                return CSS_DATA_TYPE_LONGTEXT;
            }
        }
        return CSS_DATA_TYPE_NONE;
    }

    public final String getTagStyleClass(DataType dataType, String addlStyle, String userStyle) {
        String typeClass = TagEncodingHelper.getDataTypeClass(dataType);
        return TagEncodingHelper.getTagStyleClass(this.tagCssStyle, typeClass, addlStyle, userStyle);
    }

    public final String getTagStyleClass(DataType dataType, String addlStyle) {
        String userStyle = this.getTagAttributeString("styleClass");
        String typeClass = TagEncodingHelper.getDataTypeClass(dataType);
        return TagEncodingHelper.getTagStyleClass(this.tagCssStyle, typeClass, addlStyle, userStyle);
    }

    public final String getTagStyleClass(String addlStyle) {
        String userStyle = this.getTagAttributeString("styleClass");
        String typeClass = this.hasColumn() ? TagEncodingHelper.getDataTypeClass(this.column.getDataType()) : null;
        return TagEncodingHelper.getTagStyleClass(this.tagCssStyle, typeClass, addlStyle, userStyle);
    }

    public final String getTagStyleClass() {
        String userStyle = this.getTagAttributeString("styleClass");
        String typeClass = this.hasColumn() ? TagEncodingHelper.getDataTypeClass(this.column.getDataType()) : null;
        return TagEncodingHelper.getTagStyleClass(this.tagCssStyle, typeClass, null, userStyle);
    }

    private class InputInfoImpl
    extends ValueInfoImpl
    implements InputControl.InputInfo {
        public InputInfoImpl(Column column, TextResolver resolver) {
            super(column, resolver);
        }

        @Override
        public void setValue(Object value) {
            TagEncodingHelper.this.setDataValue(value);
        }

        @Override
        public void validate(Object value) {
            if (TagEncodingHelper.this.skipValidation) {
                return;
            }
            boolean isNull = ObjectUtils.isEmpty((Object)value);
            if (isNull) {
                if (this.isRequired()) {
                    throw new FieldNotNullException(TagEncodingHelper.this.column);
                }
                return;
            }
            if (TagEncodingHelper.this.getRecord() instanceof Record) {
                ((Record)TagEncodingHelper.this.getRecord()).validateValue(TagEncodingHelper.this.column, value);
            } else {
                TagEncodingHelper.this.column.validate(value);
            }
        }

        @Override
        public boolean isRequired() {
            return TagEncodingHelper.this.isValueRequired();
        }

        @Override
        public boolean isDisabled() {
            return TagEncodingHelper.this.isReadOnly();
        }

        @Override
        public boolean isFieldReadOnly() {
            if (TagEncodingHelper.this.isRecordReadOnly()) {
                return true;
            }
            if (TagEncodingHelper.this.getRecord() instanceof Record) {
                Record r = (Record)TagEncodingHelper.this.record;
                return r.isFieldReadOnly(this.getColumn());
            }
            return this.getColumn().isReadOnly();
        }

        @Override
        public String getInputId() {
            Column c = this.getColumn();
            return c.getName();
        }

        @Override
        public String getStyleClass(String addlStyle) {
            String style = TagEncodingHelper.this.getTagStyleClass(addlStyle);
            return style;
        }

        @Override
        public boolean hasError() {
            return TagEncodingHelper.this.hasError;
        }

        @Override
        public Object getAttribute(String name) {
            return TagEncodingHelper.this.getTagAttributeValue(name);
        }

        @Override
        public Object getAttributeEx(String name) {
            return TagEncodingHelper.this.getAttributeValueEx(name);
        }
    }

    private class ValueInfoImpl
    implements InputControl.ValueInfo {
        public ValueInfoImpl(Column column, TextResolver resolver) {
            if (column == null) {
                throw new InvalidArgumentException("column", (Object)resolver);
            }
            if (resolver == null) {
                throw new InvalidArgumentException("resolver", (Object)resolver);
            }
        }

        private boolean hasColumn() {
            return TagEncodingHelper.this.column != null || this.getColumn() != null;
        }

        @Override
        public Column getColumn() {
            return TagEncodingHelper.this.column;
        }

        @Override
        public Object getValue(boolean evalExpression) {
            return TagEncodingHelper.this.getDataValue(evalExpression);
        }

        @Override
        public Options getOptions() {
            return TagEncodingHelper.this.getValueOptions();
        }

        @Override
        public String getFormat() {
            Object format;
            String attr = TagEncodingHelper.this.getTagAttributeString("format");
            if (attr != null) {
                return attr;
            }
            if (this.hasColumn() && (format = TagEncodingHelper.this.column.getAttribute("format")) != null) {
                return format.toString();
            }
            return null;
        }

        @Override
        public Locale getLocale() {
            return TagEncodingHelper.this.textResolver.getLocale();
        }

        @Override
        public String getText(String text) {
            return TagEncodingHelper.this.textResolver.resolveText(text);
        }

        @Override
        public TextResolver getTextResolver() {
            return TagEncodingHelper.this.textResolver;
        }
    }

    private static class ColumnExprWrapper
    implements Column {
        private final ColumnExpr expr;

        public ColumnExprWrapper(ColumnExpr expr) {
            this.expr = expr;
        }

        public DataType getDataType() {
            return this.expr.getDataType();
        }

        public String getName() {
            return this.expr.getName();
        }

        public String getTitle() {
            return this.expr.getTitle();
        }

        public String getControlType() {
            return this.expr.getControlType();
        }

        public Object getAttribute(String name) {
            return this.expr.getAttribute(name);
        }

        public Options getOptions() {
            return this.expr.getOptions();
        }

        public String getBeanPropertyName() {
            return this.expr.getBeanPropertyName();
        }

        public Column getSourceColumn() {
            return this.expr.getSourceColumn();
        }

        public double getSize() {
            return 0.0;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object validate(Object value) {
            log.warn("validate not supported for {}", (Object)this.expr.getName());
            return value;
        }
    }
}

