/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pages;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageNavigationHandler
extends ConfigurableNavigationHandler {
    private static final Logger log = LoggerFactory.getLogger(PageNavigationHandler.class);
    private static boolean initialized = false;
    private NavigationHandler parent;

    public static boolean isInitialized() {
        return initialized;
    }

    public PageNavigationHandler(NavigationHandler parent) {
        this.parent = parent;
        initialized = true;
        log.info("PageNavigatonHandler sucessfully established.");
    }

    public void handleNavigation(FacesContext context, String from, String outcome) {
        boolean redirect;
        this.parent.handleNavigation(context, from, outcome);
        if (outcome == null) {
            return;
        }
        NavigationCase navigationCase = this.getNavigationCase(context, from, outcome);
        boolean bl = navigationCase != null ? navigationCase.isRedirect() : (redirect = outcome.indexOf("faces-redirect=true") >= 0);
        if (!redirect) {
            log.debug("Handling forward navigation.");
            UIViewRoot viewRoot = context.getViewRoot();
            Map viewMap = viewRoot.getViewMap();
            Map<String, String> paramsMap = this.getActionParameterMap(outcome);
            if (paramsMap != null) {
                log.debug("Setting FORWARD_PAGE_PARAMS for outcome {}.", (Object)outcome);
                viewMap.put("forwardPageParams", paramsMap);
            }
        }
    }

    private Map<String, String> getActionParameterMap(String s) {
        int i = -1;
        HashMap<String, String> map = null;
        while ((i = s.indexOf(61, i + 1)) > 0) {
            int n = s.lastIndexOf(38, i);
            if (n < 0) {
                n = s.lastIndexOf(63, i);
            }
            if (n < 0) continue;
            int v = s.indexOf(38, i);
            String name = s.substring(n + 1, i);
            String value = v > i ? s.substring(i + 1, v) : s.substring(i + 1);
            log.debug("Adding view parameter '{}' with value '{}'.", (Object)name, (Object)value);
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put(name, value);
        }
        return map;
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        if (this.parent instanceof ConfigurableNavigationHandler) {
            NavigationCase navigationCase = ((ConfigurableNavigationHandler)this.parent).getNavigationCase(context, fromAction, outcome);
            return navigationCase;
        }
        return null;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this.parent instanceof ConfigurableNavigationHandler) {
            return ((ConfigurableNavigationHandler)this.parent).getNavigationCases();
        }
        return null;
    }
}

