/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.pageelements;

import java.util.List;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.jsf2.pageelements.BeanListPageElement;
import org.apache.empire.jsf2.pageelements.ListPageElement;
import org.apache.empire.jsf2.pages.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticListPageElement<T>
extends ListPageElement<T> {
    private static final Logger log = LoggerFactory.getLogger(BeanListPageElement.class);
    private static final long serialVersionUID = 1L;
    private ListPageElement.ListTableInfo listTableInfo = new ListPageElement.ListTableInfo();

    public StaticListPageElement(Page page, Class<T> beanClass, String propertyName) {
        super(page, beanClass, propertyName);
    }

    @Override
    protected void onInitPage() {
        if (this.items == null) {
            log.error("StaticListPageElement has not been intialized! Please initialize in doInit() before calling super.doInit()!");
            throw new ObjectNotValidException((Object)this);
        }
    }

    @Override
    public ListPageElement.ListTableInfo getTableInfo() {
        return this.listTableInfo;
    }

    public void setItems(List<T> items) {
        this.clearItems();
        this.items = items;
        this.update();
    }

    public int size() {
        return this.items != null ? this.items.size() : 0;
    }

    public boolean contains(T item) {
        return this.items != null ? this.items.contains(item) : false;
    }

    public boolean add(T item) {
        if (this.items == null || this.items.contains(item)) {
            return false;
        }
        boolean added = this.items.add(item);
        if (added) {
            this.update();
        }
        return added;
    }

    public boolean add(T item, int index) {
        if (this.items == null || this.items.contains(item)) {
            return false;
        }
        this.items.add(index, item);
        this.update();
        return true;
    }

    public boolean move(T item, int index) {
        if (this.items == null || !this.items.contains(item)) {
            return false;
        }
        this.items.add(index, item);
        this.update();
        return true;
    }

    public boolean remove(T item) {
        if (this.items == null) {
            return false;
        }
        boolean removed = this.items.remove(item);
        if (removed) {
            this.update();
        }
        return removed;
    }

    public void update() {
        if (this.items != null) {
            this.getTableInfo().init(this.items.size(), 0);
        }
    }
}

